/*      */ package org.jboss.ws.tools.wsdl;
/*      */ 
/*      */ import java.io.File;
/*      */ import java.io.FileWriter;
/*      */ import java.io.IOException;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedHashMap;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.wsdl.Binding;
/*      */ import javax.wsdl.BindingInput;
/*      */ import javax.wsdl.BindingOperation;
/*      */ import javax.wsdl.BindingOutput;
/*      */ import javax.wsdl.Definition;
/*      */ import javax.wsdl.Fault;
/*      */ import javax.wsdl.Import;
/*      */ import javax.wsdl.Input;
/*      */ import javax.wsdl.Message;
/*      */ import javax.wsdl.Operation;
/*      */ import javax.wsdl.OperationType;
/*      */ import javax.wsdl.Output;
/*      */ import javax.wsdl.Part;
/*      */ import javax.wsdl.Port;
/*      */ import javax.wsdl.PortType;
/*      */ import javax.wsdl.Service;
/*      */ import javax.wsdl.Types;
/*      */ import javax.wsdl.WSDLException;
/*      */ import javax.wsdl.extensions.ElementExtensible;
/*      */ import javax.wsdl.extensions.ExtensibilityElement;
/*      */ import javax.wsdl.extensions.UnknownExtensibilityElement;
/*      */ import javax.wsdl.extensions.http.HTTPBinding;
/*      */ import javax.wsdl.extensions.mime.MIMEContent;
/*      */ import javax.wsdl.extensions.mime.MIMEMultipartRelated;
/*      */ import javax.wsdl.extensions.mime.MIMEPart;
/*      */ import javax.wsdl.extensions.schema.Schema;
/*      */ import javax.wsdl.extensions.soap.SOAPAddress;
/*      */ import javax.wsdl.extensions.soap.SOAPBinding;
/*      */ import javax.wsdl.extensions.soap.SOAPBody;
/*      */ import javax.wsdl.extensions.soap.SOAPHeader;
/*      */ import javax.wsdl.extensions.soap.SOAPOperation;
/*      */ import javax.wsdl.extensions.soap12.SOAP12Address;
/*      */ import javax.wsdl.extensions.soap12.SOAP12Binding;
/*      */ import javax.wsdl.extensions.soap12.SOAP12Body;
/*      */ import javax.wsdl.extensions.soap12.SOAP12Operation;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.ws.Constants;
/*      */ import org.jboss.ws.core.soap.Style;
/*      */ import org.jboss.ws.core.utils.ResourceURL;
/*      */ import org.jboss.ws.metadata.wsdl.Extendable;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem.Direction;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*      */ import org.jboss.ws.metadata.wsdl.XSModelTypes;
/*      */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*      */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*      */ import org.jboss.ws.tools.JavaToXSD;
/*      */ import org.jboss.wsf.common.DOMUtils;
/*      */ import org.jboss.wsf.common.DOMWriter;
/*      */ import org.w3c.dom.Attr;
/*      */ import org.w3c.dom.Document;
/*      */ import org.w3c.dom.Element;
/*      */ import org.w3c.dom.NamedNodeMap;
/*      */ import org.w3c.dom.Node;
/*      */ import org.w3c.dom.NodeList;
/*      */ 
/*      */ public class WSDL11Reader
/*      */ {
/*  127 */   private static final Logger log = Logger.getLogger(WSDL11Reader.class);
/*      */   private WSDLDefinitions destWsdl;
/*      */   private Map<String, QName> messagePartToElementMap;
/*      */   private Map<String, URL> schemaLocationsMap;
/*      */   private LinkedHashMap<QName, Binding> allBindings;
/*      */   private LinkedHashMap<QName, Binding> portTypeBindings;
/*      */   private List<File> tempFiles;
/*      */   private Map<QName, List<String>> skippedSWAParts;
/*      */   private Map<String, List<Service>> servicesByNamespace;
/*      */   private Map<String, List<Binding>> bindingsByNamespace;
/*      */   private Map<String, List<PortType>> portTypesByNamespace;
/*      */   private Map<String, List<Message>> messagesByNamespace;
/*      */ 
/*      */   public WSDL11Reader()
/*      */   {
/*  132 */     this.messagePartToElementMap = new HashMap();
/*      */ 
/*  135 */     this.schemaLocationsMap = new HashMap();
/*      */ 
/*  142 */     this.tempFiles = new ArrayList();
/*      */ 
/*  145 */     this.skippedSWAParts = new HashMap();
/*      */ 
/*  150 */     this.servicesByNamespace = new HashMap();
/*  151 */     this.bindingsByNamespace = new HashMap();
/*  152 */     this.portTypesByNamespace = new HashMap();
/*  153 */     this.messagesByNamespace = new HashMap();
/*      */   }
/*      */ 
/*      */   public WSDLDefinitions processDefinition(Definition srcWsdl, URL wsdlLoc)
/*      */     throws IOException, WSDLException
/*      */   {
/*  164 */     log.trace("processDefinition: " + wsdlLoc);
/*      */ 
/*  166 */     this.destWsdl = new WSDLDefinitions();
/*  167 */     this.destWsdl.setWsdlTypes(new XSModelTypes());
/*  168 */     this.destWsdl.setWsdlOneOneDefinition(srcWsdl);
/*  169 */     this.destWsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
/*      */ 
/*  171 */     processNamespaces(srcWsdl);
/*  172 */     processTopLevelElements(srcWsdl);
/*  173 */     processTypes(srcWsdl, wsdlLoc);
/*  174 */     processUnknownExtensibilityElements(srcWsdl, this.destWsdl);
/*  175 */     processServices(srcWsdl);
/*      */ 
/*  177 */     if (getAllDefinedBindings(srcWsdl).size() != this.destWsdl.getBindings().length) {
/*  178 */       processUnreachableBindings(srcWsdl);
/*      */     }
/*  180 */     cleanupTemporaryFiles();
/*      */ 
/*  182 */     return this.destWsdl;
/*      */   }
/*      */ 
/*      */   private void processTopLevelElements(Definition srcWsdl)
/*      */   {
/*  187 */     String targetNS = srcWsdl.getTargetNamespace();
/*      */ 
/*  190 */     Collection messages = srcWsdl.getMessages().values();
/*  191 */     for (Message message : messages)
/*      */     {
/*  193 */       List list = (List)this.messagesByNamespace.get(targetNS);
/*  194 */       if (list == null)
/*      */       {
/*  196 */         list = new ArrayList();
/*  197 */         this.messagesByNamespace.put(targetNS, list);
/*      */       }
/*  199 */       if (!message.isUndefined()) {
/*  200 */         list.add(message);
/*      */       }
/*      */     }
/*      */ 
/*  204 */     Collection portTypes = srcWsdl.getPortTypes().values();
/*  205 */     for (PortType portType : portTypes)
/*      */     {
/*  207 */       List list = (List)this.portTypesByNamespace.get(targetNS);
/*  208 */       if (list == null)
/*      */       {
/*  210 */         list = new ArrayList();
/*  211 */         this.portTypesByNamespace.put(targetNS, list);
/*      */       }
/*  213 */       if (!portType.isUndefined()) {
/*  214 */         list.add(portType);
/*      */       }
/*      */     }
/*      */ 
/*  218 */     Collection bindings = srcWsdl.getBindings().values();
/*  219 */     for (Binding binding : bindings)
/*      */     {
/*  221 */       List list = (List)this.bindingsByNamespace.get(targetNS);
/*  222 */       if (list == null)
/*      */       {
/*  224 */         list = new ArrayList();
/*  225 */         this.bindingsByNamespace.put(targetNS, list);
/*      */       }
/*  227 */       if (!binding.isUndefined()) {
/*  228 */         list.add(binding);
/*      */       }
/*      */     }
/*      */ 
/*  232 */     Collection services = srcWsdl.getServices().values();
/*  233 */     for (Service service : services)
/*      */     {
/*  235 */       List list = (List)this.servicesByNamespace.get(targetNS);
/*  236 */       if (list == null)
/*      */       {
/*  238 */         list = new ArrayList();
/*  239 */         this.servicesByNamespace.put(targetNS, list);
/*      */       }
/*  241 */       list.add(service);
/*      */     }
/*      */ 
/*  245 */     Collection importLists = srcWsdl.getImports().values();
/*  246 */     for (List imports : importLists)
/*      */     {
/*  248 */       for (Import imp : imports)
/*      */       {
/*  250 */         Definition impWsdl = imp.getDefinition();
/*  251 */         processTopLevelElements(impWsdl);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void cleanupTemporaryFiles()
/*      */   {
/*  258 */     for (File current : this.tempFiles)
/*      */     {
/*  260 */       current.delete();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processUnreachableBindings(Definition srcWsdl)
/*      */     throws WSDLException
/*      */   {
/*  267 */     log.trace("processUnreachableBindings");
/*      */ 
/*  269 */     Iterator it = getAllDefinedBindings(srcWsdl).values().iterator();
/*  270 */     while (it.hasNext())
/*      */     {
/*  272 */       Binding srcBinding = (Binding)it.next();
/*  273 */       QName srcQName = srcBinding.getQName();
/*      */ 
/*  275 */       WSDLBinding destBinding = this.destWsdl.getBinding(srcQName);
/*  276 */       if (destBinding == null)
/*      */       {
/*  278 */         processBinding(srcWsdl, srcBinding);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processNamespaces(Definition srcWsdl)
/*      */   {
/*  285 */     String targetNS = srcWsdl.getTargetNamespace();
/*  286 */     this.destWsdl.setTargetNamespace(targetNS);
/*      */ 
/*  289 */     Map nsMap = srcWsdl.getNamespaces();
/*  290 */     Iterator iter = nsMap.entrySet().iterator();
/*  291 */     while (iter.hasNext())
/*      */     {
/*  293 */       Map.Entry entry = (Map.Entry)iter.next();
/*  294 */       String prefix = (String)entry.getKey();
/*  295 */       String nsURI = (String)entry.getValue();
/*  296 */       this.destWsdl.registerNamespaceURI(nsURI, prefix);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processUnknownExtensibilityElements(ElementExtensible src, Extendable dest) throws WSDLException
/*      */   {
/*  302 */     List extElements = src.getExtensibilityElements();
/*  303 */     for (int i = 0; i < extElements.size(); i++)
/*      */     {
/*  305 */       ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
/*  306 */       processPolicyElements(extElement, dest);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processPolicyElements(ExtensibilityElement extElement, Extendable dest)
/*      */   {
/*  313 */     if ((extElement instanceof UnknownExtensibilityElement))
/*      */     {
/*  315 */       Element srcElement = ((UnknownExtensibilityElement)extElement).getElement();
/*  316 */       if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(srcElement.getNamespaceURI()))
/*      */       {
/*  319 */         Element element = (Element)srcElement.cloneNode(true);
/*  320 */         copyMissingNamespaceDeclarations(element, srcElement);
/*  321 */         if (element.getLocalName().equals("Policy"))
/*      */         {
/*  323 */           dest.addExtensibilityElement(new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policy", element));
/*      */         }
/*  325 */         else if (element.getLocalName().equals("PolicyReference"))
/*      */         {
/*  327 */           dest.addExtensibilityElement(new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policyReference", element));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processTypes(Definition srcWsdl, URL wsdlLoc)
/*      */     throws IOException, WSDLException
/*      */   {
/*  336 */     log.trace("BEGIN processTypes: " + wsdlLoc);
/*      */ 
/*  338 */     WSDLTypes destTypes = this.destWsdl.getWsdlTypes();
/*      */ 
/*  340 */     Types srcTypes = srcWsdl.getTypes();
/*  341 */     if ((srcTypes != null) && (srcTypes.getExtensibilityElements().size() > 0))
/*      */     {
/*  343 */       List extElements = srcTypes.getExtensibilityElements();
/*  344 */       int len = extElements.size();
/*      */ 
/*  346 */       for (int i = 0; i < len; i++)
/*      */       {
/*  348 */         ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
/*      */         Element domElement;
/*  351 */         if ((extElement instanceof Schema))
/*      */         {
/*  353 */           domElement = ((Schema)extElement).getElement();
/*      */         }
/*      */         else
/*      */         {
/*      */           Element domElement;
/*  355 */           if ((extElement instanceof UnknownExtensibilityElement))
/*      */           {
/*  357 */             domElement = ((UnknownExtensibilityElement)extElement).getElement();
/*      */           }
/*      */           else
/*      */           {
/*  361 */             throw new WSDLException("OTHER_ERROR", "Unsupported extensibility element: " + extElement);
/*      */           }
/*      */         }
/*      */         Element domElement;
/*  364 */         Element domElementClone = (Element)domElement.cloneNode(true);
/*  365 */         copyParentNamespaceDeclarations(domElementClone, domElement);
/*      */ 
/*  367 */         String localname = domElementClone.getLocalName();
/*      */         try
/*      */         {
/*  370 */           if ("import".equals(localname))
/*      */           {
/*  372 */             processSchemaImport(destTypes, wsdlLoc, domElementClone);
/*      */           }
/*  374 */           else if ("schema".equals(localname))
/*      */           {
/*  376 */             processSchemaInclude(destTypes, wsdlLoc, domElementClone);
/*      */           }
/*      */           else
/*      */           {
/*  380 */             throw new IllegalArgumentException("Unsuported schema element: " + localname);
/*      */           }
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*  385 */           throw new WSDLException("OTHER_ERROR", "Cannot extract schema definition", e);
/*      */         }
/*      */       }
/*      */ 
/*  389 */       if (len > 0)
/*      */       {
/*  391 */         JavaToXSD jxsd = new JavaToXSD();
/*  392 */         JBossXSModel xsmodel = jxsd.parseSchema(this.schemaLocationsMap);
/*  393 */         WSDLUtils.addSchemaModel(destTypes, this.destWsdl.getTargetNamespace(), xsmodel);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  398 */       log.trace("Empty wsdl types element, processing imports");
/*  399 */       Iterator it = srcWsdl.getImports().values().iterator();
/*  400 */       while (it.hasNext())
/*      */       {
/*  402 */         List srcImports = (List)it.next();
/*  403 */         for (Import srcImport : srcImports)
/*      */         {
/*  405 */           Definition impDefinition = srcImport.getDefinition();
/*  406 */           String impLoc = impDefinition.getDocumentBaseURI();
/*  407 */           processTypes(impDefinition, new URL(impLoc));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  412 */     log.trace("END processTypes: " + wsdlLoc + "\n" + destTypes);
/*      */   }
/*      */ 
/*      */   private void copyParentNamespaceDeclarations(Element destElement, Element srcElement)
/*      */   {
/*  417 */     Node parent = srcElement.getParentNode();
/*  418 */     while (parent != null)
/*      */     {
/*  420 */       if (parent.hasAttributes())
/*      */       {
/*  422 */         NamedNodeMap attributes = parent.getAttributes();
/*  423 */         for (int i = 0; i < attributes.getLength(); i++)
/*      */         {
/*  425 */           Attr attr = (Attr)attributes.item(i);
/*  426 */           String name = attr.getName();
/*  427 */           String value = attr.getValue();
/*  428 */           if ((name.startsWith("xmlns:")) && (!destElement.hasAttribute(name)))
/*  429 */             destElement.setAttribute(name, value);
/*      */         }
/*      */       }
/*  432 */       parent = parent.getParentNode();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void copyMissingNamespaceDeclarations(Element destElement, Element srcElement) {
/*  438 */     String prefix = destElement.getPrefix();
/*      */     String nsUri;
/*      */     try {
/*  442 */       nsUri = DOMUtils.getElementQName(destElement).getNamespaceURI();
/*      */     }
/*      */     catch (IllegalArgumentException e)
/*      */     {
/*  446 */       nsUri = null;
/*      */     }
/*  448 */     if ((prefix != null) && (nsUri == null))
/*      */     {
/*  450 */       destElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, srcElement.lookupNamespaceURI(prefix));
/*      */     }
/*      */ 
/*  454 */     NamedNodeMap attributes = destElement.getAttributes();
/*  455 */     for (int i = 0; i < attributes.getLength(); i++)
/*      */     {
/*  457 */       Attr attr = (Attr)attributes.item(i);
/*  458 */       String attrPrefix = attr.getPrefix();
/*  459 */       if ((attrPrefix == null) || (attr.getName().startsWith("xmlns")) || (destElement.lookupNamespaceURI(attrPrefix) != null))
/*      */         continue;
/*  461 */       destElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attrPrefix, srcElement.lookupNamespaceURI(attrPrefix));
/*      */     }
/*      */ 
/*  464 */     NodeList childrenList = destElement.getChildNodes();
/*  465 */     for (int i = 0; i < childrenList.getLength(); i++)
/*      */     {
/*  467 */       Node node = childrenList.item(i);
/*  468 */       if ((node instanceof Element))
/*  469 */         copyMissingNamespaceDeclarations((Element)node, srcElement);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processSchemaImport(WSDLTypes types, URL wsdlLoc, Element importEl) throws IOException, WSDLException
/*      */   {
/*  475 */     if (wsdlLoc == null) {
/*  476 */       throw new IllegalArgumentException("Cannot process import, parent location not set");
/*      */     }
/*  478 */     log.trace("processSchemaImport: " + wsdlLoc);
/*      */ 
/*  480 */     String location = getOptionalAttribute(importEl, "schemaLocation");
/*  481 */     if (location == null) {
/*  482 */       throw new IllegalArgumentException("schemaLocation is null for xsd:import");
/*      */     }
/*  484 */     URL locationURL = getLocationURL(wsdlLoc, location);
/*  485 */     Element rootElement = DOMUtils.parse(new ResourceURL(locationURL).openStream());
/*  486 */     URL newloc = processSchemaInclude(types, locationURL, rootElement);
/*  487 */     if (newloc != null)
/*  488 */       importEl.setAttribute("schemaLocation", newloc.toExternalForm());
/*      */   }
/*      */ 
/*      */   private URL processSchemaInclude(WSDLTypes types, URL wsdlLoc, Element schemaEl) throws IOException, WSDLException
/*      */   {
/*  493 */     if (wsdlLoc == null) {
/*  494 */       throw new IllegalArgumentException("Cannot process iclude, parent location not set");
/*      */     }
/*  496 */     File tmpFile = null;
/*  497 */     if (wsdlLoc == null) {
/*  498 */       throw new IllegalArgumentException("Cannot process include, parent location not set");
/*      */     }
/*  500 */     log.trace("processSchemaInclude: " + wsdlLoc);
/*      */ 
/*  502 */     String schemaPrefix = schemaEl.getPrefix();
/*      */ 
/*  504 */     String importTag = schemaPrefix + ":import";
/*  505 */     Element importElement = schemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", importTag);
/*  506 */     importElement.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
/*  507 */     schemaEl.insertBefore(importElement, DOMUtils.getFirstChildElement(schemaEl));
/*      */ 
/*  510 */     Iterator it = DOMUtils.getChildElements(schemaEl, new QName("http://www.w3.org/2001/XMLSchema", "include"));
/*  511 */     while (it.hasNext())
/*      */     {
/*  513 */       Element includeEl = (Element)it.next();
/*  514 */       String location = getOptionalAttribute(includeEl, "schemaLocation");
/*  515 */       if (location == null) {
/*  516 */         throw new IllegalArgumentException("schemaLocation is null for xsd:include");
/*      */       }
/*  518 */       URL locationURL = getLocationURL(wsdlLoc, location);
/*  519 */       Element rootElement = DOMUtils.parse(new ResourceURL(locationURL).openStream());
/*  520 */       URL newloc = processSchemaInclude(types, locationURL, rootElement);
/*  521 */       if (newloc != null) {
/*  522 */         includeEl.setAttribute("schemaLocation", newloc.toExternalForm());
/*      */       }
/*      */     }
/*  525 */     String targetNS = getOptionalAttribute(schemaEl, "targetNamespace");
/*  526 */     if (targetNS != null)
/*      */     {
/*  528 */       log.trace("processSchemaInclude: [targetNS=" + targetNS + ",parentURL=" + wsdlLoc + "]");
/*      */ 
/*  530 */       tmpFile = SchemaUtils.getSchemaTempFile(targetNS);
/*  531 */       this.tempFiles.add(tmpFile);
/*      */ 
/*  533 */       FileWriter fwrite = new FileWriter(tmpFile);
/*  534 */       new DOMWriter(fwrite).setPrettyprint(true).print(schemaEl);
/*  535 */       fwrite.close();
/*      */ 
/*  537 */       this.schemaLocationsMap.put(targetNS, tmpFile.toURL());
/*      */     }
/*      */ 
/*  546 */     if (targetNS == null)
/*      */     {
/*  548 */       log.trace("Schema element without target namespace in: " + wsdlLoc);
/*      */     }
/*      */ 
/*  551 */     handleSchemaImports(schemaEl, wsdlLoc);
/*      */ 
/*  553 */     return tmpFile != null ? tmpFile.toURL() : null;
/*      */   }
/*      */ 
/*      */   private void handleSchemaImports(Element schemaEl, URL parentURL) throws WSDLException, IOException
/*      */   {
/*  558 */     if (parentURL == null) {
/*  559 */       throw new IllegalArgumentException("Cannot process import, parent location not set");
/*      */     }
/*  561 */     Iterator it = DOMUtils.getChildElements(schemaEl, new QName("http://www.w3.org/2001/XMLSchema", "import"));
/*  562 */     while (it.hasNext())
/*      */     {
/*  564 */       Element includeEl = (Element)it.next();
/*  565 */       String schemaLocation = getOptionalAttribute(includeEl, "schemaLocation");
/*  566 */       String namespace = getOptionalAttribute(includeEl, "namespace");
/*      */ 
/*  568 */       log.trace("handleSchemaImport: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]");
/*      */ 
/*  571 */       if ((namespace != null) && (schemaLocation != null))
/*      */       {
/*  573 */         URL currLoc = getLocationURL(parentURL, schemaLocation);
/*  574 */         if (this.schemaLocationsMap.get(namespace) == null)
/*      */         {
/*  576 */           this.schemaLocationsMap.put(namespace, currLoc);
/*      */ 
/*  579 */           Element importedSchema = DOMUtils.parse(currLoc.openStream());
/*  580 */           handleSchemaImports(importedSchema, currLoc);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  585 */         log.trace("Skip schema import: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private URL getLocationURL(URL parentURL, String location) throws MalformedURLException, WSDLException
/*      */   {
/*  592 */     log.trace("getLocationURL: [location=" + location + ",parent=" + parentURL + "]");
/*      */ 
/*  594 */     URL locationURL = null;
/*      */     try
/*      */     {
/*  597 */       locationURL = new URL(location);
/*      */     }
/*      */     catch (MalformedURLException e)
/*      */     {
/*      */     }
/*      */ 
/*  604 */     if (locationURL == null)
/*      */     {
/*  606 */       if (location.startsWith("/")) {
/*  607 */         location = location.substring(1);
/*      */       }
/*  609 */       String path = parentURL.toExternalForm();
/*  610 */       path = path.substring(0, path.lastIndexOf("/"));
/*      */ 
/*  612 */       while (location.startsWith("../"))
/*      */       {
/*  614 */         path = path.substring(0, path.lastIndexOf("/"));
/*  615 */         location = location.substring(3);
/*      */       }
/*      */ 
/*  618 */       locationURL = new URL(path + "/" + location);
/*      */     }
/*      */ 
/*  621 */     log.trace("Modified schemaLocation: " + locationURL);
/*  622 */     return locationURL;
/*      */   }
/*      */ 
/*      */   private void processPortType(Definition srcWsdl, PortType srcPortType, WSDLBinding destBinding) throws WSDLException
/*      */   {
/*  627 */     log.trace("processPortType: " + srcPortType.getQName());
/*      */ 
/*  629 */     QName qname = srcPortType.getQName();
/*  630 */     if (this.destWsdl.getInterface(qname) == null)
/*      */     {
/*  632 */       WSDLInterface destInterface = new WSDLInterface(this.destWsdl, qname);
/*      */ 
/*  635 */       QName policyURIsProp = (QName)srcPortType.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSP_POLICYURIS);
/*  636 */       if ((policyURIsProp != null) && (!"".equalsIgnoreCase(policyURIsProp.getLocalPart())))
/*      */       {
/*  638 */         destInterface.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsp/policyURIs", policyURIsProp.getLocalPart()));
/*      */       }
/*      */ 
/*  642 */       QName eventSourceProp = (QName)srcPortType.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSE_EVENTSOURCE);
/*  643 */       if ((eventSourceProp != null) && (eventSourceProp.getLocalPart().equals(Boolean.TRUE.toString())))
/*      */       {
/*  645 */         destInterface.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wse/isEventSource", eventSourceProp.getLocalPart()));
/*      */       }
/*      */ 
/*  648 */       this.destWsdl.addInterface(destInterface);
/*      */ 
/*  650 */       processPortTypeOperations(srcWsdl, destInterface, srcPortType, destBinding);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processPortTypeOperations(Definition srcWsdl, WSDLInterface destInterface, PortType srcPortType, WSDLBinding destBinding) throws WSDLException
/*      */   {
/*  656 */     Iterator itOperations = srcPortType.getOperations().iterator();
/*  657 */     while (itOperations.hasNext())
/*      */     {
/*  659 */       Operation srcOperation = (Operation)itOperations.next();
/*      */ 
/*  661 */       WSDLInterfaceOperation destOperation = new WSDLInterfaceOperation(destInterface, srcOperation.getName());
/*  662 */       processUnknownExtensibilityElements(srcOperation, destOperation);
/*  663 */       destOperation.setStyle(getOperationStyle(srcWsdl, srcPortType, srcOperation));
/*      */ 
/*  665 */       if ((srcOperation.getStyle() != null) && (false == OperationType.NOTIFICATION.equals(srcOperation.getStyle())))
/*      */       {
/*  667 */         processPortTypeOperationInput(srcWsdl, srcOperation, destOperation, srcPortType, destBinding);
/*      */       }
/*      */ 
/*  670 */       processPortTypeOperationOutput(srcWsdl, srcOperation, destOperation, srcPortType, destBinding);
/*  671 */       processPortTypeOperationFaults(srcOperation, destOperation, destInterface, destBinding);
/*      */ 
/*  673 */       destInterface.addOperation(destOperation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processPortTypeOperationInput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType, WSDLBinding destBinding)
/*      */     throws WSDLException
/*      */   {
/*  680 */     Input srcInput = srcOperation.getInput();
/*  681 */     if (srcInput != null)
/*      */     {
/*  683 */       Message srcMessage = srcInput.getMessage();
/*  684 */       if (srcMessage == null) {
/*  685 */         throw new WSDLException("INVALID_WSDL", "Cannot find input message on operation " + srcOperation.getName() + " on port type: " + srcPortType.getQName());
/*      */       }
/*      */ 
/*  688 */       log.trace("processOperationInput: " + srcMessage.getQName());
/*      */ 
/*  690 */       QName wsaAction = (QName)srcInput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
/*  691 */       if (wsaAction != null) {
/*  692 */         destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionIn", wsaAction.getLocalPart()));
/*      */       }
/*  694 */       List paramOrder = srcOperation.getParameterOrdering();
/*  695 */       if (paramOrder != null)
/*      */       {
/*  697 */         for (String name : paramOrder)
/*      */         {
/*  699 */           if (srcMessage.getPart(name) != null) {
/*  700 */             destOperation.addRpcSignatureItem(new WSDLRPCSignatureItem(name));
/*      */           }
/*      */         }
/*      */       }
/*  704 */       WSDLInterfaceOperationInput rpcInput = new WSDLInterfaceOperationInput(destOperation);
/*  705 */       for (Part srcPart : srcMessage.getOrderedParts(paramOrder))
/*      */       {
/*  708 */         if (ignorePart(srcPortType, srcPart)) {
/*      */           continue;
/*      */         }
/*  711 */         if ("http://www.w3.org/2004/03/wsdl/style/iri" == destOperation.getStyle())
/*      */         {
/*  713 */           WSDLInterfaceOperationInput destInput = new WSDLInterfaceOperationInput(destOperation);
/*  714 */           QName elementName = messagePartToElementName(srcMessage, srcPart, destOperation, destBinding);
/*  715 */           destInput.setElement(elementName);
/*      */ 
/*  718 */           destInput.setMessageName(srcMessage.getQName());
/*  719 */           destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/in", srcMessage.getQName().getLocalPart()));
/*      */ 
/*  721 */           destInput.setPartName(srcPart.getName());
/*  722 */           processUnknownExtensibilityElements(srcMessage, destInput);
/*      */ 
/*  724 */           destOperation.addInput(destInput);
/*      */         }
/*      */         else
/*      */         {
/*  731 */           QName xmlType = srcPart.getTypeName();
/*  732 */           if (xmlType != null)
/*      */           {
/*  734 */             rpcInput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
/*      */           }
/*      */           else
/*      */           {
/*  738 */             messagePartToElementName(srcMessage, srcPart, destOperation, destBinding);
/*      */           }
/*      */         }
/*      */       }
/*  742 */       if ("http://www.w3.org/2004/03/wsdl/style/rpc" == destOperation.getStyle())
/*      */       {
/*  746 */         rpcInput.setElement(destOperation.getName());
/*  747 */         rpcInput.setMessageName(srcMessage.getQName());
/*  748 */         processUnknownExtensibilityElements(srcMessage, rpcInput);
/*  749 */         destOperation.addInput(rpcInput);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean ignorePart(PortType srcPortType, Part srcPart)
/*      */   {
/*  757 */     boolean canBeSkipped = false;
/*  758 */     QName parentName = srcPortType.getQName();
/*  759 */     if (this.skippedSWAParts.containsKey(parentName))
/*      */     {
/*  761 */       if (((List)this.skippedSWAParts.get(parentName)).contains(srcPart.getName()))
/*      */       {
/*  763 */         log.trace("Skip attachment part: " + parentName + "->" + srcPart.getName());
/*  764 */         canBeSkipped = true;
/*      */       }
/*      */     }
/*      */ 
/*  768 */     return canBeSkipped;
/*      */   }
/*      */ 
/*      */   private void processPortTypeOperationOutput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType, WSDLBinding destBinding)
/*      */     throws WSDLException
/*      */   {
/*  774 */     Output srcOutput = srcOperation.getOutput();
/*  775 */     if (srcOutput == null)
/*      */     {
/*  777 */       destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
/*  778 */       return;
/*      */     }
/*      */ 
/*  781 */     Message srcMessage = srcOutput.getMessage();
/*  782 */     if (srcMessage == null) {
/*  783 */       throw new WSDLException("INVALID_WSDL", "Cannot find output message on operation " + srcOperation.getName() + " on port type: " + srcPortType.getQName());
/*      */     }
/*      */ 
/*  786 */     log.trace("processOperationOutput: " + srcMessage.getQName());
/*      */ 
/*  788 */     destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
/*  789 */     QName wsaAction = (QName)srcOutput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
/*  790 */     if (wsaAction != null) {
/*  791 */       destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionOut", wsaAction.getLocalPart()));
/*      */     }
/*  793 */     List paramOrder = srcOperation.getParameterOrdering();
/*  794 */     if (paramOrder != null)
/*      */     {
/*  796 */       for (String name : paramOrder)
/*      */       {
/*  798 */         if (srcMessage.getPart(name) != null)
/*      */         {
/*  800 */           WSDLRPCSignatureItem item = destOperation.getRpcSignatureitem(name);
/*  801 */           if (item != null)
/*  802 */             item.setDirection(WSDLRPCSignatureItem.Direction.INOUT);
/*  803 */           else destOperation.addRpcSignatureItem(new WSDLRPCSignatureItem(name, WSDLRPCSignatureItem.Direction.OUT));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  808 */     WSDLInterfaceOperationOutput rpcOutput = new WSDLInterfaceOperationOutput(destOperation);
/*  809 */     for (Part srcPart : srcMessage.getOrderedParts(null))
/*      */     {
/*  812 */       if (ignorePart(srcPortType, srcPart)) {
/*      */         continue;
/*      */       }
/*  815 */       if ("http://www.w3.org/2004/03/wsdl/style/iri" == destOperation.getStyle())
/*      */       {
/*  817 */         WSDLInterfaceOperationOutput destOutput = new WSDLInterfaceOperationOutput(destOperation);
/*      */ 
/*  819 */         QName elementName = messagePartToElementName(srcMessage, srcPart, destOperation, destBinding);
/*  820 */         destOutput.setElement(elementName);
/*      */ 
/*  823 */         destOutput.setMessageName(srcMessage.getQName());
/*  824 */         destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/out", srcMessage.getQName().getLocalPart()));
/*      */ 
/*  827 */         destOutput.setPartName(srcPart.getName());
/*      */ 
/*  829 */         destOperation.addOutput(destOutput);
/*      */       }
/*      */       else
/*      */       {
/*  836 */         QName xmlType = srcPart.getTypeName();
/*  837 */         if (xmlType != null)
/*  838 */           rpcOutput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
/*  839 */         else messagePartToElementName(srcMessage, srcPart, destOperation, destBinding);
/*      */       }
/*      */     }
/*      */ 
/*  843 */     if ("http://www.w3.org/2004/03/wsdl/style/rpc" == destOperation.getStyle())
/*      */     {
/*  847 */       QName name = destOperation.getName();
/*  848 */       rpcOutput.setElement(new QName(name.getNamespaceURI(), name.getLocalPart() + "Response"));
/*  849 */       rpcOutput.setMessageName(srcMessage.getQName());
/*  850 */       destOperation.addOutput(rpcOutput);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processPortTypeOperationFaults(Operation srcOperation, WSDLInterfaceOperation destOperation, WSDLInterface destInterface, WSDLBinding destBinding)
/*      */     throws WSDLException
/*      */   {
/*  858 */     Map faults = srcOperation.getFaults();
/*  859 */     Iterator itFaults = faults.values().iterator();
/*  860 */     while (itFaults.hasNext())
/*      */     {
/*  862 */       Fault srcFault = (Fault)itFaults.next();
/*  863 */       processOperationFault(destOperation, destInterface, srcFault);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processOperationFault(WSDLInterfaceOperation destOperation, WSDLInterface destInterface, Fault srcFault) throws WSDLException
/*      */   {
/*  869 */     String faultName = srcFault.getName();
/*  870 */     log.trace("processOperationFault: " + faultName);
/*      */ 
/*  872 */     WSDLInterfaceFault destFault = new WSDLInterfaceFault(destInterface, faultName);
/*  873 */     Message message = srcFault.getMessage();
/*  874 */     QName messageName = message.getQName();
/*      */ 
/*  876 */     Map partsMap = message.getParts();
/*  877 */     if (partsMap.size() != 1) {
/*  878 */       throw new WSDLException("INVALID_WSDL", "Unsupported number of fault parts in message " + messageName);
/*      */     }
/*  880 */     Part part = (Part)partsMap.values().iterator().next();
/*  881 */     QName xmlName = part.getElementName();
/*      */ 
/*  883 */     if (xmlName != null)
/*      */     {
/*  885 */       destFault.setElement(xmlName);
/*      */     }
/*      */     else
/*      */     {
/*  889 */       destFault.setElement(messageName);
/*  890 */       log.warn("Unsupported fault message part in message: " + messageName);
/*      */     }
/*      */ 
/*  894 */     destInterface.addFault(destFault);
/*      */ 
/*  897 */     WSDLInterfaceOperationOutfault opOutFault = new WSDLInterfaceOperationOutfault(destOperation);
/*  898 */     opOutFault.setRef(destFault.getName());
/*  899 */     destOperation.addOutfault(opOutFault);
/*      */   }
/*      */ 
/*      */   private QName messagePartToElementName(Message srcMessage, Part srcPart, WSDLInterfaceOperation destOperation, WSDLBinding destBinding)
/*      */     throws WSDLException
/*      */   {
/*  906 */     QName xmlName = null;
/*      */ 
/*  909 */     if ((srcPart.getTypeName() != null) && (srcPart.getElementName() != null)) {
/*  910 */       throw new WSDLException("INVALID_WSDL", "Message parts must not define an element name and type name: " + srcMessage.getQName());
/*      */     }
/*  912 */     String bindingType = destBinding.getType();
/*  913 */     if ("http://schemas.xmlsoap.org/wsdl/http/".equals(bindingType))
/*      */     {
/*  915 */       xmlName = new QName(srcPart.getName());
/*      */     }
/*      */ 
/*  918 */     String style = destOperation.getStyle();
/*  919 */     if ((xmlName == null) && ("http://www.w3.org/2004/03/wsdl/style/rpc".equals(style)))
/*      */     {
/*  923 */       if (srcPart.getName() == null) {
/*  924 */         throw new WSDLException("INVALID_WSDL", "RPC style message parts must define a typy name: " + srcMessage.getQName());
/*      */       }
/*      */ 
/*  928 */       xmlName = srcPart.getElementName();
/*      */ 
/*  931 */       if (xmlName == null) {
/*  932 */         xmlName = new QName(srcPart.getName());
/*      */       }
/*      */     }
/*  935 */     if ((xmlName == null) && ("http://www.w3.org/2004/03/wsdl/style/iri".equals(style)))
/*      */     {
/*  940 */       if (srcPart.getElementName() == null) {
/*  941 */         throw new WSDLException("INVALID_WSDL", "Document style message parts must define an element name: " + srcMessage.getQName());
/*      */       }
/*      */ 
/*  944 */       xmlName = srcPart.getElementName();
/*      */     }
/*      */ 
/*  947 */     if (xmlName == null) {
/*  948 */       throw new IllegalStateException("Cannot name for wsdl part: " + srcPart);
/*      */     }
/*  950 */     xmlName = this.destWsdl.registerQName(xmlName);
/*  951 */     String key = srcMessage.getQName() + "->" + srcPart.getName();
/*  952 */     this.messagePartToElementMap.put(key, xmlName);
/*      */ 
/*  954 */     return xmlName;
/*      */   }
/*      */ 
/*      */   private BindingOperation getBindingOperation(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException
/*      */   {
/*  959 */     Binding srcBinding = (Binding)getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
/*      */ 
/*  961 */     if (srcBinding == null) {
/*  962 */       throw new WSDLException("INVALID_WSDL", "Cannot find binding for: " + srcPortType.getQName());
/*      */     }
/*  964 */     String srcOperationName = srcOperation.getName();
/*  965 */     BindingOperation srcBindingOperation = srcBinding.getBindingOperation(srcOperationName, null, null);
/*  966 */     if (srcBindingOperation == null)
/*  967 */       throw new WSDLException("INVALID_WSDL", "Cannot find binding operation for: " + srcOperationName);
/*  968 */     return srcBindingOperation;
/*      */   }
/*      */ 
/*      */   private String getOperationStyle(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException
/*      */   {
/*  973 */     Binding srcBinding = (Binding)getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
/*  974 */     BindingOperation srcBindingOperation = getBindingOperation(srcWsdl, srcPortType, srcOperation);
/*      */ 
/*  976 */     String operationStyle = null;
/*  977 */     List extList = srcBindingOperation.getExtensibilityElements();
/*  978 */     for (ExtensibilityElement extElement : extList)
/*      */     {
/*  980 */       QName elementType = extElement.getElementType();
/*  981 */       if ((extElement instanceof SOAPOperation))
/*      */       {
/*  983 */         SOAPOperation soapOp = (SOAPOperation)extElement;
/*  984 */         operationStyle = soapOp.getStyle();
/*      */       }
/*  986 */       else if ((extElement instanceof SOAP12Operation))
/*      */       {
/*  988 */         SOAP12Operation soapOp = (SOAP12Operation)extElement;
/*  989 */         operationStyle = soapOp.getStyle();
/*      */       }
/*      */     }
/*      */ 
/*  993 */     if (operationStyle == null)
/*      */     {
/*  995 */       for (ExtensibilityElement extElement : srcBinding.getExtensibilityElements())
/*      */       {
/*  997 */         QName elementType = extElement.getElementType();
/*  998 */         if ((extElement instanceof SOAPBinding))
/*      */         {
/* 1000 */           SOAPBinding soapBinding = (SOAPBinding)extElement;
/* 1001 */           operationStyle = soapBinding.getStyle();
/*      */         }
/* 1003 */         else if ((extElement instanceof SOAP12Binding))
/*      */         {
/* 1005 */           SOAP12Binding soapBinding = (SOAP12Binding)extElement;
/* 1006 */           operationStyle = soapBinding.getStyle();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1011 */     return "rpc".equals(operationStyle) ? "http://www.w3.org/2004/03/wsdl/style/rpc" : "http://www.w3.org/2004/03/wsdl/style/iri";
/*      */   }
/*      */ 
/*      */   private WSDLBinding processBinding(Definition srcWsdl, Binding srcBinding) throws WSDLException
/*      */   {
/* 1016 */     QName srcBindingQName = srcBinding.getQName();
/* 1017 */     log.trace("processBinding: " + srcBindingQName);
/*      */ 
/* 1019 */     WSDLBinding destBinding = this.destWsdl.getBinding(srcBindingQName);
/* 1020 */     if (destBinding == null)
/*      */     {
/* 1022 */       PortType srcPortType = getDefinedPortType(srcBinding);
/*      */ 
/* 1024 */       String bindingType = null;
/* 1025 */       List extList = srcBinding.getExtensibilityElements();
/* 1026 */       for (ExtensibilityElement extElement : extList)
/*      */       {
/* 1028 */         QName elementType = extElement.getElementType();
/* 1029 */         if ((extElement instanceof SOAPBinding))
/*      */         {
/* 1031 */           bindingType = "http://schemas.xmlsoap.org/wsdl/soap/";
/*      */         }
/* 1033 */         else if ((extElement instanceof SOAP12Binding))
/*      */         {
/* 1035 */           bindingType = "http://schemas.xmlsoap.org/wsdl/soap12/";
/*      */         }
/* 1037 */         else if ((extElement instanceof HTTPBinding))
/*      */         {
/* 1039 */           bindingType = "http://schemas.xmlsoap.org/wsdl/http/";
/*      */         }
/* 1041 */         else if ("binding".equals(elementType.getLocalPart()))
/*      */         {
/* 1043 */           log.warn("Unsupported binding: " + elementType);
/* 1044 */           bindingType = elementType.getNamespaceURI();
/*      */         }
/*      */       }
/*      */ 
/* 1048 */       if (bindingType == null) {
/* 1049 */         throw new WSDLException("INVALID_WSDL", "Cannot obtain binding type for: " + srcBindingQName);
/*      */       }
/* 1051 */       if (("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) || ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) || ("http://schemas.xmlsoap.org/wsdl/http/".equals(bindingType)))
/*      */       {
/* 1053 */         destBinding = new WSDLBinding(this.destWsdl, srcBindingQName);
/* 1054 */         destBinding.setInterfaceName(srcPortType.getQName());
/* 1055 */         destBinding.setType(bindingType);
/* 1056 */         processUnknownExtensibilityElements(srcBinding, destBinding);
/* 1057 */         this.destWsdl.addBinding(destBinding);
/*      */ 
/* 1059 */         preProcessSWAParts(srcBinding, srcWsdl);
/* 1060 */         processPortType(srcWsdl, srcPortType, destBinding);
/*      */ 
/* 1062 */         String bindingStyle = Style.getDefaultStyle().toString();
/* 1063 */         for (ExtensibilityElement extElement : extList)
/*      */         {
/* 1065 */           if ((extElement instanceof SOAPBinding))
/*      */           {
/* 1067 */             SOAPBinding soapBinding = (SOAPBinding)extElement;
/* 1068 */             bindingStyle = soapBinding.getStyle();
/*      */           }
/* 1070 */           else if ((extElement instanceof SOAP12Binding))
/*      */           {
/* 1072 */             SOAP12Binding soapBinding = (SOAP12Binding)extElement;
/* 1073 */             bindingStyle = soapBinding.getStyle();
/*      */           }
/*      */         }
/*      */ 
/* 1077 */         processBindingOperations(srcWsdl, destBinding, srcBinding, bindingStyle);
/*      */       }
/*      */     }
/*      */ 
/* 1081 */     return destBinding;
/*      */   }
/*      */ 
/*      */   private Binding getDefinedBinding(Port srcPort)
/*      */     throws WSDLException
/*      */   {
/* 1088 */     Binding srcBinding = srcPort.getBinding();
/* 1089 */     if (srcBinding == null) {
/* 1090 */       throw new WSDLException("INVALID_WSDL", "Cannot find binding for port: " + srcPort.getName());
/*      */     }
/* 1092 */     QName srcBindingName = srcBinding.getQName();
/* 1093 */     if (srcBinding.isUndefined())
/*      */     {
/* 1095 */       String nsURI = srcBindingName.getNamespaceURI();
/* 1096 */       List bindings = (List)this.bindingsByNamespace.get(nsURI);
/* 1097 */       if (bindings == null) {
/* 1098 */         throw new WSDLException("INVALID_WSDL", "Cannot find bindings for namespace: " + nsURI);
/*      */       }
/* 1100 */       for (Binding auxBinding : bindings)
/*      */       {
/* 1102 */         if (srcBindingName.equals(auxBinding.getQName()))
/*      */         {
/* 1104 */           srcBinding = auxBinding;
/* 1105 */           break;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1110 */     return srcBinding;
/*      */   }
/*      */ 
/*      */   private PortType getDefinedPortType(Binding srcBinding)
/*      */     throws WSDLException
/*      */   {
/* 1117 */     QName srcBindingQName = srcBinding.getQName();
/*      */ 
/* 1119 */     PortType srcPortType = srcBinding.getPortType();
/* 1120 */     if (srcPortType == null) {
/* 1121 */       throw new WSDLException("INVALID_WSDL", "Cannot find port type for binding: " + srcBindingQName);
/*      */     }
/* 1123 */     QName srcPortTypeName = srcPortType.getQName();
/* 1124 */     if (srcPortType.isUndefined())
/*      */     {
/* 1126 */       String nsURI = srcPortTypeName.getNamespaceURI();
/* 1127 */       List portTypes = (List)this.portTypesByNamespace.get(nsURI);
/* 1128 */       if (portTypes == null) {
/* 1129 */         throw new WSDLException("INVALID_WSDL", "Cannot find port types for namespace: " + nsURI);
/*      */       }
/* 1131 */       for (PortType auxPortType : portTypes)
/*      */       {
/* 1133 */         if (srcPortTypeName.equals(auxPortType.getQName()))
/*      */         {
/* 1135 */           srcPortType = auxPortType;
/* 1136 */           break;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1141 */     return srcPortType;
/*      */   }
/*      */ 
/*      */   private void preProcessSWAParts(Binding srcBinding, Definition srcWsdl)
/*      */     throws WSDLException
/*      */   {
/* 1151 */     Iterator opIt = srcBinding.getBindingOperations().iterator();
/* 1152 */     while (opIt.hasNext())
/*      */     {
/* 1154 */       BindingOperation bindingOperation = (BindingOperation)opIt.next();
/*      */ 
/* 1157 */       if (bindingOperation.getBindingInput() != null) {
/* 1158 */         markSWAParts(bindingOperation.getBindingInput().getExtensibilityElements(), srcBinding, srcWsdl);
/*      */       }
/*      */ 
/* 1161 */       if (bindingOperation.getBindingOutput() != null)
/* 1162 */         markSWAParts(bindingOperation.getBindingOutput().getExtensibilityElements(), srcBinding, srcWsdl);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void markSWAParts(List extensions, Binding srcBinding, Definition srcWsdl) throws WSDLException
/*      */   {
/* 1168 */     Iterator extIt = extensions.iterator();
/* 1169 */     while (extIt.hasNext())
/*      */     {
/* 1171 */       Object o = extIt.next();
/* 1172 */       if ((o instanceof MIMEMultipartRelated))
/*      */       {
/* 1175 */         QName portTypeName = getDefinedPortType(srcBinding).getQName();
/*      */ 
/* 1177 */         if (log.isTraceEnabled()) {
/* 1178 */           log.trace("SWA found on portType" + portTypeName);
/*      */         }
/* 1180 */         MIMEMultipartRelated mrel = (MIMEMultipartRelated)o;
/* 1181 */         Iterator mimePartIt = mrel.getMIMEParts().iterator();
/* 1182 */         while (mimePartIt.hasNext())
/*      */         {
/* 1184 */           MIMEPart mimePartDesc = (MIMEPart)mimePartIt.next();
/* 1185 */           List mimePartExt = mimePartDesc.getExtensibilityElements();
/* 1186 */           if ((!mimePartExt.isEmpty()) && ((mimePartExt.get(0) instanceof MIMEContent)))
/*      */           {
/* 1188 */             MIMEContent mimeContent = (MIMEContent)mimePartExt.get(0);
/*      */ 
/* 1190 */             if (this.skippedSWAParts.get(portTypeName) == null)
/* 1191 */               this.skippedSWAParts.put(portTypeName, new ArrayList());
/* 1192 */             ((List)this.skippedSWAParts.get(portTypeName)).add(mimeContent.getPart());
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Map<QName, Binding> getPortTypeBindings(Definition srcWsdl)
/*      */     throws WSDLException
/*      */   {
/* 1203 */     getAllDefinedBindings(srcWsdl);
/* 1204 */     return this.portTypeBindings;
/*      */   }
/*      */ 
/*      */   private Map<QName, Binding> getAllDefinedBindings(Definition srcWsdl) throws WSDLException
/*      */   {
/* 1209 */     if (this.allBindings != null) {
/* 1210 */       return this.allBindings;
/*      */     }
/* 1212 */     this.allBindings = new LinkedHashMap();
/* 1213 */     this.portTypeBindings = new LinkedHashMap();
/* 1214 */     Map srcBindings = srcWsdl.getBindings();
/* 1215 */     Iterator itBinding = srcBindings.values().iterator();
/* 1216 */     while (itBinding.hasNext())
/*      */     {
/* 1218 */       Binding srcBinding = (Binding)itBinding.next();
/* 1219 */       this.allBindings.put(srcBinding.getQName(), srcBinding);
/* 1220 */       this.portTypeBindings.put(getDefinedPortType(srcBinding).getQName(), srcBinding);
/*      */     }
/*      */ 
/* 1225 */     Iterator itService = srcWsdl.getServices().values().iterator();
/* 1226 */     while (itService.hasNext())
/*      */     {
/* 1228 */       Service srcService = (Service)itService.next();
/* 1229 */       Iterator itPort = srcService.getPorts().values().iterator();
/* 1230 */       while (itPort.hasNext())
/*      */       {
/* 1232 */         Port srcPort = (Port)itPort.next();
/* 1233 */         Binding srcBinding = srcPort.getBinding();
/* 1234 */         this.allBindings.put(srcBinding.getQName(), srcBinding);
/* 1235 */         this.portTypeBindings.put(getDefinedPortType(srcBinding).getQName(), srcBinding);
/*      */       }
/*      */     }
/*      */ 
/* 1239 */     return this.allBindings;
/*      */   }
/*      */ 
/*      */   private void processBindingOperations(Definition srcWsdl, WSDLBinding destBinding, Binding srcBinding, String bindingStyle) throws WSDLException
/*      */   {
/* 1244 */     Iterator it = srcBinding.getBindingOperations().iterator();
/* 1245 */     while (it.hasNext())
/*      */     {
/* 1247 */       BindingOperation srcBindingOperation = (BindingOperation)it.next();
/* 1248 */       processBindingOperation(srcWsdl, destBinding, bindingStyle, srcBindingOperation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processBindingOperation(Definition srcWsdl, WSDLBinding destBinding, String bindingStyle, BindingOperation srcBindingOperation) throws WSDLException
/*      */   {
/* 1254 */     String srcOperationName = srcBindingOperation.getName();
/* 1255 */     log.trace("processBindingOperation: " + srcOperationName);
/*      */ 
/* 1257 */     WSDLInterface destInterface = destBinding.getInterface();
/* 1258 */     String namespaceURI = destInterface.getName().getNamespaceURI();
/*      */ 
/* 1260 */     WSDLBindingOperation destBindingOperation = new WSDLBindingOperation(destBinding);
/* 1261 */     QName refQName = new QName(namespaceURI, srcOperationName);
/* 1262 */     destBindingOperation.setRef(refQName);
/* 1263 */     processUnknownExtensibilityElements(srcBindingOperation, destBindingOperation);
/* 1264 */     destBinding.addOperation(destBindingOperation);
/*      */ 
/* 1266 */     String opName = srcOperationName;
/* 1267 */     WSDLInterfaceOperation destIntfOperation = destInterface.getOperation(opName);
/*      */ 
/* 1270 */     List extList = srcBindingOperation.getExtensibilityElements();
/* 1271 */     for (ExtensibilityElement extElement : extList)
/*      */     {
/* 1273 */       if ((extElement instanceof SOAPOperation))
/*      */       {
/* 1275 */         SOAPOperation soapOp = (SOAPOperation)extElement;
/* 1276 */         destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
/*      */       }
/* 1278 */       else if ((extElement instanceof SOAP12Operation))
/*      */       {
/* 1280 */         SOAP12Operation soapOp = (SOAP12Operation)extElement;
/* 1281 */         destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
/*      */       }
/*      */     }
/*      */ 
/* 1285 */     BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
/* 1286 */     if (srcBindingInput != null)
/*      */     {
/* 1288 */       processBindingInput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingInput);
/*      */     }
/*      */ 
/* 1291 */     BindingOutput srcBindingOutput = srcBindingOperation.getBindingOutput();
/* 1292 */     if (srcBindingOutput != null)
/*      */     {
/* 1294 */       processBindingOutput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingOutput);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processBindingInput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, BindingOperation srcBindingOperation, BindingInput srcBindingInput)
/*      */     throws WSDLException
/*      */   {
/* 1310 */     log.trace("processBindingInput");
/*      */ 
/* 1312 */     List extList = srcBindingInput.getExtensibilityElements();
/* 1313 */     WSDLBindingOperationInput input = new WSDLBindingOperationInput(destBindingOperation);
/* 1314 */     processUnknownExtensibilityElements(srcBindingInput, input);
/* 1315 */     destBindingOperation.addInput(input);
/*      */ 
/* 1317 */     ReferenceCallback cb = new ReferenceCallback(srcBindingOperation, destIntfOperation)
/*      */     {
/*      */       public QName getXmlType(String partName) {
/* 1320 */         return this.val$srcBindingOperation.getOperation().getInput().getMessage().getPart(partName).getTypeName();
/*      */       }
/*      */ 
/*      */       public void removeReference(QName element)
/*      */       {
/* 1325 */         WSDLInterfaceOperationInput destIntfInput = this.val$destIntfOperation.getInput(element);
/* 1326 */         if (destIntfInput != null)
/* 1327 */           this.val$destIntfOperation.removeInput(element);
/*      */       }
/*      */ 
/*      */       public void removeRPCPart(String partName)
/*      */       {
/* 1332 */         WSDLInterfaceOperationInput operationInput = this.val$destIntfOperation.getInput(this.val$destIntfOperation.getName());
/* 1333 */         operationInput.removeChildPart(partName);
/*      */       }
/*      */     };
/* 1337 */     processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, input, srcBindingOperation, cb);
/*      */   }
/*      */ 
/*      */   private void processBindingOutput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, BindingOperation srcBindingOperation, BindingOutput srcBindingOutput)
/*      */     throws WSDLException
/*      */   {
/* 1343 */     log.trace("processBindingInput");
/*      */ 
/* 1345 */     List extList = srcBindingOutput.getExtensibilityElements();
/* 1346 */     WSDLBindingOperationOutput output = new WSDLBindingOperationOutput(destBindingOperation);
/* 1347 */     destBindingOperation.addOutput(output);
/*      */ 
/* 1349 */     ReferenceCallback cb = new ReferenceCallback(srcBindingOperation, destIntfOperation)
/*      */     {
/*      */       public QName getXmlType(String partName) {
/* 1352 */         return this.val$srcBindingOperation.getOperation().getOutput().getMessage().getPart(partName).getTypeName();
/*      */       }
/*      */ 
/*      */       public void removeReference(QName element)
/*      */       {
/* 1357 */         WSDLInterfaceOperationOutput destIntfOutput = this.val$destIntfOperation.getOutput(element);
/* 1358 */         if (destIntfOutput != null)
/* 1359 */           this.val$destIntfOperation.removeOutput(element);
/*      */       }
/*      */ 
/*      */       public void removeRPCPart(String partName)
/*      */       {
/* 1364 */         QName name = this.val$destIntfOperation.getName();
/* 1365 */         WSDLInterfaceOperationOutput operationOutput = this.val$destIntfOperation.getOutput(new QName(name.getNamespaceURI(), name.getLocalPart() + "Response"));
/* 1366 */         operationOutput.removeChildPart(partName);
/*      */       }
/*      */     };
/* 1370 */     processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, output, srcBindingOperation, cb);
/*      */   }
/*      */ 
/*      */   private void processBindingReference(Definition srcWsdl, WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, List<ExtensibilityElement> extList, WSDLBindingMessageReference reference, BindingOperation srcBindingOperation, ReferenceCallback callback)
/*      */     throws WSDLException
/*      */   {
/* 1377 */     for (ExtensibilityElement extElement : extList)
/*      */     {
/* 1379 */       if ((extElement instanceof SOAPBody))
/*      */       {
/* 1381 */         SOAPBody body = (SOAPBody)extElement;
/* 1382 */         processEncodingStyle(body, destBindingOperation);
/*      */ 
/* 1385 */         String namespaceURI = body.getNamespaceURI();
/* 1386 */         destBindingOperation.setNamespaceURI(namespaceURI);
/*      */       }
/* 1388 */       else if ((extElement instanceof SOAP12Body))
/*      */       {
/* 1390 */         SOAP12Body body = (SOAP12Body)extElement;
/* 1391 */         processEncodingStyle(body, destBindingOperation);
/*      */ 
/* 1393 */         String namespaceURI = body.getNamespaceURI();
/* 1394 */         destBindingOperation.setNamespaceURI(namespaceURI);
/*      */       }
/* 1396 */       else if ((extElement instanceof SOAPHeader))
/*      */       {
/* 1398 */         SOAPHeader header = (SOAPHeader)extElement;
/* 1399 */         QName headerMessageName = header.getMessage();
/* 1400 */         String headerPartName = header.getPart();
/*      */ 
/* 1402 */         String key = headerMessageName + "->" + headerPartName;
/* 1403 */         QName elementName = (QName)this.messagePartToElementMap.get(key);
/*      */ 
/* 1406 */         boolean isImplicitHeader = false;
/* 1407 */         Message srcMessage = srcWsdl.getMessage(headerMessageName);
/* 1408 */         if ((elementName == null) && (srcMessage != null))
/*      */         {
/* 1410 */           Iterator itParts = srcMessage.getParts().values().iterator();
/* 1411 */           while (itParts.hasNext())
/*      */           {
/* 1413 */             Part srcPart = (Part)itParts.next();
/* 1414 */             String partName = srcPart.getName();
/* 1415 */             if (partName.equals(headerPartName))
/*      */             {
/* 1417 */               isImplicitHeader = true;
/* 1418 */               elementName = srcPart.getElementName();
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1423 */         if (elementName == null) {
/* 1424 */           throw new WSDLException("INVALID_WSDL", "Could not determine element name from header: " + key);
/*      */         }
/* 1426 */         WSDLSOAPHeader soapHeader = new WSDLSOAPHeader(elementName, headerPartName);
/* 1427 */         soapHeader.setIncludeInSignature(!isImplicitHeader);
/* 1428 */         reference.addSoapHeader(soapHeader);
/* 1429 */         if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle())
/*      */         {
/* 1431 */           callback.removeReference(elementName);
/*      */         }
/*      */         else
/*      */         {
/* 1436 */           callback.removeRPCPart(headerPartName);
/*      */         }
/*      */       }
/* 1439 */       else if ((extElement instanceof MIMEMultipartRelated))
/*      */       {
/* 1441 */         MIMEMultipartRelated related = (MIMEMultipartRelated)extElement;
/* 1442 */         Iterator i = related.getMIMEParts().iterator();
/* 1443 */         while (i.hasNext())
/*      */         {
/* 1445 */           MIMEPart part = (MIMEPart)i.next();
/* 1446 */           Iterator j = part.getExtensibilityElements().iterator();
/* 1447 */           String name = null;
/* 1448 */           String types = null;
/*      */ 
/* 1450 */           while (j.hasNext())
/*      */           {
/* 1452 */             ExtensibilityElement inner = (ExtensibilityElement)j.next();
/* 1453 */             if ((inner instanceof MIMEContent))
/*      */             {
/* 1455 */               MIMEContent content = (MIMEContent)inner;
/* 1456 */               name = content.getPart();
/* 1457 */               if (types == null)
/*      */               {
/* 1459 */                 types = content.getType();
/*      */               }
/*      */               else
/*      */               {
/* 1463 */                 types = types + "," + content.getType();
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/* 1468 */           if (name != null)
/*      */           {
/* 1470 */             QName xmlType = callback.getXmlType(name);
/* 1471 */             reference.addMimePart(new WSDLMIMEPart(name, xmlType, types));
/* 1472 */             if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle())
/*      */             {
/* 1475 */               callback.removeReference(new QName(name));
/*      */             }
/*      */             else
/*      */             {
/* 1479 */               callback.removeRPCPart(name);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processEncodingStyle(ExtensibilityElement extElement, WSDLBindingOperation destBindingOperation)
/*      */   {
/* 1489 */     log.trace("processEncodingStyle");
/*      */ 
/* 1491 */     String encStyle = null;
/* 1492 */     if ((extElement instanceof SOAPBody))
/*      */     {
/* 1494 */       SOAPBody body = (SOAPBody)extElement;
/* 1495 */       List encStyleList = body.getEncodingStyles();
/* 1496 */       if (encStyleList != null)
/*      */       {
/* 1498 */         if (encStyleList.size() > 1) {
/* 1499 */           log.warn("Multiple encoding styles not supported: " + encStyleList);
/*      */         }
/* 1501 */         if (encStyleList.size() > 0)
/*      */         {
/* 1503 */           encStyle = (String)encStyleList.get(0);
/*      */         }
/*      */       }
/*      */     }
/* 1507 */     else if ((extElement instanceof SOAP12Body))
/*      */     {
/* 1509 */       SOAP12Body body = (SOAP12Body)extElement;
/* 1510 */       encStyle = body.getEncodingStyle();
/*      */     }
/*      */ 
/* 1513 */     if (encStyle != null)
/*      */     {
/* 1515 */       String setStyle = destBindingOperation.getEncodingStyle();
/* 1516 */       if (!encStyle.equals(setStyle)) {
/* 1517 */         log.warn("Encoding style '" + encStyle + "' not supported for: " + destBindingOperation.getRef());
/*      */       }
/* 1519 */       destBindingOperation.setEncodingStyle(encStyle);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processServices(Definition srcWsdl) throws WSDLException
/*      */   {
/* 1525 */     log.trace("BEGIN processServices: " + srcWsdl.getDocumentBaseURI());
/*      */ 
/* 1528 */     this.allBindings = null;
/*      */ 
/* 1530 */     if (srcWsdl.getServices().size() > 0)
/*      */     {
/* 1532 */       Iterator it = srcWsdl.getServices().values().iterator();
/* 1533 */       while (it.hasNext())
/*      */       {
/* 1535 */         Service srcService = (Service)it.next();
/* 1536 */         QName qname = srcService.getQName();
/* 1537 */         WSDLService destService = new WSDLService(this.destWsdl, qname);
/* 1538 */         processUnknownExtensibilityElements(srcService, destService);
/* 1539 */         this.destWsdl.addService(destService);
/* 1540 */         processPorts(srcWsdl, destService, srcService);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1545 */       log.trace("Empty wsdl services, processing imports");
/* 1546 */       Iterator it = srcWsdl.getImports().values().iterator();
/* 1547 */       while (it.hasNext())
/*      */       {
/* 1549 */         List srcImports = (List)it.next();
/* 1550 */         for (Import srcImport : srcImports)
/*      */         {
/* 1552 */           Definition importDefinition = srcImport.getDefinition();
/* 1553 */           processServices(importDefinition);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1558 */       this.allBindings = null;
/*      */     }
/*      */ 
/* 1561 */     log.trace("END processServices: " + srcWsdl.getDocumentBaseURI());
/*      */   }
/*      */ 
/*      */   private void processPorts(Definition srcWsdl, WSDLService destService, Service srcService) throws WSDLException
/*      */   {
/* 1566 */     Iterator it = srcService.getPorts().values().iterator();
/* 1567 */     while (it.hasNext())
/*      */     {
/* 1569 */       Port srcPort = (Port)it.next();
/* 1570 */       processPort(srcWsdl, destService, srcPort);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processPort(Definition srcWsdl, WSDLService destService, Port srcPort) throws WSDLException
/*      */   {
/* 1576 */     log.trace("processPort: " + srcPort.getName());
/*      */ 
/* 1578 */     Binding srcBinding = getDefinedBinding(srcPort);
/* 1579 */     QName endpointName = new QName(srcWsdl.getTargetNamespace(), srcPort.getName());
/* 1580 */     WSDLEndpoint destEndpoint = new WSDLEndpoint(destService, endpointName);
/* 1581 */     destEndpoint.setBinding(srcBinding.getQName());
/* 1582 */     destEndpoint.setAddress(getSOAPAddress(srcPort));
/* 1583 */     processUnknownExtensibilityElements(srcPort, destEndpoint);
/*      */ 
/* 1585 */     WSDLBinding destBinding = processBinding(srcWsdl, srcBinding);
/* 1586 */     if (destBinding != null)
/* 1587 */       destService.addEndpoint(destEndpoint);
/*      */   }
/*      */ 
/*      */   private String getSOAPAddress(Port srcPort)
/*      */     throws WSDLException
/*      */   {
/* 1594 */     String soapAddress = "dummy";
/*      */ 
/* 1596 */     Iterator it = srcPort.getExtensibilityElements().iterator();
/* 1597 */     while (it.hasNext())
/*      */     {
/* 1599 */       ExtensibilityElement extElement = (ExtensibilityElement)it.next();
/* 1600 */       QName elementType = extElement.getElementType();
/*      */ 
/* 1602 */       if ((extElement instanceof SOAPAddress))
/*      */       {
/* 1604 */         SOAPAddress addr = (SOAPAddress)extElement;
/* 1605 */         soapAddress = addr.getLocationURI();
/* 1606 */         break;
/*      */       }
/* 1608 */       if ((extElement instanceof SOAP12Address))
/*      */       {
/* 1610 */         SOAP12Address addr = (SOAP12Address)extElement;
/* 1611 */         soapAddress = addr.getLocationURI();
/* 1612 */         break;
/*      */       }
/* 1614 */       if ("address".equals(elementType.getLocalPart()))
/*      */       {
/* 1616 */         log.warn("Unprocessed extension element: " + elementType);
/*      */       }
/*      */     }
/*      */ 
/* 1620 */     if (soapAddress == null) {
/* 1621 */       throw new WSDLException("INVALID_WSDL", "Cannot obtain SOAP address");
/*      */     }
/* 1623 */     return soapAddress;
/*      */   }
/*      */ 
/*      */   private String getOptionalAttribute(Element domElement, String attrName)
/*      */   {
/* 1628 */     String attrValue = domElement.getAttribute(attrName);
/* 1629 */     return attrValue.length() > 0 ? attrValue : null;
/*      */   }
/*      */ 
/*      */   static abstract interface ReferenceCallback
/*      */   {
/*      */     public abstract void removeReference(QName paramQName);
/*      */ 
/*      */     public abstract void removeRPCPart(String paramString);
/*      */ 
/*      */     public abstract QName getXmlType(String paramString);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDL11Reader
 * JD-Core Version:    0.6.0
 */