/*    */ package org.jboss.ws.tools.wsdl;
/*    */ 
/*    */ import java.net.URL;
/*    */ import javax.wsdl.Definition;
/*    */ import javax.wsdl.WSDLException;
/*    */ import javax.wsdl.extensions.ExtensionRegistry;
/*    */ import javax.wsdl.factory.WSDLFactory;
/*    */ import javax.wsdl.xml.WSDLReader;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*    */ import org.xml.sax.EntityResolver;
/*    */ 
/*    */ public class WSDL11DefinitionFactory
/*    */ {
/* 47 */   private static Logger log = Logger.getLogger(WSDL11DefinitionFactory.class);
/*    */   public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
/*    */   public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
/*    */   private WSDLReader wsdlReader;
/*    */ 
/*    */   private WSDL11DefinitionFactory()
/*    */     throws WSDLException
/*    */   {
/* 60 */     WSDLFactory wsdlFactory = WSDLFactory.newInstance();
/* 61 */     this.wsdlReader = wsdlFactory.newWSDLReader();
/*    */ 
/* 63 */     this.wsdlReader.setExtensionRegistry(new ExtensionRegistry());
/* 64 */     this.wsdlReader.setFeature("javax.wsdl.verbose", false);
/*    */   }
/*    */ 
/*    */   public static WSDL11DefinitionFactory newInstance()
/*    */     throws WSDLException
/*    */   {
/* 70 */     return new WSDL11DefinitionFactory();
/*    */   }
/*    */ 
/*    */   public void setFeature(String name, boolean value)
/*    */     throws IllegalArgumentException
/*    */   {
/* 76 */     this.wsdlReader.setFeature(name, value);
/*    */   }
/*    */ 
/*    */   public Definition parse(URL wsdlLocation)
/*    */     throws WSDLException
/*    */   {
/* 84 */     if (wsdlLocation == null) {
/* 85 */       throw new IllegalArgumentException("URL cannot be null");
/*    */     }
/* 87 */     log.trace("parse: " + wsdlLocation.toExternalForm());
/*    */ 
/* 89 */     EntityResolver entityResolver = new JBossWSEntityResolver();
/*    */ 
/* 94 */     Definition wsdlDefinition = this.wsdlReader.readWSDL(new WSDLLocatorImpl(entityResolver, wsdlLocation));
/*    */ 
/* 96 */     return wsdlDefinition;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDL11DefinitionFactory
 * JD-Core Version:    0.6.0
 */