/*     */ package org.jboss.ws.tools.schema;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IndexedPropertyDescriptor;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.TreeMap;
/*     */ import javax.ejb.SessionBean;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping.WrapperType;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModelGroup;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSParticle;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSSimpleTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ 
/*     */ public class SchemaTypeCreator
/*     */   implements SchemaCreatorIntf
/*     */ {
/*  83 */   protected Logger log = Logger.getLogger(SchemaTypeCreator.class);
/*  84 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*  86 */   protected SchemaUtils schemautils = SchemaUtils.getInstance();
/*  87 */   protected WSSchemaUtils sutils = null;
/*     */ 
/*  89 */   protected LiteralTypeMapping typeMapping = new LiteralTypeMapping();
/*     */ 
/*  92 */   private NamespaceRegistry namespaces = null;
/*     */ 
/*  94 */   private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
/*     */ 
/*  96 */   protected String xsNS = "http://www.w3.org/2001/XMLSchema";
/*     */ 
/*  98 */   private int maxPrefix = 1;
/*     */ 
/* 100 */   protected JBossXSModel xsModel = null;
/*     */ 
/* 103 */   protected Map<String, String> packageNamespaceMap = new HashMap();
/*     */ 
/*     */   public SchemaTypeCreator()
/*     */   {
/* 107 */     this.xsModel = new JBossXSModel();
/* 108 */     this.namespaces = this.xsModel.getNamespaceRegistry();
/* 109 */     this.sutils = WSSchemaUtils.getInstance(this.namespaces, null);
/*     */   }
/*     */ 
/*     */   public void addPackageNamespaceMapping(String pkgname, String ns)
/*     */   {
/* 118 */     if (pkgname == null)
/* 119 */       throw new IllegalArgumentException("Illegal Null Argument:pkgname");
/* 120 */     if (ns == null)
/* 121 */       throw new IllegalArgumentException("Illegal Null Argument:ns");
/* 122 */     this.packageNamespaceMap.put(pkgname, ns);
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition generateType(QName xmlType, Class javaType)
/*     */   {
/* 128 */     return generateType(xmlType, javaType, null);
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition generateType(QName xmlType, Class javaType, Map<String, QName> elementNames)
/*     */   {
/* 133 */     return getType(xmlType, javaType, elementNames);
/*     */   }
/*     */ 
/*     */   public QName getXMLSchemaType(Class javaType)
/*     */   {
/* 138 */     QName xmlt = this.schemautils.getToolsOverrideInTypeMapping(javaType);
/*     */ 
/* 140 */     if (xmlt == null)
/* 141 */       xmlt = this.typeMapping.getXMLType(javaType, false);
/* 142 */     return xmlt;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/* 147 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public JBossXSModel getXSModel()
/*     */   {
/* 155 */     return this.xsModel;
/*     */   }
/*     */ 
/*     */   public HashMap getCustomNamespaceMap()
/*     */   {
/* 163 */     HashMap map = null;
/* 164 */     if (this.namespaces != null)
/*     */     {
/* 166 */       Iterator iter = this.namespaces.getRegisteredPrefixes();
/* 167 */       while ((iter != null) && (iter.hasNext()))
/*     */       {
/* 169 */         String prefix = (String)iter.next();
/* 170 */         if (prefix.startsWith("ns"))
/*     */         {
/* 172 */           if (map == null)
/* 173 */             map = new HashMap();
/* 174 */           map.put(prefix, this.namespaces.getNamespaceURI(prefix));
/*     */         }
/*     */       }
/*     */     }
/* 178 */     return map;
/*     */   }
/*     */ 
/*     */   public Map<String, String> getPackageNamespaceMap()
/*     */   {
/* 186 */     return this.packageNamespaceMap;
/*     */   }
/*     */ 
/*     */   public LiteralTypeMapping getTypeMapping()
/*     */   {
/* 194 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public Class getJavaType(QName xmlType)
/*     */   {
/* 202 */     Class retType = this.typeMapping.getJavaType(xmlType);
/* 203 */     if (retType == null)
/* 204 */       throw new IllegalArgumentException("Unsupported type: " + xmlType);
/* 205 */     return retType;
/*     */   }
/*     */ 
/*     */   public void setXSModel(JBossXSModel xsm)
/*     */   {
/* 213 */     this.xsModel = xsm;
/*     */   }
/*     */ 
/*     */   public String allocatePrefix(String nsURI)
/*     */   {
/* 224 */     String prefix = this.namespaces.getPrefix(nsURI);
/* 225 */     return prefix == null ? this.namespaces.registerURI(nsURI, null) : prefix;
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> packageNamespaceMap)
/*     */   {
/* 233 */     this.packageNamespaceMap = packageNamespaceMap;
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition checkTypeExistsInXSModel(QName xmlt)
/*     */   {
/* 239 */     JBossXSTypeDefinition ct = null;
/* 240 */     if ((xmlt != null) && (this.xsModel != null))
/* 241 */       ct = getXSTypeDefinitionIfPresent(xmlt);
/* 242 */     return ct;
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition getType(QName xmlType, Class javaType, Map<String, QName> elementNames)
/*     */   {
/* 247 */     JBossXSTypeDefinition ct = null;
/* 248 */     boolean registered = false;
/*     */ 
/* 251 */     if (xmlType == null)
/*     */     {
/* 253 */       xmlType = getXMLSchemaType(javaType);
/* 254 */       registered = xmlType != null;
/*     */     }
/*     */     else
/*     */     {
/* 258 */       registered = this.typeMapping.isRegistered(javaType, xmlType);
/*     */     }
/*     */ 
/* 262 */     if (registered) {
/* 263 */       ct = checkTypeExistsInXSModel(xmlType);
/*     */     }
/*     */ 
/* 266 */     if ((ct == null) && (xmlType != null) && ("http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI())) && (!javaType.isArray())) {
/* 267 */       ct = this.schemautils.getSchemaBasicType(xmlType.getLocalPart());
/*     */     }
/* 269 */     if ((ct == null) && (Exception.class.isAssignableFrom(javaType))) {
/* 270 */       ct = getComplexTypeForJavaException(xmlType, javaType);
/*     */     }
/*     */ 
/* 273 */     if (ct == null) {
/* 274 */       ct = generateNewType(xmlType, javaType, elementNames);
/*     */     }
/* 276 */     return ct;
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition getXSTypeDefinitionIfPresent(QName qname)
/*     */   {
/* 281 */     return (JBossXSTypeDefinition)this.xsModel.getTypeDefinition(qname.getLocalPart(), qname.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition generateNewType(QName xmlType, Class javaType, Map<String, QName> elementNames)
/*     */   {
/* 287 */     Class superclass = javaType.getSuperclass();
/* 288 */     JBossXSTypeDefinition baseType = null;
/* 289 */     List particles = new ArrayList();
/* 290 */     if ((superclass != null) && (!this.utils.checkIgnoreClass(superclass)))
/*     */     {
/* 292 */       baseType = generateType(null, superclass);
/* 293 */       if (baseType != null)
/*     */       {
/* 295 */         addBaseTypeParts(baseType, particles);
/*     */       }
/*     */     }
/*     */ 
/* 299 */     if (javaType.isArray())
/* 300 */       return handleArray(xmlType, javaType);
/*     */     String namespace;
/*     */     String name;
/*     */     String namespace;
/* 304 */     if (xmlType != null)
/*     */     {
/* 306 */       String name = xmlType.getLocalPart();
/* 307 */       namespace = xmlType.getNamespaceURI();
/*     */     }
/*     */     else
/*     */     {
/* 311 */       name = WSDLUtils.getJustClassName(javaType);
/* 312 */       namespace = getNamespace(javaType);
/*     */     }
/*     */ 
/* 316 */     Class valueType = getEnumerationValueType(javaType);
/* 317 */     if (valueType != null) {
/* 318 */       return handleJAXRPCEnumeration(name, namespace, javaType, valueType);
/*     */     }
/*     */ 
/* 322 */     JBossXSComplexTypeDefinition complexType = this.sutils.createXSComplexTypeDefinition(name, baseType, particles, namespace);
/* 323 */     QName registerQName = new QName(namespace, name);
/* 324 */     this.typeMapping.register(javaType, registerQName, null, null);
/* 325 */     this.xsModel.addXSComplexTypeDefinition(complexType);
/*     */ 
/* 328 */     particles.addAll(getXSParticlesForPublicFields(namespace, javaType, elementNames));
/*     */     try
/*     */     {
/* 333 */       particles.addAll(introspectJavaProperties(namespace, javaType, elementNames));
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/* 337 */       this.log.error("Problem in introspection of the Java Type during type generation", e);
/* 338 */       throw new WSException(e);
/*     */     }
/*     */ 
/* 341 */     if ((elementNames instanceof LinkedHashMap))
/* 342 */       particles = sortNamedOuterParticles(particles, (LinkedHashMap)elementNames);
/* 343 */     else Collections.sort(particles);
/*     */ 
/* 345 */     registerJavaTypeMapping(registerQName, javaType, "complexType", particles, elementNames);
/*     */ 
/* 347 */     JBossXSModelGroup group = (JBossXSModelGroup)complexType.getParticle().getTerm();
/* 348 */     group.setParticles(particles);
/*     */ 
/* 350 */     if (this.log.isDebugEnabled())
/* 351 */       this.log.debug("generateNewType: " + this.sutils.write(complexType));
/* 352 */     return complexType;
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition handleJAXRPCEnumeration(String name, String namespace, Class<?> javaType, Class<?> valueType)
/*     */   {
/* 357 */     JBossXSTypeDefinition enumType = generateType(null, valueType);
/* 358 */     JBossXSSimpleTypeDefinition simpleType = new JBossXSSimpleTypeDefinition();
/* 359 */     simpleType.setBaseType(enumType);
/* 360 */     simpleType.setName(name);
/* 361 */     simpleType.setNamespace(namespace);
/*     */     try
/*     */     {
/* 364 */       Method getValue = javaType.getMethod("getValue", new Class[0]);
/* 365 */       for (Field field : javaType.getFields())
/*     */       {
/* 367 */         if ((!Modifier.isStatic(field.getModifiers())) || (!field.getType().equals(javaType)))
/*     */           continue;
/* 369 */         Object ret = getValue.invoke(field.get(null), new Object[0]);
/* 370 */         String item = SimpleTypeBindings.marshal(enumType.getName(), ret, new NamespaceRegistry());
/* 371 */         simpleType.addLexicalEnumeration(item);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 377 */       throw new WSException("JAX-RPC Enumeration type did not conform to expectations");
/*     */     }
/*     */ 
/* 380 */     this.xsModel.addXSTypeDefinition(simpleType);
/* 381 */     registerJavaTypeMapping(new QName(namespace, name), javaType, "simpleType", new ArrayList(), null);
/*     */ 
/* 383 */     return simpleType;
/*     */   }
/*     */ 
/*     */   private Class<?> getEnumerationValueType(Class javaType)
/*     */   {
/*     */     try
/*     */     {
/* 390 */       javaType.getConstructor(new Class[0]);
/* 391 */       return null;
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 397 */       for (Method method : javaType.getMethods())
/*     */       {
/* 399 */         if ((Modifier.isStatic(method.getModifiers())) && (method.getName().equals("fromValue")) && (method.getParameterTypes().length == 1))
/* 400 */           return method.getParameterTypes()[0];
/*     */       }
/*     */     }
/* 403 */     return null;
/*     */   }
/*     */ 
/*     */   private List<XSParticle> sortNamedOuterParticles(List<XSParticle> particles, LinkedHashMap<String, QName> elementNames)
/*     */   {
/* 408 */     Map index = new LinkedHashMap();
/* 409 */     List newList = new ArrayList();
/* 410 */     for (XSParticle particle : particles)
/*     */     {
/* 412 */       XSTerm term = particle.getTerm();
/* 413 */       if ((term instanceof XSElementDeclaration))
/* 414 */         index.put(((XSElementDeclaration)term).getName(), particle);
/* 415 */       else newList.add(particle);
/*     */ 
/*     */     }
/*     */ 
/* 419 */     for (QName name : elementNames.values())
/*     */     {
/* 421 */       XSParticle found = (XSParticle)index.get(name.getLocalPart());
/* 422 */       if (found != null)
/*     */       {
/* 424 */         index.remove(name.getLocalPart());
/* 425 */         newList.add(found);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 430 */     for (XSParticle particle : index.values())
/*     */     {
/* 432 */       newList.add(particle);
/*     */     }
/*     */ 
/* 435 */     return newList;
/*     */   }
/*     */ 
/*     */   private void registerJavaTypeMapping(QName registerQName, Class javaType, String scope, List<XSParticle> particles, Map<String, QName> elementNames)
/*     */   {
/* 440 */     QName qname = new QName(registerQName.getNamespaceURI(), registerQName.getLocalPart(), "typeNS");
/*     */ 
/* 443 */     String packageName = this.javaWsdlMapping.getPackageNameForNamespaceURI(qname.getNamespaceURI());
/* 444 */     if ((packageName == null) && (javaType.getPackage() != null))
/*     */     {
/* 446 */       PackageMapping packageMapping = new PackageMapping(this.javaWsdlMapping);
/* 447 */       packageMapping.setNamespaceURI(qname.getNamespaceURI());
/* 448 */       packageMapping.setPackageType(javaType.getPackage().getName());
/* 449 */       this.javaWsdlMapping.addPackageMapping(packageMapping);
/*     */     }
/*     */ 
/* 452 */     JavaXmlTypeMapping javaXmlTypeMapping = new JavaXmlTypeMapping(this.javaWsdlMapping);
/* 453 */     javaXmlTypeMapping.setJavaType(javaType.getName());
/* 454 */     javaXmlTypeMapping.setQNameScope(scope);
/* 455 */     javaXmlTypeMapping.setRootTypeQName(qname);
/*     */ 
/* 458 */     Map reversedNames = null;
/* 459 */     if (elementNames != null)
/*     */     {
/* 461 */       reversedNames = new HashMap();
/* 462 */       for (String variable : elementNames.keySet()) {
/* 463 */         reversedNames.put(((QName)elementNames.get(variable)).getLocalPart(), variable);
/*     */       }
/*     */     }
/* 466 */     addVariableMappings(javaType, javaXmlTypeMapping, particles, reversedNames);
/*     */ 
/* 468 */     this.javaWsdlMapping.addJavaXmlTypeMappings(javaXmlTypeMapping);
/*     */   }
/*     */ 
/*     */   private void addVariableMappings(Class javaType, JavaXmlTypeMapping javaXmlTypeMapping, List<XSParticle> particles, Map<String, String> reversedNames)
/*     */   {
/* 473 */     for (XSParticle particle : particles)
/*     */     {
/* 475 */       XSTerm term = particle.getTerm();
/* 476 */       if (term.getType() == 7)
/*     */       {
/* 478 */         XSModelGroup group = (XSModelGroup)term;
/* 479 */         XSObjectList list = group.getParticles();
/* 480 */         ArrayList baseParticles = new ArrayList();
/* 481 */         for (int i = 0; i < list.getLength(); i++) {
/* 482 */           baseParticles.add((XSParticle)list.item(i));
/*     */         }
/* 484 */         addVariableMappings(javaType, javaXmlTypeMapping, baseParticles, null);
/*     */ 
/* 486 */         continue;
/*     */       }
/*     */ 
/* 489 */       String name = term.getName();
/* 490 */       String variableName = name;
/* 491 */       if ((reversedNames != null) && (reversedNames.get(name) != null)) {
/* 492 */         variableName = (String)reversedNames.get(name);
/*     */       }
/* 494 */       VariableMapping mapping = new VariableMapping(javaXmlTypeMapping);
/*     */ 
/* 496 */       mapping.setJavaVariableName(variableName);
/* 497 */       mapping.setXmlElementName(name);
/* 498 */       mapping.setDataMember(this.utils.doesPublicFieldExist(javaType, variableName));
/*     */ 
/* 500 */       if (!isAlreadyMapped(javaXmlTypeMapping, mapping))
/*     */       {
/* 502 */         javaXmlTypeMapping.addVariableMapping(mapping);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isAlreadyMapped(JavaXmlTypeMapping jxtm, VariableMapping vm)
/*     */   {
/* 509 */     String javaVariableName = vm.getJavaVariableName();
/* 510 */     String attributeName = vm.getXmlAttributeName();
/* 511 */     String elementName = vm.getXmlElementName();
/*     */ 
/* 513 */     for (VariableMapping current : jxtm.getVariableMappings())
/*     */     {
/* 515 */       boolean matched = checkStringEquality(javaVariableName, current.getJavaVariableName());
/*     */ 
/* 517 */       if (matched)
/*     */       {
/* 519 */         matched = checkStringEquality(attributeName, current.getXmlAttributeName());
/*     */       }
/*     */ 
/* 522 */       if (matched)
/*     */       {
/* 524 */         matched = checkStringEquality(elementName, current.getXmlElementName());
/*     */       }
/*     */ 
/* 527 */       if (matched)
/*     */       {
/* 529 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 533 */     return false;
/*     */   }
/*     */ 
/*     */   private List<XSParticle> getXSParticlesForPublicFields(String typeNamespace, Class javaType, Map<String, QName> elementNames)
/*     */   {
/* 538 */     List particles = new ArrayList();
/*     */ 
/* 540 */     for (Field field : this.utils.getPublicFields(javaType))
/*     */     {
/* 543 */       if (Collection.class.isAssignableFrom(field.getType()))
/*     */       {
/* 545 */         this.log.warn("JAX-RPC does not allow collection types skipping field: " + javaType.getName() + "." + field.getName());
/*     */       }
/*     */       else
/*     */       {
/* 549 */         JBossXSParticle particle = createFieldParticle(typeNamespace, field.getName(), field.getType(), elementNames);
/* 550 */         particles.add(particle);
/*     */       }
/*     */     }
/* 553 */     return particles;
/*     */   }
/*     */ 
/*     */   private JBossXSTypeDefinition handleArray(QName xmlType, Class javaType)
/*     */   {
/* 558 */     Class componentType = javaType.getComponentType();
/* 559 */     boolean isComponentArray = componentType.isArray();
/*     */ 
/* 562 */     JBossXSTypeDefinition xst = isComponentArray ? handleArray(null, componentType) : generateType(null, componentType);
/*     */     String namespace;
/*     */     String name;
/*     */     String namespace;
/* 567 */     if (xmlType != null)
/*     */     {
/* 569 */       String name = xmlType.getLocalPart();
/* 570 */       namespace = xmlType.getNamespaceURI();
/*     */     }
/*     */     else
/*     */     {
/*     */       String namespace;
/* 574 */       if (!isComponentArray)
/*     */       {
/* 576 */         String name = WSDLUtils.getJustClassName(componentType.getName()) + ".Array";
/* 577 */         namespace = getNamespace(componentType);
/*     */       }
/*     */       else
/*     */       {
/* 581 */         name = xst.getName() + ".Array";
/* 582 */         namespace = xst.getNamespace();
/*     */       }
/*     */     }
/*     */ 
/* 586 */     JBossXSParticle xsp = new JBossXSParticle();
/* 587 */     xsp.setTerm(this.sutils.createXSElementDeclaration("value", xst, !componentType.isPrimitive()));
/* 588 */     xsp.setMaxOccurs(-1);
/* 589 */     List particles = new ArrayList();
/* 590 */     particles.add(xsp);
/*     */ 
/* 592 */     JBossXSComplexTypeDefinition complex = this.sutils.createXSComplexTypeDefinition(name, null, particles, namespace);
/* 593 */     this.xsModel.addXSComplexTypeDefinition(complex);
/* 594 */     this.typeMapping.register(javaType, new QName(namespace, name), null, null);
/*     */ 
/* 596 */     return complex;
/*     */   }
/*     */ 
/*     */   private List<XSParticle> introspectJavaProperties(String typeNamespace, Class javaType, Map<String, QName> elementNames) throws IntrospectionException
/*     */   {
/* 601 */     List xsparts = new ArrayList();
/*     */ 
/* 603 */     Class superClass = javaType.getSuperclass();
/* 604 */     BeanInfo beanInfo = Introspector.getBeanInfo(javaType, superClass);
/* 605 */     PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
/* 606 */     int len = props != null ? props.length : 0;
/*     */ 
/* 608 */     for (int i = 0; (i < len) && (!SessionBean.class.isAssignableFrom(javaType)); i++)
/*     */     {
/* 610 */       PropertyDescriptor prop = props[i];
/* 611 */       String fieldname = prop.getName();
/* 612 */       Class fieldType = prop.getPropertyType();
/*     */ 
/* 614 */       if (((prop instanceof IndexedPropertyDescriptor)) && (fieldType == null))
/*     */       {
/* 616 */         this.log.warn("Indexed Properties without non-indexed accessors are not supported skipping: " + javaType.getName() + "." + fieldname);
/*     */       }
/*     */       else
/*     */       {
/* 621 */         if (fieldType.equals(ParameterWrapping.WrapperType.class))
/*     */         {
/*     */           continue;
/*     */         }
/* 625 */         if (Collection.class.isAssignableFrom(fieldType))
/*     */         {
/* 627 */           this.log.warn("JAX-RPC does not allow collection types skipping: " + javaType.getName() + "." + fieldname);
/*     */         }
/*     */         else
/*     */         {
/* 632 */           if (this.utils.doesPublicFieldExist(javaType, fieldname)) {
/* 633 */             throw new WSException("Class " + javaType.getName() + " has a public field & property :" + fieldname);
/*     */           }
/* 635 */           JBossXSParticle particle = createFieldParticle(typeNamespace, fieldname, fieldType, elementNames);
/* 636 */           xsparts.add(particle);
/*     */         }
/*     */       }
/*     */     }
/* 639 */     return xsparts;
/*     */   }
/*     */ 
/*     */   private JBossXSParticle createFieldParticle(String typeNamespace, String fieldName, Class fieldType, Map<String, QName> elementNames)
/*     */   {
/* 645 */     boolean isArray = (fieldType.isArray()) && (fieldType != [B.class);
/* 646 */     if (isArray) {
/* 647 */       fieldType = fieldType.getComponentType();
/*     */     }
/*     */ 
/* 650 */     XSTypeDefinition xst = (isArray) && (fieldType.isArray()) ? handleArray(null, fieldType) : generateType(null, fieldType);
/*     */ 
/* 652 */     String elementNamespace = null;
/* 653 */     if (elementNames != null)
/*     */     {
/* 655 */       QName name = (QName)elementNames.get(fieldName);
/* 656 */       if (name != null)
/*     */       {
/* 658 */         fieldName = name.getLocalPart();
/* 659 */         elementNamespace = name.getNamespaceURI();
/* 660 */         if (typeNamespace.equals(elementNamespace))
/* 661 */           elementNamespace = null;
/*     */       }
/*     */     }
/*     */     JBossXSElementDeclaration xsel;
/*     */     JBossXSElementDeclaration xsel;
/* 666 */     if ((elementNamespace == null) || (elementNamespace.length() == 0))
/*     */     {
/* 668 */       xsel = this.sutils.createXSElementDeclaration(fieldName, xst, !fieldType.isPrimitive());
/*     */     }
/*     */     else
/*     */     {
/* 675 */       xsel = this.sutils.createGlobalXSElementDeclaration(fieldName, xst, elementNamespace);
/* 676 */       this.xsModel.addXSElementDeclaration(xsel);
/*     */     }
/*     */ 
/* 679 */     JBossXSParticle particle = this.sutils.createXSParticle(typeNamespace, isArray, xsel);
/* 680 */     return particle;
/*     */   }
/*     */ 
/*     */   private void addBaseTypeParts(XSTypeDefinition baseType, List xsparts)
/*     */   {
/* 685 */     if (baseType == null)
/* 686 */       throw new IllegalArgumentException("Illegal Null Argument:baseType");
/* 687 */     if (15 == baseType.getTypeCategory())
/*     */     {
/* 689 */       XSTypeDefinition btype = baseType.getBaseType();
/* 690 */       if (btype != null) {
/* 691 */         addBaseTypeParts(btype, xsparts);
/*     */       }
/* 693 */       XSParticle part = ((XSComplexTypeDefinition)baseType).getParticle();
/* 694 */       XSTerm term = part.getTerm();
/* 695 */       if ((term instanceof XSModelGroup))
/*     */       {
/* 697 */         JBossXSParticle p = new JBossXSParticle();
/* 698 */         p.setTerm(term);
/* 699 */         xsparts.add(p);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getNamespace(Class javaType)
/*     */   {
/* 706 */     if (javaType.isPrimitive()) {
/* 707 */       return "http://www.jboss.org/jbossws/primitives";
/*     */     }
/* 709 */     Package javaPackage = javaType.getPackage();
/* 710 */     if (javaPackage == null)
/* 711 */       throw new WSException("Cannot determine namespace, Class had no package");
/* 712 */     String packageName = javaPackage.getName();
/*     */ 
/* 714 */     String ns = (String)this.packageNamespaceMap.get(packageName);
/* 715 */     if (ns == null) {
/* 716 */       ns = WSDLUtils.getTypeNamespace(packageName);
/*     */     }
/* 718 */     allocatePrefix(ns);
/*     */ 
/* 720 */     return ns;
/*     */   }
/*     */ 
/*     */   private JBossXSComplexTypeDefinition getComplexTypeForJavaException(QName xmlType, Class javaType)
/*     */   {
/* 725 */     if (!Exception.class.isAssignableFrom(javaType))
/* 726 */       throw new IllegalArgumentException("Type is not an excpetion");
/* 727 */     if (RuntimeException.class.isAssignableFrom(javaType))
/* 728 */       throw new IllegalArgumentException("JAX-RPC violation, the following exception extends RuntimeException: " + javaType.getName());
/*     */     String name;
/*     */     String namespace;
/*     */     String name;
/* 732 */     if (xmlType != null)
/*     */     {
/* 734 */       String namespace = xmlType.getNamespaceURI();
/* 735 */       name = xmlType.getLocalPart();
/*     */     }
/*     */     else
/*     */     {
/* 739 */       namespace = getNamespace(javaType);
/* 740 */       name = WSDLUtils.getJustClassName(javaType);
/*     */     }
/*     */ 
/* 743 */     List particles = new ArrayList(0);
/* 744 */     List types = new ArrayList(0);
/* 745 */     JBossXSComplexTypeDefinition complexType = new JBossXSComplexTypeDefinition();
/* 746 */     complexType.setName(name);
/* 747 */     complexType.setNamespace(namespace);
/*     */ 
/* 749 */     this.xsModel.addXSComplexTypeDefinition(complexType);
/* 750 */     this.xsModel.addXSElementDeclaration(this.sutils.createGlobalXSElementDeclaration(name, complexType, namespace));
/* 751 */     this.typeMapping.register(javaType, new QName(namespace, name), null, null);
/* 752 */     registerJavaTypeMapping(new QName(namespace, name), javaType, "complexType", particles, null);
/*     */ 
/* 754 */     Class superClass = javaType.getSuperclass();
/* 755 */     if ((!Exception.class.equals(superClass)) || (Throwable.class.equals(superClass)))
/*     */     {
/* 757 */       JBossXSTypeDefinition baseType = generateType(null, superClass);
/* 758 */       complexType.setBaseType(baseType);
/*     */     }
/*     */ 
/* 761 */     generateExceptionParticles(namespace, javaType, types, particles);
/*     */ 
/* 763 */     boolean found = hasConstructor(javaType, types);
/* 764 */     boolean noarg = (found) && (types.size() == 0);
/*     */ 
/* 766 */     if ((!found) || (noarg))
/*     */     {
/* 770 */       ArrayList newTypes = new ArrayList(types);
/* 771 */       newTypes.add(0, String.class);
/* 772 */       found = hasConstructor(javaType, newTypes);
/* 773 */       if (found)
/*     */       {
/* 775 */         insertBaseParticle(particles, "message", String.class, namespace);
/*     */       }
/* 780 */       else if (!noarg) {
/* 781 */         throw new IllegalArgumentException("Could not locate a constructor with the following types: " + javaType + ' ' + types);
/*     */       }
/*     */     }
/*     */ 
/* 785 */     complexType.setParticle(createGroupParticle(namespace, particles));
/*     */ 
/* 787 */     return complexType;
/*     */   }
/*     */ 
/*     */   private void insertBaseParticle(List<XSParticle> particles, String name, Class type, String targetNS)
/*     */   {
/* 792 */     if (particles.size() == 0)
/*     */     {
/* 794 */       particles.add(getXSParticle(name, type, targetNS));
/* 795 */       return;
/*     */     }
/*     */ 
/* 798 */     XSParticle particle = (XSParticle)particles.get(0);
/* 799 */     XSTerm term = particle.getTerm();
/* 800 */     if (term.getType() == 7)
/*     */     {
/* 802 */       JBossXSModelGroup group = (JBossXSModelGroup)term;
/* 803 */       XSObjectList list = group.getParticles();
/* 804 */       ArrayList baseParticles = new ArrayList();
/* 805 */       for (int i = 0; i < list.getLength(); i++) {
/* 806 */         baseParticles.add((XSParticle)list.item(i));
/*     */       }
/* 808 */       insertBaseParticle(baseParticles, name, type, targetNS);
/*     */ 
/* 810 */       if (baseParticles.size() > list.getLength())
/* 811 */         group.setParticles(baseParticles);
/*     */     }
/*     */     else
/*     */     {
/* 815 */       particles.add(0, getXSParticle(name, type, targetNS));
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean hasConstructor(Class javaType, List<Class> types)
/*     */   {
/* 821 */     boolean found = true;
/*     */     try
/*     */     {
/* 825 */       javaType.getConstructor((Class[])types.toArray(new Class[0]));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 829 */       found = false;
/*     */     }
/*     */ 
/* 832 */     return found;
/*     */   }
/*     */ 
/*     */   private void generateExceptionParticles(String typeNamespace, Class javaType, List<Class> types, List<XSParticle> particles)
/*     */   {
/* 851 */     if (Exception.class.equals(javaType)) {
/* 852 */       return;
/*     */     }
/* 854 */     Class superClass = javaType.getSuperclass();
/* 855 */     if (!Exception.class.equals(superClass))
/*     */     {
/* 857 */       List superParticles = new ArrayList(0);
/* 858 */       generateExceptionParticles(typeNamespace, superClass, types, superParticles);
/* 859 */       particles.add(createGroupParticle(typeNamespace, superParticles));
/*     */     }
/*     */ 
/* 862 */     TreeMap sortedGetters = new TreeMap();
/* 863 */     for (Method method : javaType.getDeclaredMethods())
/*     */     {
/* 865 */       int modifiers = method.getModifiers();
/* 866 */       if ((!Modifier.isPublic(modifiers)) || (Modifier.isStatic(modifiers))) {
/*     */         continue;
/*     */       }
/* 869 */       String name = method.getName();
/* 870 */       Class returnType = method.getReturnType();
/* 871 */       if ((!name.startsWith("get")) || (returnType == Void.TYPE))
/*     */         continue;
/* 873 */       name = Introspector.decapitalize(name.substring(3));
/* 874 */       sortedGetters.put(name, returnType);
/*     */     }
/*     */ 
/* 878 */     for (String name : sortedGetters.keySet())
/*     */     {
/* 880 */       Class type = (Class)sortedGetters.get(name);
/* 881 */       types.add(type);
/* 882 */       JBossXSParticle particle = createFieldParticle(typeNamespace, name, type, null);
/* 883 */       particles.add(particle);
/*     */     }
/*     */   }
/*     */ 
/*     */   private JBossXSParticle createGroupParticle(String targetNS, List<XSParticle> memberParticles)
/*     */   {
/* 889 */     JBossXSParticle groupParticle = new JBossXSParticle(null, targetNS);
/* 890 */     JBossXSModelGroup group = new JBossXSModelGroup();
/* 891 */     group.setParticles(memberParticles, false);
/* 892 */     groupParticle.setTerm(group);
/*     */ 
/* 894 */     return groupParticle;
/*     */   }
/*     */ 
/*     */   private JBossXSParticle getXSParticle(String name, Class fieldType, String targetNS)
/*     */   {
/* 899 */     XSTypeDefinition xstype = null;
/* 900 */     boolean isArray = fieldType.isArray();
/*     */ 
/* 902 */     if (isArray) {
/* 903 */       fieldType = fieldType.getComponentType();
/*     */     }
/* 905 */     xstype = generateType(null, fieldType);
/* 906 */     boolean isNillable = !fieldType.isPrimitive();
/* 907 */     JBossXSElementDeclaration xsel = this.sutils.createXSElementDeclaration(name, xstype, isNillable);
/*     */ 
/* 909 */     return this.sutils.createXSParticle(targetNS, isArray, xsel);
/*     */   }
/*     */ 
/*     */   private boolean checkStringEquality(String str1, String str2)
/*     */   {
/* 914 */     if ((str1 == null) && (str2 == null))
/* 915 */       return true;
/* 916 */     if ((str1 == null) && (str2 != null))
/* 917 */       return false;
/* 918 */     if ((str1 != null) && (str2 == null))
/* 919 */       return false;
/* 920 */     return str1.equals(str2);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.schema.SchemaTypeCreator
 * JD-Core Version:    0.6.0
 */