/*     */ package org.jboss.ws.tools.mapping;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.tools.JavaWriter;
/*     */ import org.jboss.ws.tools.XSDTypeToJava;
/*     */ import org.jboss.ws.tools.XSDTypeToJava.VAR;
/*     */ import org.jboss.ws.tools.helpers.MappingFileGeneratorHelper;
/*     */ 
/*     */ public class MappingFileGenerator
/*     */ {
/*     */   protected WSDLDefinitions wsdlDefinitions;
/*     */   protected String packageName;
/*     */   protected String serviceName;
/*  84 */   protected Class serviceEndpointInterface = null;
/*     */ 
/*  89 */   protected LiteralTypeMapping typeMapping = null;
/*     */   protected String parameterStyle;
/*     */ 
/*     */   public MappingFileGenerator(WSDLDefinitions wsdl, TypeMapping typeM)
/*     */   {
/*  95 */     this.wsdlDefinitions = wsdl;
/*  96 */     this.typeMapping = ((LiteralTypeMapping)typeM);
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinitions()
/*     */   {
/* 104 */     return this.wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public void setWsdlDefinitions(WSDLDefinitions wsdlDefinitions)
/*     */   {
/* 109 */     this.wsdlDefinitions = wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public String getPackageName()
/*     */   {
/* 117 */     return this.packageName;
/*     */   }
/*     */ 
/*     */   public void setPackageName(String packageName)
/*     */   {
/* 122 */     this.packageName = packageName;
/*     */   }
/*     */ 
/*     */   public String getServiceName()
/*     */   {
/* 130 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointInterface(Class serviceEndpointInterface)
/*     */   {
/* 135 */     this.serviceEndpointInterface = serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceName(String serviceName)
/*     */   {
/* 140 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public void setParameterStyle(String paramStyle)
/*     */   {
/* 145 */     this.parameterStyle = paramStyle;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping generate()
/*     */     throws IOException
/*     */   {
/* 159 */     MappingFileGeneratorHelper helper = new MappingFileGeneratorHelper(this.wsdlDefinitions, this.serviceName, this.packageName, this.serviceEndpointInterface, this.typeMapping, this.parameterStyle);
/*     */ 
/* 161 */     JavaWsdlMapping jwm = new JavaWsdlMapping();
/*     */ 
/* 164 */     helper.constructJavaXmlTypeMapping(jwm);
/* 165 */     WSDLService[] services = this.wsdlDefinitions.getServices();
/* 166 */     int lenServices = 0;
/* 167 */     if (services != null)
/* 168 */       lenServices = services.length;
/* 169 */     for (int i = 0; i < lenServices; i++)
/*     */     {
/* 171 */       WSDLService wsdlService = services[i];
/* 172 */       jwm.addServiceInterfaceMappings(helper.constructServiceInterfaceMapping(jwm, wsdlService));
/* 173 */       helper.constructServiceEndpointInterfaceMapping(jwm, wsdlService);
/*     */     }
/*     */ 
/* 177 */     String targetNS = this.wsdlDefinitions.getTargetNamespace();
/* 178 */     String typeNamespace = helper.getTypeNamespace();
/* 179 */     if (typeNamespace == null) {
/* 180 */       typeNamespace = targetNS;
/*     */     }
/*     */ 
/* 184 */     if (((typeNamespace != null) && (!typeNamespace.equals(targetNS))) || (isServerSideGeneration()))
/* 185 */       jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, typeNamespace));
/* 186 */     jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, targetNS));
/*     */ 
/* 188 */     return jwm;
/*     */   }
/*     */ 
/*     */   public void generateJavaSourceFileForRequestResponseStruct(File location, ServiceEndpointInterfaceMapping seim, JBossXSModel xsmodel, String typeNamespace)
/*     */     throws IOException
/*     */   {
/* 194 */     WSDLUtils utils = WSDLUtils.getInstance();
/* 195 */     XSDTypeToJava xst = new XSDTypeToJava();
/* 196 */     xst.setTypeMapping(this.typeMapping);
/* 197 */     xst.setPackageName(this.packageName);
/* 198 */     ServiceEndpointMethodMapping[] mapArr = seim.getServiceEndpointMethodMappings();
/* 199 */     int len = mapArr != null ? mapArr.length : 0;
/* 200 */     for (int i = 0; i < len; i++)
/*     */     {
/* 202 */       ServiceEndpointMethodMapping mm = mapArr[i];
/* 203 */       String opname = mm.getJavaMethodName();
/* 204 */       String sei = seim.getServiceEndpointInterface();
/* 205 */       String plainClassName = WSDLUtils.getJustClassName(sei);
/* 206 */       String classname = plainClassName + "_" + opname + "_RequestStruct";
/* 207 */       List listInputs = new ArrayList();
/* 208 */       MethodParamPartsMapping[] mppmarr = mm.getMethodParamPartsMappings();
/* 209 */       int lenmppmarr = mppmarr != null ? mppmarr.length : 0;
/* 210 */       for (int j = 0; j < lenmppmarr; j++)
/*     */       {
/* 212 */         listInputs.addAll(xst.getVARList((XSComplexTypeDefinition)xsmodel.getTypeDefinition(opname, typeNamespace), xsmodel, false));
/*     */       }
/* 214 */       JavaWriter jw = new JavaWriter();
/* 215 */       jw.createJavaFile(location, classname, this.packageName, listInputs, null, null, false, null);
/* 216 */       classname = plainClassName + "_" + opname + "_ResponseStruct";
/* 217 */       XSTypeDefinition xt = xsmodel.getTypeDefinition(opname + "Response", typeNamespace);
/* 218 */       List listOutputs = new ArrayList();
/* 219 */       if ((xt instanceof XSSimpleTypeDefinition))
/*     */       {
/* 221 */         listOutputs.add(new XSDTypeToJava.VAR("result", xt.getName(), false));
/*     */       }
/* 223 */       else listOutputs.addAll(xst.getVARList((XSComplexTypeDefinition)xt, xsmodel, false));
/* 224 */       jw.createJavaFile(location, classname, this.packageName, listOutputs, null, null, false, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isServerSideGeneration()
/*     */   {
/* 231 */     return this.serviceEndpointInterface != null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.mapping.MappingFileGenerator
 * JD-Core Version:    0.6.0
 */