/*     */ package org.jboss.ws.tools.helpers;
/*     */ 
/*     */ import java.beans.Introspector;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*     */ import org.apache.xerces.xs.XSAttributeUse;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceMessageReference;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.HeaderUtil;
/*     */ import org.jboss.ws.tools.RPCSignature;
/*     */ import org.jboss.ws.tools.ToolsUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class MappingFileGeneratorHelper
/*     */ {
/*  95 */   private static final Logger log = Logger.getLogger(MappingFileGeneratorHelper.class);
/*  96 */   private WSDLDefinitions wsdlDefinitions = null;
/*     */   private String typeNamespace;
/*  98 */   private String serviceName = null;
/*  99 */   private String packageName = null;
/* 100 */   private Set<String> registeredTypes = new HashSet();
/* 101 */   private Set<String> registeredExceptions = new HashSet();
/*     */ 
/* 103 */   private LiteralTypeMapping typeMapping = null;
/*     */   private String wsdlStyle;
/* 106 */   private WSDLUtils utils = WSDLUtils.getInstance();
/*     */   private String parameterStyle;
/*     */ 
/*     */   public MappingFileGeneratorHelper(WSDLDefinitions wsdl, String sname, String pname, Class seiClass, LiteralTypeMapping ltm, String paramStyle)
/*     */   {
/* 112 */     this.wsdlDefinitions = wsdl;
/* 113 */     this.serviceName = sname;
/* 114 */     this.packageName = pname;
/* 115 */     this.typeMapping = ltm;
/*     */ 
/* 117 */     this.wsdlStyle = this.utils.getWSDLStyle(wsdl);
/* 118 */     this.parameterStyle = paramStyle;
/* 119 */     checkEssentials();
/*     */   }
/*     */ 
/*     */   public String getTypeNamespace()
/*     */   {
/* 127 */     return this.typeNamespace;
/*     */   }
/*     */ 
/*     */   public PackageMapping constructPackageMapping(JavaWsdlMapping jwm, String packageType, String ns)
/*     */   {
/* 132 */     PackageMapping pk = new PackageMapping(jwm);
/* 133 */     pk.setPackageType(packageType);
/* 134 */     pk.setNamespaceURI(ns);
/* 135 */     return pk;
/*     */   }
/*     */ 
/*     */   public ServiceInterfaceMapping constructServiceInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser)
/*     */   {
/* 140 */     this.serviceName = ser.getName().getLocalPart();
/* 141 */     String javaServiceName = this.serviceName;
/*     */ 
/* 143 */     if (this.wsdlDefinitions.getInterface(new QName(this.wsdlDefinitions.getTargetNamespace(), this.serviceName)) != null) {
/* 144 */       javaServiceName = javaServiceName + "_Service";
/*     */     }
/* 146 */     if ((this.serviceName == null) || (this.serviceName.length() == 0)) {
/* 147 */       throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
/*     */     }
/* 149 */     String targetNS = this.wsdlDefinitions.getTargetNamespace();
/* 150 */     String prefix = "serviceNS";
/* 151 */     ServiceInterfaceMapping sim = new ServiceInterfaceMapping(jwm);
/* 152 */     sim.setServiceInterface(this.packageName + "." + javaServiceName);
/* 153 */     sim.setWsdlServiceName(new QName(targetNS, this.serviceName, prefix));
/*     */ 
/* 155 */     WSDLEndpoint[] endpoints = ser.getEndpoints();
/* 156 */     int lenendpoints = 0;
/* 157 */     if (endpoints != null)
/* 158 */       lenendpoints = endpoints.length;
/* 159 */     for (int j = 0; j < lenendpoints; j++)
/*     */     {
/* 161 */       WSDLEndpoint endpt = endpoints[j];
/* 162 */       String portname = endpt.getName().getLocalPart();
/*     */ 
/* 164 */       PortMapping pm = new PortMapping(sim);
/* 165 */       pm.setPortName(portname);
/* 166 */       pm.setJavaPortName(portname);
/* 167 */       sim.addPortMapping(pm);
/*     */     }
/* 169 */     return sim;
/*     */   }
/*     */ 
/*     */   public void constructServiceEndpointInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser)
/*     */   {
/* 174 */     this.serviceName = ser.getName().getLocalPart();
/* 175 */     if ((this.serviceName == null) || (this.serviceName.length() == 0)) {
/* 176 */       throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
/*     */     }
/* 178 */     String targetNS = this.wsdlDefinitions.getTargetNamespace();
/*     */ 
/* 180 */     WSDLEndpoint[] endpoints = ser.getEndpoints();
/* 181 */     int lenendpoints = 0;
/* 182 */     if (endpoints != null)
/* 183 */       lenendpoints = endpoints.length;
/* 184 */     for (int j = 0; j < lenendpoints; j++)
/*     */     {
/* 186 */       WSDLEndpoint endpt = endpoints[j];
/* 187 */       QName binding = endpt.getBinding();
/* 188 */       WSDLBinding wsdlbind = this.wsdlDefinitions.getBinding(binding);
/* 189 */       String bindName = wsdlbind.getName().getLocalPart();
/* 190 */       QName portTypeName = wsdlbind.getInterfaceName();
/* 191 */       WSDLInterface wsdlintf = this.wsdlDefinitions.getInterface(portTypeName);
/* 192 */       String portName = wsdlintf.getName().getLocalPart();
/* 193 */       String javaPortName = this.utils.chopPortType(portName);
/* 194 */       if (this.wsdlDefinitions.getService(javaPortName) != null) {
/* 195 */         javaPortName = javaPortName + "_PortType";
/*     */       }
/* 197 */       ServiceEndpointInterfaceMapping seim = new ServiceEndpointInterfaceMapping(jwm);
/* 198 */       seim.setServiceEndpointInterface(this.packageName + "." + javaPortName);
/* 199 */       seim.setWsdlPortType(new QName(targetNS, portName, "portTypeNS"));
/* 200 */       seim.setWsdlBinding(new QName(targetNS, bindName, "bindingNS"));
/* 201 */       constructServiceEndpointMethodMapping(seim, wsdlintf);
/*     */ 
/* 203 */       jwm.addServiceEndpointInterfaceMappings(seim);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void constructServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping seim, WSDLInterface intf)
/*     */   {
/* 209 */     WSDLInterfaceOperation[] wioparr = intf.getOperations();
/* 210 */     int len = 0;
/* 211 */     if (wioparr != null)
/* 212 */       len = wioparr.length;
/* 213 */     for (int j = 0; j < len; j++)
/*     */     {
/* 215 */       WSDLInterfaceOperation wiop = wioparr[j];
/* 216 */       String opname = wiop.getName().getLocalPart();
/* 217 */       ServiceEndpointMethodMapping semm = new ServiceEndpointMethodMapping(seim);
/* 218 */       semm.setJavaMethodName(ToolsUtils.firstLetterLowerCase(opname));
/* 219 */       semm.setWsdlOperation(opname);
/* 220 */       semm.setWrappedElement(isWrapped());
/*     */ 
/* 222 */       WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdlDefinitions, wiop);
/*     */ 
/* 224 */       if (isDocStyle())
/*     */       {
/* 226 */         constructDOCParameters(semm, wiop, bindingOperation);
/*     */       }
/*     */       else
/*     */       {
/* 230 */         constructRPCParameters(semm, wiop, bindingOperation);
/*     */       }
/*     */ 
/* 233 */       seim.addServiceEndpointMethodMapping(semm);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void constructDOCParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation)
/*     */   {
/* 239 */     WSDLInterfaceOperationInput win = WSDLUtils.getWsdl11Input(wiop);
/* 240 */     WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(wiop);
/*     */ 
/* 242 */     JBossXSModel schemaModel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
/* 243 */     MethodParamPartsMapping mpin = null;
/*     */ 
/* 245 */     boolean holder = false;
/*     */ 
/* 247 */     if (win != null)
/*     */     {
/* 249 */       QName xmlName = win.getElement();
/* 250 */       QName xmlType = win.getXMLType();
/* 251 */       String partName = win.getPartName();
/* 252 */       String wsdlMessageName = win.getMessageName().getLocalPart();
/* 253 */       XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 255 */       boolean wrapped = isWrapped();
/*     */ 
/* 257 */       if (wrapped)
/*     */       {
/* 259 */         wrapped = unwrapRequest(semm, wsdlMessageName, xmlName.getLocalPart(), xt);
/*     */       }
/*     */ 
/* 262 */       if (!wrapped)
/*     */       {
/* 264 */         if ((xt instanceof XSSimpleTypeDefinition))
/* 265 */           xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/* 266 */         String paramMode = "IN";
/* 267 */         holder = (output != null) && (xmlName.equals(output.getElement()));
/* 268 */         if (holder == true)
/*     */         {
/* 270 */           paramMode = "INOUT";
/*     */         }
/*     */ 
/* 273 */         mpin = getMethodParamPartsMapping(semm, xmlName, xmlType, 0, wsdlMessageName, paramMode, partName, false, true);
/* 274 */         semm.addMethodParamPartsMapping(mpin);
/*     */       }
/*     */     }
/*     */ 
/* 278 */     if ((!holder) && (output != null))
/*     */     {
/* 280 */       QName xmlName = output.getElement();
/* 281 */       QName xmlType = output.getXMLType();
/* 282 */       boolean primitive = true;
/*     */ 
/* 284 */       String targetNS = this.wsdlDefinitions.getTargetNamespace();
/* 285 */       QName messageName = new QName(targetNS, output.getMessageName().getLocalPart(), "wsdlMsgNS");
/*     */ 
/* 287 */       String partName = output.getPartName();
/* 288 */       String containingElement = xmlName.getLocalPart();
/* 289 */       boolean array = false;
/* 290 */       XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 292 */       ReturnTypeUnwrapper unwrapper = new ReturnTypeUnwrapper(xmlType, schemaModel, isWrapped());
/* 293 */       if (unwrapper.unwrap())
/*     */       {
/* 295 */         if (unwrapper.unwrappedElement != null)
/*     */         {
/* 297 */           XSElementDeclaration element = unwrapper.unwrappedElement;
/* 298 */           xt = element.getTypeDefinition();
/* 299 */           primitive = unwrapper.primitive;
/* 300 */           partName = element.getName();
/* 301 */           containingElement = containingElement + unwrapper.unwrappedElement.getName();
/* 302 */           array = unwrapper.array;
/* 303 */           if (xt.getAnonymous())
/*     */           {
/* 305 */             xmlType = new QName(containingElement);
/*     */           }
/* 307 */           else if (unwrapper.xmlType != null)
/*     */           {
/* 309 */             xmlType = unwrapper.xmlType;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 315 */       if (wiop.getInputByPartName(xmlName.getLocalPart()) == null)
/*     */       {
/* 318 */         if ((xt instanceof XSSimpleTypeDefinition)) {
/* 319 */           xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/*     */         }
/* 321 */         String javaType = getJavaTypeAsString(xmlName, xmlType, array, primitive);
/*     */ 
/* 323 */         if (((!isDocStyle()) && ("void".equals(javaType)) ? 1 : 0) == 0)
/*     */         {
/* 325 */           WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
/* 326 */           wrvm.setMethodReturnValue(javaType);
/* 327 */           wrvm.setWsdlMessage(messageName);
/* 328 */           wrvm.setWsdlMessagePartName(partName);
/* 329 */           semm.setWsdlReturnValueMapping(wrvm);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 334 */     if (bindingOperation != null)
/*     */     {
/* 336 */       constructHeaderParameters(semm, wiop, bindingOperation);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void constructHeaderParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation)
/*     */   {
/* 342 */     WSDLSOAPHeader[] inputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getInputs());
/* 343 */     WSDLSOAPHeader[] outputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs());
/*     */ 
/* 345 */     String wsdlMessageName = bindingOperation.getWsdlBinding().getInterface().getName().getLocalPart();
/* 346 */     int paramPosition = 1;
/*     */ 
/* 348 */     for (WSDLSOAPHeader currentInput : inputHeaders)
/*     */     {
/* 350 */       boolean inOutput = HeaderUtil.containsMatchingPart(outputHeaders, currentInput);
/* 351 */       String mode = getMode(true, inOutput);
/*     */ 
/* 353 */       constructHeaderParameter(semm, currentInput, paramPosition++, wsdlMessageName, mode);
/*     */     }
/*     */ 
/* 356 */     for (WSDLSOAPHeader currentOutput : outputHeaders)
/*     */     {
/* 358 */       boolean inInput = HeaderUtil.containsMatchingPart(inputHeaders, currentOutput);
/*     */ 
/* 360 */       if (inInput == true) {
/*     */         continue;
/*     */       }
/* 363 */       constructHeaderParameter(semm, currentOutput, paramPosition++, wsdlMessageName, "OUT");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void constructHeaderParameter(ServiceEndpointMethodMapping semm, WSDLSOAPHeader header, int paramPosition, String wsdlMessageName, String mode)
/*     */   {
/* 369 */     QName elementName = header.getElement();
/*     */ 
/* 371 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
/* 372 */     XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
/* 373 */     XSTypeDefinition xt = xe.getTypeDefinition();
/* 374 */     WSDLTypes wsdlTypes = this.wsdlDefinitions.getWsdlTypes();
/* 375 */     QName xmlType = wsdlTypes.getXMLType(header.getElement());
/*     */ 
/* 378 */     xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 379 */     if ((xt instanceof XSSimpleTypeDefinition))
/* 380 */       xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/* 381 */     String partName = header.getPartName();
/*     */ 
/* 383 */     MethodParamPartsMapping mpin = getMethodParamPartsMapping(semm, elementName, xmlType, paramPosition, wsdlMessageName, mode, partName, false, true);
/* 384 */     semm.addMethodParamPartsMapping(mpin);
/*     */   }
/*     */ 
/*     */   private String getMode(boolean input, boolean output)
/*     */   {
/* 389 */     if (((input == true ? 1 : 0) & (output == true ? 1 : 0)) != 0)
/*     */     {
/* 391 */       return "INOUT";
/*     */     }
/* 393 */     if (input == true)
/*     */     {
/* 395 */       return "IN";
/*     */     }
/* 397 */     if (output == true)
/*     */     {
/* 399 */       return "OUT";
/*     */     }
/*     */ 
/* 402 */     return "";
/*     */   }
/*     */ 
/*     */   private String getMode(WSDLInterfaceOperation op, String name)
/*     */   {
/* 407 */     WSDLInterfaceOperationInput in = WSDLUtils.getWsdl11Input(op);
/* 408 */     WSDLInterfaceOperationOutput out = WSDLUtils.getWsdl11Output(op);
/*     */ 
/* 410 */     boolean i = false; boolean o = false;
/* 411 */     if ((in != null) && (in.getChildPart(name) != null))
/* 412 */       i = true;
/* 413 */     if ((out != null) && (out.getChildPart(name) != null)) {
/* 414 */       o = true;
/*     */     }
/* 416 */     if ((i) && (o)) {
/* 417 */       return "INOUT";
/*     */     }
/* 419 */     if (o) {
/* 420 */       return "OUT";
/*     */     }
/* 422 */     return "IN";
/*     */   }
/*     */ 
/*     */   private void constructRPCParameters(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop, WSDLBindingOperation bindingOperation)
/*     */   {
/* 427 */     WSDLInterfaceOperationInput win = WSDLUtils.getWsdl11Input(wiop);
/* 428 */     if (win == null)
/* 429 */       throw new WSException("RPC endpoints require an input message");
/* 430 */     String wsdlMessageName = win.getMessageName().getLocalPart();
/* 431 */     JBossXSModel schemaModel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
/*     */ 
/* 433 */     RPCSignature signature = new RPCSignature(wiop);
/* 434 */     int i = 0;
/* 435 */     for (WSDLRPCPart part : signature.parameters())
/*     */     {
/* 437 */       String partName = part.getName();
/* 438 */       QName xmlName = new QName(partName);
/* 439 */       QName xmlType = part.getType();
/*     */ 
/* 441 */       XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 442 */       if ((xt instanceof XSSimpleTypeDefinition)) {
/* 443 */         xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/*     */       }
/* 445 */       MethodParamPartsMapping mpin = getMethodParamPartsMapping(semm, xmlName, xmlType, i++, wsdlMessageName, getMode(wiop, part.getName()), partName, false, true);
/*     */ 
/* 447 */       semm.addMethodParamPartsMapping(mpin);
/*     */     }
/*     */ 
/* 450 */     WSDLRPCPart returnParameter = signature.returnParameter();
/* 451 */     if (returnParameter != null)
/*     */     {
/* 453 */       String partName = returnParameter.getName();
/* 454 */       QName xmlName = new QName(partName);
/* 455 */       QName xmlType = returnParameter.getType();
/*     */ 
/* 457 */       XSTypeDefinition xt = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 458 */       if ((xt instanceof XSSimpleTypeDefinition)) {
/* 459 */         xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/*     */       }
/* 461 */       WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
/* 462 */       wrvm.setMethodReturnValue(getJavaTypeAsString(xmlName, xmlType, false, true));
/* 463 */       QName messageName = WSDLUtils.getWsdl11Output(wiop).getMessageName();
/* 464 */       wrvm.setWsdlMessage(new QName(messageName.getNamespaceURI(), messageName.getLocalPart(), "wsdlMsgNS"));
/* 465 */       wrvm.setWsdlMessagePartName(partName);
/* 466 */       semm.setWsdlReturnValueMapping(wrvm);
/*     */     }
/*     */ 
/* 469 */     if (bindingOperation != null)
/*     */     {
/* 471 */       constructHeaderParameters(semm, wiop, bindingOperation);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void constructJavaXmlTypeMapping(JavaWsdlMapping jwm)
/*     */   {
/* 477 */     WSDLInterface[] intfArr = this.wsdlDefinitions.getInterfaces();
/* 478 */     int len = intfArr != null ? intfArr.length : 0;
/* 479 */     for (int i = 0; i < len; i++)
/*     */     {
/* 481 */       WSDLInterface wi = intfArr[i];
/* 482 */       WSDLInterfaceOperation[] ops = wi.getOperations();
/* 483 */       int lenOps = ops.length;
/* 484 */       for (int j = 0; j < lenOps; j++)
/*     */       {
/* 486 */         WSDLInterfaceOperation op = ops[j];
/*     */         WSDLInterfaceOperationInput input;
/* 487 */         for (input : op.getInputs())
/*     */         {
/* 489 */           if (isDocStyle())
/*     */           {
/* 491 */             XSTypeDefinition xt = getXSType(input);
/*     */ 
/* 493 */             addJavaXMLTypeMap(xt, input.getElement().getLocalPart(), "", "", jwm, false);
/*     */           }
/*     */           else
/*     */           {
/* 497 */             for (WSDLRPCPart part : input.getChildParts())
/* 498 */               addJavaXMLTypeMap(getXSType(part.getType()), input.getElement().getLocalPart(), "", "", jwm, true);
/*     */           }
/*     */         }
/*     */         WSDLInterfaceOperationOutput output;
/* 502 */         for (output : op.getOutputs())
/*     */         {
/* 504 */           if (isDocStyle())
/*     */           {
/* 506 */             XSTypeDefinition xt = getXSType(output);
/*     */ 
/* 508 */             addJavaXMLTypeMap(xt, output.getElement().getLocalPart(), "", "", jwm, false);
/*     */           }
/*     */           else
/*     */           {
/* 512 */             for (WSDLRPCPart part : output.getChildParts()) {
/* 513 */               addJavaXMLTypeMap(getXSType(part.getType()), output.getElement().getLocalPart(), "", "", jwm, true);
/*     */             }
/*     */           }
/*     */         }
/* 517 */         for (WSDLInterfaceFault fault : wi.getFaults())
/*     */         {
/* 519 */           QName xmlType = fault.getXmlType();
/* 520 */           QName xmlName = fault.getElement();
/*     */ 
/* 522 */           WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
/* 523 */           JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
/* 524 */           XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 525 */           addJavaXMLTypeMap(xt, xmlName.getLocalPart(), "", "", jwm, true);
/*     */ 
/* 527 */           String exceptionType = getJavaTypeAsString(null, xmlType, false, true);
/*     */ 
/* 529 */           if (this.registeredExceptions.contains(exceptionType))
/*     */             continue;
/* 531 */           this.registeredExceptions.add(exceptionType);
/* 532 */           ExceptionMapping exceptionMapping = new ExceptionMapping(jwm);
/* 533 */           exceptionMapping.setExceptionType(exceptionType);
/* 534 */           exceptionMapping.setWsdlMessage(fault.getName());
/* 535 */           jwm.addExceptionMappings(exceptionMapping);
/*     */         }
/*     */ 
/* 539 */         WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdlDefinitions, op);
/* 540 */         if (bindingOperation == null)
/*     */           continue;
/* 542 */         constructHeaderJavaXmlTypeMapping(jwm, HeaderUtil.getSignatureHeaders(bindingOperation.getInputs()));
/* 543 */         constructHeaderJavaXmlTypeMapping(jwm, HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs()));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void constructHeaderJavaXmlTypeMapping(JavaWsdlMapping jwm, WSDLSOAPHeader[] headers)
/*     */   {
/* 552 */     for (WSDLSOAPHeader current : headers)
/*     */     {
/* 554 */       QName elementName = current.getElement();
/*     */ 
/* 556 */       JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
/* 557 */       XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
/* 558 */       XSTypeDefinition xt = xe.getTypeDefinition();
/*     */ 
/* 560 */       addJavaXMLTypeMap(xt, elementName.getLocalPart(), "", "", jwm, true);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean unwrapRequest(ServiceEndpointMethodMapping methodMapping, String messageName, String containingElement, XSTypeDefinition xt)
/*     */   {
/* 566 */     if (!(xt instanceof XSComplexTypeDefinition)) {
/* 567 */       throw new WSException("Tried to unwrap a non-complex type.");
/*     */     }
/* 569 */     List partsMappings = new ArrayList();
/*     */ 
/* 571 */     XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
/*     */ 
/* 573 */     if (wrapper.getAttributeUses().getLength() > 0) {
/* 574 */       return false;
/*     */     }
/* 576 */     boolean unwrappedElement = false;
/*     */ 
/* 578 */     XSParticle particle = wrapper.getParticle();
/* 579 */     if (particle == null)
/*     */     {
/* 581 */       return true;
/*     */     }
/*     */ 
/* 585 */     XSTerm term = particle.getTerm();
/* 586 */     if ((term instanceof XSModelGroup))
/*     */     {
/* 588 */       unwrappedElement = unwrapGroup(partsMappings, methodMapping, messageName, containingElement, (XSModelGroup)term);
/*     */     }
/*     */ 
/* 592 */     if (unwrappedElement)
/*     */     {
/* 594 */       addMethodParamPartsMappings(partsMappings, methodMapping);
/*     */ 
/* 596 */       return true;
/*     */     }
/*     */ 
/* 599 */     return false;
/*     */   }
/*     */ 
/*     */   private void addMethodParamPartsMappings(List<MethodParamPartsMapping> partsMappings, ServiceEndpointMethodMapping methodMapping)
/*     */   {
/* 604 */     for (MethodParamPartsMapping current : partsMappings)
/*     */     {
/* 606 */       methodMapping.addMethodParamPartsMapping(current);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean unwrapGroup(List<MethodParamPartsMapping> partsMappings, ServiceEndpointMethodMapping methodMapping, String messageName, String containingElement, XSModelGroup group)
/*     */   {
/* 613 */     if (group.getCompositor() != 1) {
/* 614 */       return false;
/*     */     }
/* 616 */     XSObjectList particles = group.getParticles();
/* 617 */     for (int i = 0; i < particles.getLength(); i++)
/*     */     {
/* 619 */       XSParticle particle = (XSParticle)particles.item(i);
/* 620 */       XSTerm term = particle.getTerm();
/* 621 */       if ((term instanceof XSModelGroup))
/*     */       {
/* 623 */         if (!unwrapGroup(partsMappings, methodMapping, messageName, containingElement, (XSModelGroup)term))
/* 624 */           return false;
/*     */       } else {
/* 626 */         if (!(term instanceof XSElementDeclaration))
/*     */           continue;
/* 628 */         XSElementDeclaration element = (XSElementDeclaration)term;
/* 629 */         XSTypeDefinition type = element.getTypeDefinition();
/*     */ 
/* 631 */         QName xmlName = new QName(element.getNamespace(), element.getName());
/*     */         QName xmlType;
/*     */         QName xmlType;
/* 633 */         if (type.getAnonymous())
/*     */         {
/* 635 */           xmlType = new QName(type.getNamespace(), containingElement + element.getName());
/*     */         }
/*     */         else
/*     */         {
/* 639 */           xmlType = new QName(type.getNamespace(), type.getName());
/*     */         }
/*     */ 
/* 642 */         boolean array = (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1);
/* 643 */         boolean primitive = (!element.getNillable()) && ((particle.getMinOccurs() != 0) || (particle.getMaxOccurs() != 1));
/*     */ 
/* 645 */         MethodParamPartsMapping part = getMethodParamPartsMapping(methodMapping, xmlName, xmlType, partsMappings.size(), messageName, "IN", xmlName.getLocalPart(), array, primitive);
/*     */ 
/* 647 */         partsMappings.add(part);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 652 */     return true;
/*     */   }
/*     */ 
/*     */   private void checkEssentials()
/*     */   {
/* 657 */     if (this.typeMapping == null)
/* 658 */       throw new WSException("typeMapping is null");
/*     */   }
/*     */ 
/*     */   private XSTypeDefinition getXSType(WSDLInterfaceMessageReference part)
/*     */   {
/* 664 */     WSDLInterfaceOperation op = part.getWsdlOperation();
/* 665 */     String zeroarg1 = null;
/* 666 */     String zeroarg2 = null;
/* 667 */     WSDLProperty prop1 = op.getProperty("http://www.jboss.org/jbossws/zero-args");
/* 668 */     if (prop1 != null)
/* 669 */       zeroarg1 = prop1.getValue();
/* 670 */     if ((zeroarg1 != null) && (zeroarg2 != null) && (!zeroarg1.equals(zeroarg2)))
/* 671 */       return null;
/* 672 */     if ((zeroarg1 != null) && ("true".equals(zeroarg1))) {
/* 673 */       return null;
/*     */     }
/* 675 */     QName xmlType = part.getXMLType();
/*     */ 
/* 677 */     WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
/* 678 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
/* 679 */     return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   private XSTypeDefinition getXSType(QName xmlType)
/*     */   {
/* 684 */     WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
/* 685 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(types);
/* 686 */     return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   private void addJavaXMLTypeMap(XSTypeDefinition xt, String name, String containingElement, String containingType, JavaWsdlMapping jwm, boolean skipWrapperArray)
/*     */   {
/* 691 */     JavaXmlTypeMapping jxtm = null;
/*     */ 
/* 693 */     if ((xt instanceof XSComplexTypeDefinition))
/*     */     {
/* 696 */       XSModelGroup xm = null;
/* 697 */       XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xt;
/* 698 */       if (xc.getContentType() != 0)
/*     */       {
/* 700 */         XSParticle xp = xc.getParticle();
/* 701 */         if (xp != null)
/*     */         {
/* 703 */           XSTerm xterm = xp.getTerm();
/* 704 */           if ((xterm instanceof XSModelGroup)) {
/* 705 */             xm = (XSModelGroup)xterm;
/*     */           }
/*     */         }
/*     */       }
/* 709 */       if (((skipWrapperArray) && (SchemaUtils.isWrapperArrayType(xt)) ? 1 : 0) == 0)
/*     */       {
/* 711 */         jxtm = new JavaXmlTypeMapping(jwm);
/*     */ 
/* 713 */         String localName = xt.getName();
/*     */         String javaType;
/* 716 */         if (localName == null)
/*     */         {
/* 718 */           String javaType = getJavaTypeAsString(null, new QName(containingElement + name), false, true);
/* 719 */           StringBuilder temp = new StringBuilder();
/* 720 */           if ((containingType != null) && (containingType.length() > 0))
/* 721 */             temp.append(">").append(containingType);
/* 722 */           temp.append(">").append(name);
/* 723 */           localName = temp.toString();
/* 724 */           jxtm.setAnonymousTypeQName(new QName(xt.getNamespace(), localName, "typeNS"));
/*     */         }
/*     */         else
/*     */         {
/* 728 */           javaType = getJavaTypeAsString(null, new QName(localName), false, true);
/* 729 */           jxtm.setRootTypeQName(new QName(xt.getNamespace(), xt.getName(), "typeNS"));
/*     */         }
/*     */ 
/* 732 */         if (this.typeNamespace == null)
/*     */         {
/* 734 */           this.typeNamespace = xt.getNamespace();
/*     */         }
/*     */ 
/* 737 */         if (this.registeredTypes.contains(javaType)) {
/* 738 */           return;
/*     */         }
/* 740 */         jxtm.setJavaType(javaType);
/* 741 */         jxtm.setQNameScope("complexType");
/*     */ 
/* 743 */         this.registeredTypes.add(javaType);
/* 744 */         jwm.addJavaXmlTypeMappings(jxtm);
/*     */ 
/* 747 */         if (xm != null)
/*     */         {
/* 749 */           addVariableMappingMap(xm, jxtm, javaType);
/*     */         }
/*     */ 
/* 753 */         XSSimpleTypeDefinition simple = xc.getSimpleType();
/* 754 */         if (simple != null)
/*     */         {
/* 756 */           addJavaXMLTypeMap(simple, xc.getName(), "", "", jwm, skipWrapperArray);
/*     */         }
/*     */ 
/* 760 */         XSObjectList attributeUses = xc.getAttributeUses();
/* 761 */         if (attributeUses != null) {
/* 762 */           addAttributeMappings(attributeUses, jxtm);
/*     */         }
/*     */       }
/* 765 */       if (xm != null)
/* 766 */         addGroup(xm, name, xc.getName(), jwm);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addVariableMappingMap(XSModelGroup xm, JavaXmlTypeMapping jxtm, String javaType)
/*     */   {
/* 774 */     XSObjectList xo = xm.getParticles();
/* 775 */     int len = xo != null ? xo.getLength() : 0;
/* 776 */     for (int i = 0; i < len; i++)
/*     */     {
/* 778 */       XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
/* 779 */       if ((xsterm instanceof XSModelGroup)) {
/* 780 */         addVariableMappingMap((XSModelGroup)xsterm, jxtm, javaType); } else {
/* 781 */         if (!(xsterm instanceof XSElementDeclaration))
/*     */           continue;
/* 783 */         XSElementDeclaration xe = (XSElementDeclaration)xsterm;
/* 784 */         VariableMapping vm = new VariableMapping(jxtm);
/* 785 */         String name = xe.getName();
/*     */ 
/* 787 */         vm.setJavaVariableName(ToolsUtils.convertInvalidCharacters(Introspector.decapitalize(name)));
/* 788 */         vm.setXmlElementName(name);
/* 789 */         jxtm.addVariableMapping(vm);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addAttributeMappings(XSObjectList attributes, JavaXmlTypeMapping jxtm)
/*     */   {
/* 796 */     for (int i = 0; i < attributes.getLength(); i++)
/*     */     {
/* 798 */       XSAttributeUse obj = (XSAttributeUse)attributes.item(i);
/* 799 */       XSAttributeDeclaration att = obj.getAttrDeclaration();
/* 800 */       XSSimpleTypeDefinition simple = att.getTypeDefinition();
/* 801 */       addJavaXMLTypeMap(simple, "none", "", "", jxtm.getJavaWsdlMapping(), true);
/* 802 */       VariableMapping vm = new VariableMapping(jxtm);
/* 803 */       String name = att.getName();
/* 804 */       vm.setXmlAttributeName(name);
/*     */ 
/* 806 */       vm.setJavaVariableName(ToolsUtils.convertInvalidCharacters(Introspector.decapitalize(name)));
/* 807 */       jxtm.addVariableMapping(vm);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addGroup(XSModelGroup xm, String containingElement, String containingType, JavaWsdlMapping jwm)
/*     */   {
/* 813 */     XSObjectList xo = xm.getParticles();
/* 814 */     int len = xo != null ? xo.getLength() : 0;
/* 815 */     for (int i = 0; i < len; i++)
/*     */     {
/* 817 */       XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
/* 818 */       if ((xsterm instanceof XSModelGroup))
/*     */       {
/* 820 */         addGroup((XSModelGroup)xsterm, containingElement, containingType, jwm);
/*     */       } else {
/* 822 */         if (!(xsterm instanceof XSElementDeclaration))
/*     */           continue;
/* 824 */         XSElementDeclaration xe = (XSElementDeclaration)xsterm;
/* 825 */         XSTypeDefinition typeDefinition = xe.getTypeDefinition();
/* 826 */         String tempContainingElement = "";
/* 827 */         String tempContainingType = "";
/* 828 */         if (xe.getScope() != 1)
/*     */         {
/* 830 */           tempContainingElement = containingElement;
/* 831 */           tempContainingType = containingType;
/*     */         }
/*     */ 
/* 834 */         addJavaXMLTypeMap(typeDefinition, xe.getName(), tempContainingElement, tempContainingType, jwm, !isWrapped());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getJavaTypeAsString(QName xmlName, QName xmlType, boolean array, boolean primitive)
/*     */   {
/* 841 */     String jtype = null;
/*     */ 
/* 843 */     String arraySuffix = array ? "[]" : "";
/* 844 */     if (!isDocStyle())
/*     */     {
/* 846 */       JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdlDefinitions.getWsdlTypes());
/* 847 */       XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 849 */       XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(xt);
/* 850 */       StringBuilder builder = new StringBuilder();
/*     */ 
/* 852 */       while (unwrapped != null)
/*     */       {
/* 854 */         xt = unwrapped.getTypeDefinition();
/* 855 */         primitive = !unwrapped.getNillable();
/* 856 */         builder.append("[]");
/* 857 */         unwrapped = SchemaUtils.unwrapArrayType(xt);
/*     */       }
/* 859 */       if (builder.length() > 0)
/*     */       {
/* 861 */         xmlType = new QName(xt.getNamespace(), xt.getName());
/* 862 */         arraySuffix = builder.toString();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 867 */     Class javaType = this.typeMapping.getJavaType(xmlType, primitive);
/*     */ 
/* 872 */     if ((xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) && ("anyType".equals(xmlType.getLocalPart())) && (javaType == Element.class))
/* 873 */       javaType = SOAPElement.class;
/* 874 */     javaType = makeCustomDecisions(javaType, xmlType);
/*     */ 
/* 876 */     if (javaType == null)
/*     */     {
/* 878 */       log.debug("Typemapping lookup failed for " + xmlName);
/* 879 */       log.debug("Falling back to identifier generation");
/* 880 */       String className = xmlType.getLocalPart();
/* 881 */       if (className.charAt(0) == '>')
/* 882 */         className = className.substring(1);
/* 883 */       className = ToolsUtils.convertInvalidCharacters(className);
/* 884 */       jtype = this.packageName + "." + this.utils.firstLetterUpperCase(className);
/*     */     }
/* 889 */     else if (javaType.isArray())
/*     */     {
/* 891 */       jtype = JavaUtils.getSourceName(javaType);
/*     */     } else {
/* 893 */       jtype = javaType.getName();
/*     */     }
/*     */ 
/* 896 */     return jtype + arraySuffix;
/*     */   }
/*     */ 
/*     */   private boolean isDocStyle()
/*     */   {
/* 901 */     return "Document/Literal".equals(this.wsdlStyle);
/*     */   }
/*     */ 
/*     */   private Class makeCustomDecisions(Class javaType, QName xmlType)
/*     */   {
/* 913 */     if ((javaType != null) && (xmlType != null))
/*     */     {
/* 915 */       if (([Ljava.lang.Byte.class == javaType) && ("http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI())) && ("base64Binary".equals(xmlType.getLocalPart())))
/* 916 */         javaType = [B.class;
/*     */     }
/* 918 */     return javaType;
/*     */   }
/*     */ 
/*     */   private boolean isWrapped()
/*     */   {
/* 923 */     return ("wrapped".equals(this.parameterStyle)) && ("Document/Literal".equals(this.wsdlStyle));
/*     */   }
/*     */ 
/*     */   private MethodParamPartsMapping getMethodParamPartsMapping(ServiceEndpointMethodMapping semm, QName xmlName, QName xmlType, int paramPosition, String wsdlMessageName, String paramMode, String wsdlMessagePartName, boolean array, boolean primitive)
/*     */   {
/* 929 */     String targetNS = this.wsdlDefinitions.getTargetNamespace();
/* 930 */     MethodParamPartsMapping mppm = new MethodParamPartsMapping(semm);
/* 931 */     mppm.setParamPosition(paramPosition);
/* 932 */     String javaType = getJavaTypeAsString(xmlName, xmlType, array, primitive);
/* 933 */     mppm.setParamType(javaType);
/*     */ 
/* 936 */     WsdlMessageMapping wmm = new WsdlMessageMapping(mppm);
/* 937 */     wmm.setParameterMode(paramMode);
/* 938 */     String wsdlNS = "wsdlMsgNS";
/* 939 */     wmm.setWsdlMessage(new QName(targetNS, wsdlMessageName, wsdlNS));
/* 940 */     wmm.setWsdlMessagePartName(wsdlMessagePartName);
/* 941 */     mppm.setWsdlMessageMapping(wmm);
/* 942 */     return mppm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.helpers.MappingFileGeneratorHelper
 * JD-Core Version:    0.6.0
 */