/*     */ package org.jboss.ws.tools.client;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.tools.interfaces.ServiceCreatorIntf;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ServiceCreator
/*     */   implements ServiceCreatorIntf
/*     */ {
/*  58 */   protected String packageName = null;
/*     */ 
/*  63 */   protected File dirLocation = null;
/*     */ 
/*  68 */   protected WSDLDefinitions wsdl = null;
/*     */ 
/*  71 */   private WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*     */   public ServiceCreator()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceCreator(WSDLDefinitions wsdl, String packageName)
/*     */   {
/*  88 */     this.wsdl = wsdl;
/*  89 */     this.packageName = packageName;
/*     */   }
/*     */ 
/*     */   public ServiceCreator(WSDLDefinitions wsdl, String packageName, File location)
/*     */   {
/* 102 */     this(wsdl, packageName);
/* 103 */     this.dirLocation = location;
/*     */   }
/*     */ 
/*     */   public File getDirLocation()
/*     */   {
/* 111 */     return this.dirLocation;
/*     */   }
/*     */ 
/*     */   public void setDirLocation(File dirLocation)
/*     */   {
/* 119 */     this.dirLocation = dirLocation;
/*     */   }
/*     */ 
/*     */   public String getPackageName()
/*     */   {
/* 127 */     return this.packageName;
/*     */   }
/*     */ 
/*     */   public void setPackageName(String packageName)
/*     */   {
/* 135 */     this.packageName = packageName;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdl()
/*     */   {
/* 144 */     return this.wsdl;
/*     */   }
/*     */ 
/*     */   public void setWsdl(WSDLDefinitions wsdl)
/*     */   {
/* 153 */     this.wsdl = wsdl;
/*     */   }
/*     */ 
/*     */   public void createServiceDescriptor()
/*     */     throws IOException
/*     */   {
/* 163 */     if (this.packageName == null)
/* 164 */       throw new WSException("package name is null");
/* 165 */     if (this.dirLocation == null)
/* 166 */       throw new WSException("dir location  is null");
/* 167 */     if (this.wsdl == null) {
/* 168 */       throw new WSException("wsdl definitions is null");
/*     */     }
/* 170 */     WSDLService[] services = this.wsdl.getServices();
/*     */ 
/* 172 */     int len = services != null ? services.length : 0;
/* 173 */     for (int i = 0; i < len; i++)
/*     */     {
/* 175 */       generateServiceFile(services[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void generateHeader(StringBuilder buf)
/*     */   {
/* 182 */     buf.append("/*  " + newLine(1));
/* 183 */     buf.append("* JBoss, the OpenSource EJB server" + newLine(1));
/* 184 */     buf.append("* Distributable under LGPL license. See terms of license at gnu.org." + newLine(1));
/* 185 */     buf.append("*/" + newLine(2));
/* 186 */     buf.append("//Auto Generated by jbossws - Please do not edit!!!");
/* 187 */     buf.append(newLine(2));
/*     */   }
/*     */ 
/*     */   private void generatePackageNameAndImport(StringBuilder buf)
/*     */   {
/* 192 */     buf.append("package " + this.packageName + ";" + newLine(3));
/* 193 */     buf.append("import javax.xml.rpc.*; " + newLine(3));
/*     */   }
/*     */ 
/*     */   private String getReturnType(WSDLBinding wbind)
/*     */   {
/* 198 */     String portType = wbind.getInterface().getName().getLocalPart();
/* 199 */     portType = this.utils.chopPortType(portType);
/*     */ 
/* 202 */     if (this.wsdl.getService(portType) != null)
/* 203 */       portType = portType + "_PortType";
/* 204 */     return this.packageName + "." + JavaUtils.capitalize(portType);
/*     */   }
/*     */ 
/*     */   private void generateServiceFile(WSDLService wsdlService) throws IOException
/*     */   {
/* 209 */     String serviceName = wsdlService.getName().getLocalPart();
/* 210 */     if (!serviceName.endsWith("Service")) {
/* 211 */       serviceName = serviceName + "Service";
/*     */     }
/*     */ 
/* 214 */     if (this.wsdl.getInterface(new QName(this.wsdl.getTargetNamespace(), serviceName)) != null) {
/* 215 */       serviceName = new StringBuilder(serviceName).insert(serviceName.lastIndexOf("Service"), '_').toString();
/*     */     }
/* 217 */     serviceName = JavaUtils.capitalize(serviceName);
/*     */ 
/* 219 */     StringBuilder buf = new StringBuilder();
/* 220 */     generateHeader(buf);
/* 221 */     generatePackageNameAndImport(buf);
/*     */ 
/* 223 */     buf.append("public interface  " + serviceName + " extends  javax.xml.rpc.Service" + newLine(1));
/* 224 */     buf.append("{" + newLine(2));
/*     */ 
/* 226 */     WSDLEndpoint[] endpts = wsdlService.getEndpoints();
/* 227 */     int len = endpts != null ? endpts.length : 0;
/*     */ 
/* 229 */     for (int i = 0; i < len; i++) {
/* 230 */       buf.append(generateServiceMethodForWSDLEndpoint(endpts[i])).append(newLine(1));
/*     */     }
/* 232 */     buf.append("}" + newLine(1));
/*     */ 
/* 234 */     File loc = this.utils.createPackage(this.dirLocation.getAbsolutePath(), this.packageName);
/* 235 */     File sei = this.utils.createPhysicalFile(loc, serviceName);
/* 236 */     FileWriter writer = new FileWriter(sei);
/* 237 */     writer.write(buf.toString());
/* 238 */     writer.flush();
/* 239 */     writer.close();
/*     */   }
/*     */ 
/*     */   private String generateServiceMethodForWSDLEndpoint(WSDLEndpoint endpt)
/*     */   {
/* 244 */     StringBuilder buf = new StringBuilder("     public ");
/* 245 */     QName bindName = endpt.getBinding();
/* 246 */     WSDLBinding wbind = this.wsdl.getBinding(bindName);
/*     */ 
/* 248 */     buf.append(getReturnType(wbind)).append(" get");
/* 249 */     buf.append(endpt.getName().getLocalPart()).append("()").append(" throws ServiceException;").append(newLine(1));
/* 250 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private String newLine(int times)
/*     */   {
/* 255 */     String newline = "\n";
/* 256 */     StringBuilder buf = new StringBuilder(newline);
/* 257 */     for (int i = 0; i < times - 1; i++)
/* 258 */       buf.append(newline);
/* 259 */     return buf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.client.ServiceCreator
 * JD-Core Version:    0.6.0
 */