/*    */ package org.jboss.ws.tools.ant;
/*    */ 
/*    */ import org.apache.tools.ant.BuildException;
/*    */ import org.apache.tools.ant.taskdefs.MatchingTask;
/*    */ import org.apache.tools.ant.types.Path;
/*    */ import org.apache.tools.ant.types.Reference;
/*    */ import org.jboss.ws.tools.WSTools;
/*    */ 
/*    */ public class wstools extends MatchingTask
/*    */ {
/* 36 */   protected Path compileClasspath = null;
/* 37 */   private boolean verbose = false;
/*    */ 
/* 39 */   private String dest = null;
/*    */ 
/* 41 */   private String config = null;
/*    */ 
/*    */   public Path createClasspath()
/*    */   {
/* 48 */     if (this.compileClasspath == null)
/*    */     {
/* 50 */       this.compileClasspath = new Path(this.project);
/*    */     }
/* 52 */     return this.compileClasspath.createPath();
/*    */   }
/*    */ 
/*    */   public void setClasspathRef(Reference r)
/*    */   {
/* 60 */     createClasspath().setRefid(r);
/*    */   }
/*    */ 
/*    */   public String getConfig()
/*    */   {
/* 65 */     return this.config;
/*    */   }
/*    */ 
/*    */   public void setConfig(String config)
/*    */   {
/* 70 */     this.config = config;
/*    */   }
/*    */ 
/*    */   public String getDest()
/*    */   {
/* 75 */     return this.dest;
/*    */   }
/*    */ 
/*    */   public void setDest(String dest)
/*    */   {
/* 80 */     this.dest = dest;
/*    */   }
/*    */ 
/*    */   public boolean isVerbose()
/*    */   {
/* 85 */     return this.verbose;
/*    */   }
/*    */ 
/*    */   public void setVerbose(boolean verbose)
/*    */   {
/* 90 */     this.verbose = verbose;
/*    */   }
/*    */ 
/*    */   public void execute() throws BuildException
/*    */   {
/* 95 */     ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
/* 96 */     Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
/*    */     try
/*    */     {
/* 99 */       String[] args = { "-dest", this.dest, "-config", this.config };
/* 100 */       WSTools tools = new WSTools();
/* 101 */       tools.generate(args);
/*    */     }
/*    */     catch (Exception ex)
/*    */     {
/* 105 */       if ((ex instanceof BuildException))
/*    */       {
/* 107 */         throw ((BuildException)ex);
/*    */       }
/*    */ 
/* 111 */       throw new BuildException("Error running jbossws: ", ex, getLocation());
/*    */     }
/*    */     finally
/*    */     {
/* 116 */       Thread.currentThread().setContextClassLoader(prevCL);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.ant.wstools
 * JD-Core Version:    0.6.0
 */