/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSLoader;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.apache.xerces.xs.XSNamedMap;
/*     */ import org.apache.xerces.xs.XSObject;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.interfaces.XSDToJavaIntf;
/*     */ 
/*     */ public class XSDToJava
/*     */   implements XSDToJavaIntf
/*     */ {
/*  53 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*  58 */   protected XSDTypeToJava xsdJava = new XSDTypeToJava();
/*     */ 
/*  60 */   private LiteralTypeMapping typeMapping = null;
/*     */ 
/*     */   public void generateJavaSource(String schemaFile, File dirloc, String packageName, boolean createPackageDir)
/*     */     throws IOException
/*     */   {
/*  70 */     XSLoader xsloader = SchemaUtils.getInstance().getXSLoader();
/*  71 */     XSModel xsmodel = xsloader.loadURI(schemaFile);
/*     */ 
/*  73 */     if (createPackageDir) dirloc = this.utils.createPackage(dirloc.getAbsolutePath(), packageName);
/*  74 */     generateJavaSource(xsmodel, dirloc, packageName);
/*     */   }
/*     */ 
/*     */   public void generateJavaSource(XSModel xsmodel, File dirloc, String packageName, boolean createPackageDir)
/*     */     throws IOException
/*     */   {
/*  85 */     if (createPackageDir) dirloc = this.utils.createPackage(dirloc.getAbsolutePath(), packageName);
/*  86 */     generateJavaSource(xsmodel, dirloc, packageName);
/*     */   }
/*     */ 
/*     */   public void generateJavaSource(XSModel xsmodel, File dirloc, String packageName)
/*     */     throws IOException
/*     */   {
/*  96 */     XSNamedMap xsnamedmap = xsmodel.getComponents(3);
/*  97 */     int len = xsnamedmap != null ? xsnamedmap.getLength() : 0;
/*  98 */     for (int i = 0; i < len; i++)
/*     */     {
/* 100 */       XSObject type = xsnamedmap.item(i);
/* 101 */       if ((type instanceof XSComplexTypeDefinition))
/*     */       {
/* 103 */         XSComplexTypeDefinition ctype = (XSComplexTypeDefinition)type;
/*     */ 
/* 105 */         String nsuri = type.getNamespace();
/* 106 */         String tname = type.getName();
/* 107 */         if ((!"http://www.w3.org/2001/XMLSchema".equals(nsuri)) || (!"anyType".equals(tname))) {
/* 108 */           checkXSDTypeToJava();
/* 109 */           this.xsdJava.createJavaFile(ctype, dirloc, packageName, xsmodel);
/*     */         }
/*     */       } else {
/* 111 */         if (!(type instanceof XSSimpleTypeDefinition))
/*     */           continue;
/* 113 */         XSSimpleTypeDefinition stype = (XSSimpleTypeDefinition)type;
/*     */ 
/* 115 */         String nsuri = type.getNamespace();
/* 116 */         String tname = type.getName();
/* 117 */         if ((!"http://www.w3.org/2001/XMLSchema".equals(nsuri)) || (!"anyType".equals(tname))) {
/* 118 */           checkXSDTypeToJava();
/* 119 */           this.xsdJava.createJavaFile(stype, dirloc, packageName, xsmodel);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 124 */     xsnamedmap = xsmodel.getComponents(2);
/* 125 */     len = xsnamedmap != null ? xsnamedmap.getLength() : 0;
/* 126 */     for (int i = 0; i < len; i++)
/*     */     {
/* 128 */       XSElementDeclaration elm = (XSElementDeclaration)xsnamedmap.item(i);
/* 129 */       String elmname = elm.getName();
/* 130 */       XSTypeDefinition elmtype = elm.getTypeDefinition();
/* 131 */       if ((elmtype == null) || (!(elmtype instanceof XSComplexTypeDefinition)))
/*     */         continue;
/* 133 */       XSComplexTypeDefinition ctype = (XSComplexTypeDefinition)elmtype;
/* 134 */       String nsuri = elmtype.getNamespace();
/* 135 */       String tname = elmtype.getName();
/* 136 */       if (tname != null)
/*     */         continue;
/* 138 */       createJavaFile(ctype, dirloc, packageName, xsmodel, elmname);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(LiteralTypeMapping tm)
/*     */   {
/* 150 */     this.typeMapping = tm;
/*     */   }
/*     */ 
/*     */   private void createJavaFile(XSComplexTypeDefinition type, File loc, String pkgname, XSModel schema, String outerElementName)
/*     */     throws IOException
/*     */   {
/* 157 */     String str = "Method should be used for anon complex types only";
/* 158 */     if (type.getName() != null)
/* 159 */       throw new IllegalArgumentException(str);
/* 160 */     checkXSDTypeToJava();
/* 161 */     this.xsdJava.createJavaFile(type, outerElementName, loc, pkgname, schema, false);
/*     */   }
/*     */ 
/*     */   private void checkXSDTypeToJava()
/*     */   {
/* 166 */     if (this.xsdJava == null)
/* 167 */       this.xsdJava = new XSDTypeToJava();
/* 168 */     this.xsdJava.setTypeMapping(this.typeMapping);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.XSDToJava
 * JD-Core Version:    0.6.0
 */