/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.tools.config.ToolsSchemaConfigReader;
/*     */ import org.jboss.ws.tools.helpers.ToolsHelper;
/*     */ 
/*     */ public class WSTools
/*     */ {
/*  46 */   private static Logger log = Logger.getLogger(WSTools.class);
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws IOException
/*     */   {
/*  57 */     WSTools tools = new WSTools();
/*  58 */     tools.generate(args);
/*     */   }
/*     */ 
/*     */   public boolean generate(String configLocation, String outputDir)
/*     */     throws IOException
/*     */   {
/*  66 */     ToolsSchemaConfigReader configReader = new ToolsSchemaConfigReader();
/*  67 */     Configuration config = configReader.readConfig(configLocation);
/*     */ 
/*  69 */     return process(config, outputDir);
/*     */   }
/*     */ 
/*     */   public boolean generate(String[] args)
/*     */     throws IOException
/*     */   {
/*  77 */     String configLocation = null;
/*  78 */     String outputDir = null;
/*  79 */     if (args.length == 0)
/*     */     {
/*  81 */       usage();
/*     */     }
/*     */ 
/*  84 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  86 */       String arg = args[i];
/*     */ 
/*  88 */       if ("-config".equals(arg))
/*     */       {
/*  90 */         configLocation = args[(i + 1)];
/*  91 */         i++;
/*     */       }
/*  94 */       else if ("-dest".equals(arg))
/*     */       {
/*  96 */         outputDir = args[(i + 1)];
/*  97 */         i++;
/*     */       }
/* 100 */       else if (("-classpath".equals(arg)) || ("-cp".equals(arg)))
/*     */       {
/* 102 */         StringTokenizer st = new StringTokenizer(args[(i + 1)], File.pathSeparator);
/*     */ 
/* 104 */         int tokens = st.countTokens();
/* 105 */         URL[] urls = new URL[tokens];
/* 106 */         for (int j = 0; j < tokens; j++)
/*     */         {
/* 108 */           String token = st.nextToken();
/* 109 */           urls[j] = new File(token).toURL();
/*     */         }
/*     */ 
/* 112 */         ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 113 */         URLClassLoader urlLoader = new URLClassLoader(urls, ctxLoader);
/* 114 */         Thread.currentThread().setContextClassLoader(urlLoader);
/* 115 */         i++;
/*     */       }
/*     */       else
/*     */       {
/* 119 */         usage();
/*     */       }
/*     */     }
/*     */ 
/* 123 */     return generate(configLocation, outputDir);
/*     */   }
/*     */ 
/*     */   private void usage()
/*     */   {
/* 128 */     System.out.println("Usage: wstools (-classpath|-cp) <classpath> -config <config> [-dest <destination path>]");
/* 129 */     System.exit(1);
/*     */   }
/*     */ 
/*     */   private boolean process(Configuration config, String outputDir) throws IOException
/*     */   {
/* 134 */     if (config == null) {
/* 135 */       throw new IllegalArgumentException("Configuration is null");
/*     */     }
/* 137 */     if (outputDir == null) {
/* 138 */       outputDir = ".";
/*     */     }
/* 140 */     ToolsHelper helper = new ToolsHelper();
/* 141 */     if (config.getJavaToWSDLConfig(false) != null)
/*     */     {
/* 143 */       helper.handleJavaToWSDLGeneration(config, outputDir);
/*     */     }
/* 145 */     else if (config.getWSDLToJavaConfig(false) != null)
/*     */     {
/* 147 */       helper.handleWSDLToJavaGeneration(config, outputDir);
/*     */     }
/*     */     else
/*     */     {
/* 151 */       throw new WSException("Nothing done, Configuration source must have JavaToWSDL or WSDLToJava specified");
/*     */     }
/* 153 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.WSTools
 * JD-Core Version:    0.6.0
 */