/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.net.URI;
/*     */ import java.rmi.Remote;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.holders.ByteArrayHolder;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleSerializerFactory;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ToolsUtils
/*     */ {
/*  65 */   private static LiteralTypeMapping mapping = new LiteralTypeMapping();
/*     */ 
/*     */   private ToolsUtils()
/*     */   {
/*  70 */     throw new WSException("Cannot instantiate ToolsUtils.");
/*     */   }
/*     */ 
/*     */   public static void checkParameterType(Class paramType)
/*     */   {
/*  80 */     if (Remote.class.isAssignableFrom(paramType))
/*  81 */       throw new IllegalArgumentException("JAXWS-2.0 Assertion::Method param shouldn't extend Remote");
/*     */   }
/*     */ 
/*     */   public static String firstLetterUpperCase(String fname)
/*     */   {
/*  91 */     if ((fname == "") || (fname == null)) {
/*  92 */       throw new WSException("String passed is null");
/*     */     }
/*  94 */     if (Character.isLowerCase(fname.charAt(0)))
/*     */     {
/*  96 */       char[] chars = fname.toCharArray();
/*  97 */       char f = Character.toUpperCase(chars[0]);
/*  98 */       chars[0] = f;
/*  99 */       fname = new String(chars);
/*     */     }
/* 101 */     return fname;
/*     */   }
/*     */ 
/*     */   public static String firstLetterLowerCase(String fname)
/*     */   {
/* 111 */     if ((fname == "") || (fname == null)) {
/* 112 */       throw new WSException("String passed is null");
/*     */     }
/* 114 */     if (Character.isUpperCase(fname.charAt(0)))
/*     */     {
/* 116 */       char[] chars = fname.toCharArray();
/* 117 */       char f = Character.toLowerCase(chars[0]);
/* 118 */       chars[0] = f;
/* 119 */       fname = new String(chars);
/*     */     }
/* 121 */     return fname;
/*     */   }
/*     */ 
/*     */   public static String getJavaIdentifier(String xmlName)
/*     */   {
/* 133 */     if ((xmlName == null) || (xmlName == ""))
/* 134 */       throw new IllegalArgumentException("xmlName is null");
/* 135 */     xmlName = xmlName.trim();
/*     */ 
/* 138 */     xmlName = trimPunctuationMarks(xmlName);
/*     */ 
/* 140 */     if (xmlName == null) {
/* 141 */       throw new WSException("xmlName has become null");
/*     */     }
/*     */ 
/* 144 */     int lenStr = xmlName.length();
/* 145 */     char[] mainArr = new char[lenStr];
/* 146 */     int j = 0;
/* 147 */     for (int i = 0; i < lenStr; i++)
/*     */     {
/* 149 */       char ch = xmlName.charAt(i);
/* 150 */       if (!Character.isJavaIdentifierPart(ch))
/*     */         continue;
/* 152 */       mainArr[j] = ch;
/* 153 */       j++;
/*     */     }
/*     */ 
/* 158 */     char[] secArr = new char[j];
/* 159 */     for (int x = 0; x < j; x++)
/*     */     {
/* 161 */       secArr[x] = mainArr[x];
/*     */     }
/*     */ 
/* 164 */     return new String(secArr);
/*     */   }
/*     */ 
/*     */   public static String getJavaMethodName(String xmlName, boolean setter)
/*     */   {
/* 175 */     xmlName = getJavaIdentifier(xmlName);
/* 176 */     xmlName = firstLetterUpperCase(xmlName);
/* 177 */     String lcase = xmlName.toLowerCase();
/* 178 */     if ((setter) && (!lcase.startsWith("set")))
/*     */     {
/* 180 */       xmlName = "set" + xmlName;
/*     */     }
/* 183 */     else if ((!setter) && (!lcase.startsWith("get")))
/*     */     {
/* 185 */       xmlName = "get" + xmlName;
/*     */     }
/* 187 */     return firstLetterLowerCase(xmlName);
/*     */   }
/*     */ 
/*     */   public static String getValidClassName(String xmlName)
/*     */   {
/* 198 */     xmlName = getJavaIdentifier(xmlName);
/*     */ 
/* 200 */     return firstLetterUpperCase(xmlName);
/*     */   }
/*     */ 
/*     */   public static QName getXMLType(Class javaClass, String ns)
/*     */   {
/* 212 */     WSDLUtils utils = WSDLUtils.getInstance();
/* 213 */     QName xmlType = null;
/* 214 */     if (Void.TYPE == javaClass) {
/* 215 */       return null;
/*     */     }
/*     */ 
/* 222 */     if (ByteArrayHolder.class == javaClass)
/*     */     {
/* 224 */       return Constants.TYPE_LITERAL_BASE64BINARY;
/*     */     }
/*     */ 
/* 227 */     if (Holder.class.isAssignableFrom(javaClass))
/* 228 */       javaClass = utils.getJavaTypeForHolder(javaClass);
/* 229 */     xmlType = SchemaUtils.getInstance().getToolsOverrideInTypeMapping(javaClass);
/* 230 */     if (xmlType != null) {
/* 231 */       return xmlType;
/*     */     }
/*     */ 
/* 235 */     if ((javaClass != [Ljava.lang.Byte.class) && (javaClass != [Ljava.lang.String.class))
/*     */     {
/* 237 */       xmlType = mapping.getXMLType(javaClass, false);
/* 238 */       if (xmlType != null) {
/* 239 */         return xmlType;
/*     */       }
/*     */     }
/* 242 */     String typeName = WSDLUtils.getJustClassName(javaClass);
/* 243 */     if (javaClass.isArray())
/*     */     {
/* 245 */       int dim = utils.getArrayDimension(javaClass);
/* 246 */       Class cls = javaClass;
/* 247 */       while (cls.isArray())
/*     */       {
/* 249 */         cls = cls.getComponentType();
/*     */       }
/* 251 */       WSDLUtils.getInstance(); typeName = WSDLUtils.getJustClassName(cls);
/* 252 */       while (dim-- > 0) {
/* 253 */         typeName = typeName + ".Array";
/*     */       }
/*     */     }
/* 256 */     return new QName(ns, typeName);
/*     */   }
/*     */ 
/*     */   public static QName getXMLTypeForAttachmentType(String mimetype)
/*     */   {
/* 274 */     return Constants.TYPE_LITERAL_HEXBINARY;
/*     */   }
/*     */ 
/*     */   public static boolean isPunctuation(char c)
/*     */   {
/* 285 */     boolean ret = true;
/*     */ 
/* 287 */     if (Character.isDigit(c)) ret = false;
/* 289 */     else if (Character.isLetter(c)) ret = false;
/* 291 */     else if (Character.isISOControl(c)) ret = false;
/* 293 */     else if (Character.isWhitespace(c)) ret = false;
/* 294 */     return ret;
/*     */   }
/*     */ 
/*     */   public static boolean isJaxrpcValueType(Class cls)
/*     */   {
/* 306 */     boolean result = true;
/* 307 */     if (isJaxrpcRegularType(cls))
/* 308 */       return false;
/* 309 */     boolean defaultCTR = false;
/*     */ 
/* 312 */     Constructor[] cons = cls.getDeclaredConstructors();
/* 313 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/* 315 */       Class[] paramTypes = cons[i].getParameterTypes();
/* 316 */       if ((paramTypes != null) && (paramTypes.length != 0))
/*     */         continue;
/* 318 */       defaultCTR = true;
/* 319 */       break;
/*     */     }
/*     */ 
/* 322 */     if (!defaultCTR) {
/* 323 */       return false;
/*     */     }
/*     */ 
/* 326 */     if (Remote.class.isAssignableFrom(cls)) {
/* 327 */       return false;
/*     */     }
/*     */ 
/* 330 */     Field[] fieldArr = cls.getDeclaredFields();
/* 331 */     int length = Array.getLength(fieldArr);
/* 332 */     for (int i = 0; i < length; i++)
/*     */     {
/* 334 */       if (!isJaxrpcPermittedType(fieldArr[i].getType()))
/* 335 */         return false;
/*     */     }
/* 337 */     return result;
/*     */   }
/*     */ 
/*     */   public static boolean isJavaBean(Class cls)
/*     */   {
/* 350 */     boolean result = false;
/* 351 */     if (isJaxrpcRegularType(cls))
/* 352 */       return false;
/*     */     try
/*     */     {
/* 355 */       BeanInfo bi = Introspector.getBeanInfo(cls);
/* 356 */       PropertyDescriptor[] pds = bi.getPropertyDescriptors();
/* 357 */       if ((pds != null) && (pds.length > 0))
/* 358 */         result = true;
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/*     */     }
/* 363 */     return result;
/*     */   }
/*     */ 
/*     */   public static int getNumberOfParticles(Class javaBean)
/*     */   {
/* 368 */     if (!isJavaBean(javaBean)) {
/* 369 */       throw new IllegalArgumentException("Illegal JavaBean argument");
/*     */     }
/*     */ 
/* 372 */     Field[] pubFields = javaBean.getFields();
/* 373 */     int pub = pubFields != null ? pubFields.length : 0;
/*     */ 
/* 375 */     int props = 0;
/*     */     try
/*     */     {
/* 379 */       BeanInfo bi = Introspector.getBeanInfo(javaBean);
/* 380 */       PropertyDescriptor[] pds = bi.getPropertyDescriptors();
/* 381 */       props = pds != null ? Array.getLength(pds) : 0;
/* 382 */       int len = 0;
/* 383 */       for (int i = 0; i < props; i++)
/*     */       {
/* 385 */         PropertyDescriptor pd = pds[i];
/* 386 */         Method readMethod = pd.getReadMethod();
/* 387 */         if ("getClass".equals(readMethod.getName()))
/*     */           continue;
/* 389 */         len++;
/*     */       }
/* 391 */       props = len;
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/*     */     }
/*     */ 
/* 397 */     return pub + props;
/*     */   }
/*     */ 
/*     */   public static boolean canUnWrap(Class javaType, boolean isReturnType)
/*     */   {
/* 410 */     boolean bool = false;
/*     */ 
/* 412 */     if (isReturnType)
/*     */     {
/* 414 */       bool = (isJavaBean(javaType)) && (getNumberOfParticles(javaType) == 1);
/*     */     }
/*     */     else
/*     */     {
/* 418 */       bool = isJaxrpcValueType(javaType);
/*     */     }
/* 420 */     return bool;
/*     */   }
/*     */ 
/*     */   public static boolean isJaxrpcPermittedType(Class type)
/*     */   {
/* 432 */     if (!isJaxrpcRegularType(type)) {
/* 433 */       return isJaxrpcValueType(type);
/*     */     }
/* 435 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean isJaxrpcRegularType(Class type)
/*     */   {
/* 447 */     boolean result = false;
/*     */ 
/* 449 */     if (JavaUtils.isPrimitive(type)) {
/* 450 */       return true;
/*     */     }
/* 452 */     Class wrapperType = JavaUtils.getWrapperType(type);
/* 453 */     if ((wrapperType != null) && (wrapperType != type)) {
/* 454 */       return true;
/*     */     }
/* 456 */     Class primType = JavaUtils.getPrimitiveType(type);
/* 457 */     if ((primType != null) && (primType != type)) {
/* 458 */       return true;
/*     */     }
/* 460 */     if ((String.class == type) || (Date.class == type) || (Calendar.class == type) || (BigInteger.class == type) || (BigDecimal.class == type) || (QName.class == type) || (URI.class == type))
/*     */     {
/* 463 */       return true;
/* 464 */     }return result;
/*     */   }
/*     */ 
/*     */   public static synchronized void registerJavaType(LiteralTypeMapping typeMapping, Class clazz, QName xmlType)
/*     */   {
/* 470 */     if (!typeMapping.isRegistered(clazz, xmlType))
/* 471 */       typeMapping.register(clazz, xmlType, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */   }
/*     */ 
/*     */   public static String convertInvalidCharacters(String component)
/*     */   {
/* 480 */     String result = component;
/* 481 */     for (int i = 0; i < result.length(); i++)
/*     */     {
/* 483 */       if (Character.isJavaIdentifierPart(result.charAt(i)))
/*     */         continue;
/* 485 */       result = result.replace(result.charAt(i), '_');
/*     */     }
/*     */ 
/* 489 */     return result;
/*     */   }
/*     */ 
/*     */   private static String trimPunctuationMarks(String str)
/*     */   {
/* 495 */     if (str == null) {
/* 496 */       throw new IllegalArgumentException("Str is null");
/*     */     }
/* 498 */     if (!Character.isJavaIdentifierStart(str.charAt(0))) {
/* 499 */       str = str.substring(1);
/*     */     }
/* 502 */     else if (isPunctuation(str.charAt(0)))
/* 503 */       str = str.substring(1);
/* 504 */     int len = str.length();
/*     */ 
/* 506 */     if (isPunctuation(str.charAt(len - 1)))
/* 507 */       str = str.substring(0, len - 1);
/* 508 */     return str;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.ToolsUtils
 * JD-Core Version:    0.6.0
 */