/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ 
/*     */ public class JavaWriter
/*     */ {
/*  45 */   private String newline = "\n";
/*     */ 
/*  47 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*     */   public void createJavaFileForEnumeratedValues(String fname, StringList lst, File loc, String pkgname, XSSimpleTypeDefinition type)
/*     */     throws IOException
/*     */   {
/*  64 */     List importList = new ArrayList();
/*  65 */     importList.add("java.util.Map");
/*  66 */     importList.add("java.util.HashMap");
/*  67 */     File sei = this.utils.createPhysicalFile(loc, fname);
/*  68 */     StringBuilder buf = this.utils.createClassBasicStructure(pkgname, fname, type, importList, null);
/*     */ 
/*  70 */     buf.append("private java.lang.String value;" + this.newline);
/*  71 */     buf.append("private static Map valueMap = new HashMap();" + this.newline);
/*     */ 
/*  74 */     int lenOfArr = lst != null ? lst.getLength() : 0;
/*  75 */     for (int i = 0; i < lenOfArr; i++)
/*     */     {
/*  77 */       String str = lst.item(i);
/*  78 */       buf.append("public static final String _" + str + "String = \"" + str + "\";" + this.newline);
/*     */     }
/*     */ 
/*  81 */     for (int i = 0; i < lenOfArr; i++)
/*     */     {
/*  83 */       String str = lst.item(i);
/*  84 */       buf.append("public static final java.lang.String _" + str + " = new java.lang.String(_" + str + "String);");
/*  85 */       buf.append(this.newline);
/*     */     }
/*     */ 
/*  88 */     for (int i = 0; i < lenOfArr; i++)
/*     */     {
/*  90 */       String str = lst.item(i);
/*  91 */       buf.append("public static final " + fname + " " + str + " = new " + fname + "(_" + str + ");");
/*  92 */       buf.append(this.newline);
/*     */     }
/*     */ 
/*  96 */     buf.append(this.newline + this.newline + "protected " + fname + "(java.lang.String value) { " + this.newline);
/*     */ 
/*  98 */     buf.append("this.value = value;valueMap.put(this.toString(), this); " + this.newline + "}");
/*     */ 
/* 100 */     buf.append(this.newline + this.newline);
/*     */ 
/* 103 */     buf.append(this.newline + " public java.lang.String getValue() {" + this.newline + "  return value;" + this.newline + "}");
/*     */ 
/* 105 */     buf.append(this.newline + this.newline);
/*     */ 
/* 108 */     buf.append(this.newline + "public static " + fname + "  fromValue(java.lang.String value)" + this.newline);
/*     */ 
/* 110 */     buf.append(" throws java.lang.IllegalStateException {" + this.newline);
/*     */ 
/* 112 */     for (int i = 0; i < lenOfArr; i++)
/*     */     {
/* 114 */       String str = lst.item(i);
/* 115 */       if (i > 0) {
/* 116 */         buf.append("else ");
/*     */       }
/* 118 */       buf.append("if (" + str + ".value.equals(value)) {" + this.newline);
/*     */ 
/* 120 */       buf.append("return " + str + ";" + this.newline);
/*     */ 
/* 122 */       buf.append("}" + this.newline);
/*     */     }
/*     */ 
/* 125 */     buf.append(" throw new IllegalArgumentException();" + this.newline + "}" + this.newline + this.newline);
/*     */ 
/* 130 */     buf.append(this.newline + "public static " + fname + "  fromString(String value)" + this.newline);
/*     */ 
/* 132 */     buf.append(" throws java.lang.IllegalStateException {" + this.newline);
/*     */ 
/* 134 */     buf.append(fname + " ret = (" + fname + ")valueMap.get(value);" + this.newline);
/*     */ 
/* 136 */     buf.append("if (ret != null) {" + this.newline + " return ret;" + this.newline + " }" + this.newline + this.newline);
/*     */ 
/* 138 */     for (int i = 0; i < lenOfArr; i++)
/*     */     {
/* 140 */       String str = lst.item(i);
/* 141 */       if (i > 0)
/* 142 */         buf.append("else ");
/* 143 */       buf.append("if (value.equals(_" + str + "String)) {" + this.newline);
/* 144 */       buf.append("return " + str + ";" + this.newline + "}");
/*     */     }
/*     */ 
/* 147 */     buf.append(this.newline + " throw new IllegalArgumentException();" + this.newline + "}" + this.newline + this.newline);
/*     */ 
/* 152 */     buf.append(this.newline + " public String toString() {" + this.newline + " return value.toString();" + this.newline + "}" + this.newline);
/*     */ 
/* 158 */     buf.append(this.newline + "private Object readResolve()" + this.newline + "        throws java.io.ObjectStreamException {" + this.newline + "        return fromValue(getValue());" + this.newline + "    } " + this.newline);
/*     */ 
/* 164 */     buf.append(this.newline + "private boolean equals(Object obj){" + this.newline + "         if (!(obj instanceof " + fname + ")) {" + this.newline + "         return false;" + this.newline + "    } " + this.newline);
/*     */ 
/* 166 */     buf.append("return ((" + fname + ")obj).value.equals(value);" + this.newline + "}" + this.newline);
/*     */ 
/* 171 */     buf.append(this.newline + " public int hashCode() { " + this.newline + "        return value.hashCode(); " + this.newline + "    }" + this.newline);
/*     */ 
/* 173 */     buf.append("}" + this.newline);
/*     */ 
/* 175 */     FileWriter writer = new FileWriter(sei);
/* 176 */     writer.write(buf.toString());
/* 177 */     writer.flush();
/* 178 */     writer.close();
/*     */   }
/*     */ 
/*     */   public void createJavaFile(File location, String filename, String packageName, List<XSDTypeToJava.VAR> vars, List<String> importList, String baseTypeName, boolean isExceptionType, Map<String, List> typeNameToBaseVARList)
/*     */     throws IOException
/*     */   {
/* 197 */     File newLoc = null;
/* 198 */     if (needToCreatePackageStructure(location, packageName))
/* 199 */       newLoc = this.utils.createPackage(location.getPath(), packageName);
/* 200 */     else newLoc = location;
/* 201 */     String classname = this.utils.chop(filename, ".java");
/* 202 */     File sei = this.utils.createPhysicalFile(newLoc, classname);
/* 203 */     StringBuilder buffer = new StringBuilder();
/* 204 */     this.utils.writeJbossHeader(buffer);
/*     */ 
/* 207 */     buffer.append(this.newline).append("package ").append(packageName).append(";");
/*     */ 
/* 209 */     if (importList != null)
/*     */     {
/* 211 */       for (String imp : importList)
/*     */       {
/* 213 */         buffer.append(this.newline).append("import ").append(imp).append(";");
/*     */       }
/*     */     }
/* 216 */     buffer.append(this.newline).append(this.newline);
/* 217 */     buffer.append(this.newline).append("public class  ").append(classname).append(this.newline);
/* 218 */     if ((baseTypeName != null) && (baseTypeName.length() > 0))
/* 219 */       buffer.append(" extends ").append(baseTypeName);
/* 220 */     buffer.append("{").append(this.newline);
/* 221 */     createVariables(buffer, vars, isExceptionType);
/* 222 */     createCTR(buffer, classname, vars, isExceptionType, typeNameToBaseVARList);
/* 223 */     buffer.append(this.newline);
/* 224 */     createAccessors(buffer, vars, isExceptionType);
/* 225 */     buffer.append("}").append(this.newline);
/*     */ 
/* 227 */     FileWriter writer = new FileWriter(sei);
/* 228 */     writer.write(buffer.toString());
/* 229 */     writer.flush();
/* 230 */     writer.close();
/*     */   }
/*     */ 
/*     */   private void createCTR(StringBuilder buf, String cname, List vars, boolean isExceptionType, Map<String, List> typeNameToBaseVARList)
/*     */   {
/* 236 */     if ((vars.size() > 0) && (!isExceptionType))
/*     */     {
/* 238 */       buf.append("public " + cname + "(){}");
/* 239 */       buf.append(this.newline);
/* 240 */       buf.append(this.newline);
/*     */     }
/*     */ 
/* 243 */     StringBuilder ctrvarbuf = new StringBuilder();
/* 244 */     StringBuilder ctrintbuf = new StringBuilder();
/*     */ 
/* 246 */     boolean calledSuper = false;
/* 247 */     if (isExceptionType)
/*     */     {
/* 249 */       List baseList = (List)typeNameToBaseVARList.get(cname);
/* 250 */       int baseLen = baseList != null ? baseList.size() : 0;
/* 251 */       String arrStr = "[]";
/*     */ 
/* 253 */       if (baseLen > 0)
/*     */       {
/* 255 */         calledSuper = true;
/* 256 */         ctrintbuf.append("super(");
/* 257 */         for (int i = 0; i < baseLen; i++)
/*     */         {
/* 260 */           if (i > 0)
/*     */           {
/* 262 */             ctrvarbuf.append(", ");
/* 263 */             ctrintbuf.append(", ");
/*     */           }
/* 265 */           XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)baseList.get(i);
/* 266 */           ctrvarbuf.append(v.getVartype());
/* 267 */           if (v.isArrayType) {
/* 268 */             ctrvarbuf.append(arrStr);
/*     */           }
/* 270 */           ctrvarbuf.append(" ").append(v.getVarname());
/* 271 */           ctrintbuf.append(v.getVarname());
/*     */         }
/* 273 */         ctrintbuf.append(");").append(this.newline);
/*     */       }
/*     */     }
/* 276 */     Iterator iter = vars.iterator();
/* 277 */     int index = 0;
/* 278 */     while (iter.hasNext())
/*     */     {
/* 280 */       if ((index++ > 0) || (calledSuper))
/*     */       {
/* 282 */         ctrvarbuf.append(", ");
/*     */       }
/* 284 */       XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)iter.next();
/* 285 */       String name = v.getVarname();
/* 286 */       if (JavaKeywords.isJavaKeyword(name))
/*     */       {
/* 288 */         name = "_" + name;
/*     */       }
/*     */ 
/* 291 */       String type = v.getVartype();
/* 292 */       boolean isArr = v.isArrayType();
/* 293 */       ctrvarbuf.append(type);
/* 294 */       if (isArr)
/* 295 */         ctrvarbuf.append("[]");
/* 296 */       ctrvarbuf.append(" " + name);
/* 297 */       if ((isExceptionType) && (!calledSuper) && (index == 1) && (v.getVartype().equals("java.lang.String")))
/*     */       {
/* 299 */         ctrintbuf.append("super(").append(v.getVarname()).append(");").append(this.newline);
/* 300 */         calledSuper = true;
/*     */       }
/*     */ 
/* 303 */       ctrintbuf.append("this." + name + "=" + name + ";");
/* 304 */       ctrintbuf.append(this.newline);
/*     */     }
/* 306 */     buf.append("public " + cname + "(" + ctrvarbuf.toString() + "){");
/* 307 */     buf.append(this.newline);
/* 308 */     buf.append(ctrintbuf.toString());
/* 309 */     buf.append("}");
/*     */   }
/*     */ 
/*     */   private void createAccessors(StringBuilder buf, List vars, boolean isExceptionType)
/*     */   {
/* 314 */     Iterator iter = vars.iterator();
/* 315 */     while (iter.hasNext())
/*     */     {
/* 317 */       XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)iter.next();
/* 318 */       String name = v.getVarname();
/* 319 */       String internalName = name;
/* 320 */       if (JavaKeywords.isJavaKeyword(internalName))
/*     */       {
/* 322 */         internalName = "_" + internalName;
/*     */       }
/*     */ 
/* 325 */       String type = v.getVartype();
/* 326 */       boolean isArr = v.isArrayType();
/*     */ 
/* 328 */       buf.append("public " + type);
/* 329 */       if (isArr)
/* 330 */         buf.append("[] ");
/* 331 */       String str = " get";
/*     */ 
/* 333 */       if (type.equals("boolean"))
/* 334 */         str = " is";
/* 335 */       buf.append(str + this.utils.getMixedCase(name) + "() { return " + internalName + " ;}");
/* 336 */       buf.append(this.newline);
/* 337 */       buf.append(this.newline);
/* 338 */       if (!isExceptionType)
/* 339 */         writeSetter(buf, name, internalName, type, isArr);
/* 340 */       buf.append(this.newline);
/* 341 */       buf.append(this.newline);
/*     */     }
/*     */   }
/*     */ 
/*     */   private List createVariables(StringBuilder buf, List vars, boolean isExceptionType)
/*     */   {
/* 347 */     if (vars == null)
/* 348 */       return vars;
/* 349 */     Iterator iter = vars.iterator();
/* 350 */     while (iter.hasNext())
/*     */     {
/* 352 */       XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)iter.next();
/* 353 */       String name = v.getVarname();
/*     */ 
/* 355 */       name = ToolsUtils.convertInvalidCharacters(name);
/*     */ 
/* 357 */       if (JavaKeywords.isJavaKeyword(name))
/*     */       {
/* 359 */         name = "_" + name;
/*     */       }
/*     */ 
/* 362 */       String type = v.getVartype();
/* 363 */       boolean isArr = v.isArrayType();
/* 364 */       buf.append(this.newline);
/* 365 */       if (isExceptionType)
/* 366 */         buf.append("private " + type);
/* 367 */       else buf.append("protected " + type);
/* 368 */       if (isArr)
/* 369 */         buf.append("[] ");
/* 370 */       buf.append(" " + name).append(";").append(this.newline);
/*     */     }
/* 372 */     return vars;
/*     */   }
/*     */ 
/*     */   private boolean needToCreatePackageStructure(File location, String packageName)
/*     */   {
/* 377 */     packageName = packageName.replace('.', '/');
/*     */     try
/*     */     {
/* 380 */       String externalForm = location.toURL().toExternalForm();
/* 381 */       return externalForm.indexOf(packageName) < 0;
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */     }
/* 386 */     return false;
/*     */   }
/*     */ 
/*     */   private void writeSetter(StringBuilder buf, String name, String internalName, String type, boolean isArr)
/*     */   {
/* 392 */     buf.append("public void ");
/* 393 */     buf.append("set" + this.utils.getMixedCase(name) + "(" + type);
/* 394 */     if (isArr) {
/* 395 */       buf.append("[]");
/*     */     }
/* 397 */     buf.append(" " + internalName + "){ this." + internalName + "=" + internalName + "; }");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaWriter
 * JD-Core Version:    0.6.0
 */