/*    */ package org.jboss.ws.tools;
/*    */ 
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ 
/*    */ public class JavaKeywords
/*    */ {
/* 38 */   private static final JavaKeywords keywords = new JavaKeywords();
/*    */ 
/* 40 */   private final String[] keywordsArray = { "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while" };
/*    */ 
/* 45 */   private final String[] restrictedLiteralsArray = { "true", "false", "null" };
/*    */   private final Set<String> restrictedKeywords;
/*    */ 
/*    */   private JavaKeywords()
/*    */   {
/* 51 */     int keywordsSize = this.keywordsArray.length + this.restrictedLiteralsArray.length;
/* 52 */     keywordsSize = (int)(keywordsSize / 0.75D) + 1;
/*    */ 
/* 54 */     this.restrictedKeywords = new HashSet(keywordsSize);
/* 55 */     addAll(this.restrictedKeywords, this.keywordsArray);
/* 56 */     addAll(this.restrictedKeywords, this.restrictedLiteralsArray);
/*    */   }
/*    */ 
/*    */   private void addAll(Set<String> set, String[] data)
/*    */   {
/* 61 */     for (String current : data)
/*    */     {
/* 63 */       set.add(current);
/*    */     }
/*    */   }
/*    */ 
/*    */   private boolean internalIsRestrictedKeyword(String name)
/*    */   {
/* 76 */     return this.restrictedKeywords.contains(name);
/*    */   }
/*    */ 
/*    */   public static boolean isJavaKeyword(String name)
/*    */   {
/* 87 */     return keywords.internalIsRestrictedKeyword(name);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaKeywords
 * JD-Core Version:    0.6.0
 */