/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class JBossXSTypeDefinition extends JBossXSObject
/*     */   implements XSTypeDefinition
/*     */ {
/*     */   private static final long serialVersionUID = -3317350531846406564L;
/*  35 */   protected boolean anonymous = false;
/*     */   protected JBossXSTypeDefinition baseType;
/*  37 */   protected boolean isFinal = false;
/*     */ 
/*     */   public JBossXSTypeDefinition()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition(String name, String namespace)
/*     */   {
/*  45 */     super(name, namespace);
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition(XSTypeDefinition xt)
/*     */   {
/*  56 */     super(xt.getName(), xt.getNamespace());
/*  57 */     setAnonymous(xt.getAnonymous());
/*     */ 
/*  59 */     XSTypeDefinition xbase = xt.getBaseType();
/*  60 */     if (xbase != null)
/*     */     {
/*  62 */       if ((!(xbase instanceof JBossXSTypeDefinition)) && (!"anyType".equals(xbase.getName())))
/*  63 */         this.baseType = new JBossXSTypeDefinition(xbase);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short getTypeCategory()
/*     */   {
/*  73 */     throw new WSException("Type unidentified");
/*     */   }
/*     */ 
/*     */   public XSTypeDefinition getBaseType()
/*     */   {
/*  82 */     return this.baseType;
/*     */   }
/*     */ 
/*     */   public boolean isFinal(short restriction)
/*     */   {
/*  96 */     return this.isFinal;
/*     */   }
/*     */ 
/*     */   public short getFinal()
/*     */   {
/* 111 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean getAnonymous()
/*     */   {
/* 118 */     return this.anonymous;
/*     */   }
/*     */ 
/*     */   public void setAnonymous(boolean anonymous)
/*     */   {
/* 123 */     this.anonymous = anonymous;
/*     */   }
/*     */ 
/*     */   public boolean derivedFromType(XSTypeDefinition ancestorType, short derivationMethod)
/*     */   {
/* 139 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean derivedFrom(String namespace, String name, short derivationMethod)
/*     */   {
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public void setBaseType(XSTypeDefinition baseT)
/*     */   {
/* 161 */     if ((baseT instanceof JBossXSTypeDefinition))
/*     */     {
/* 163 */       this.baseType = ((JBossXSTypeDefinition)baseT);
/*     */     }
/*     */     else
/*     */     {
/* 167 */       this.baseType = new JBossXSTypeDefinition(baseT);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setFinal(boolean aFinal)
/*     */   {
/* 173 */     this.isFinal = aFinal;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition
 * JD-Core Version:    0.6.0
 */