/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import org.apache.xerces.xni.XNIException;
/*     */ import org.apache.xerces.xni.parser.XMLErrorHandler;
/*     */ import org.apache.xerces.xni.parser.XMLParseException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossXSErrorHandler
/*     */   implements XMLErrorHandler
/*     */ {
/*  36 */   private static final Logger log = Logger.getLogger(JBossXSErrorHandler.class);
/*     */ 
/*     */   public void warning(String domain, String key, XMLParseException xexp)
/*     */     throws XNIException
/*     */   {
/*  47 */     log.trace(getFormattedString(domain, key, xexp));
/*     */   }
/*     */ 
/*     */   public void error(String domain, String key, XMLParseException xexp)
/*     */     throws XNIException
/*     */   {
/*  59 */     if ("src-include.2.1".equals(key)) {
/*  60 */       throw new XNIException("Parser should stop:", xexp);
/*     */     }
/*  62 */     String errorMsg = getFormattedString(domain, key, xexp);
/*  63 */     log.error(errorMsg);
/*     */   }
/*     */ 
/*     */   public void fatalError(String domain, String key, XMLParseException xexp)
/*     */     throws XNIException
/*     */   {
/*  76 */     String errorMsg = getFormattedString(domain, key, xexp);
/*  77 */     log.error(errorMsg);
/*  78 */     throw new XNIException("Parser should stop: " + errorMsg, xexp);
/*     */   }
/*     */ 
/*     */   private String getFileName(XMLParseException xexp)
/*     */   {
/*  86 */     String fname = xexp.getExpandedSystemId();
/*  87 */     if (fname != null)
/*     */     {
/*  89 */       int index = fname.lastIndexOf('/');
/*  90 */       if (index != -1)
/*  91 */         fname = fname.substring(index + 1);
/*     */     }
/*     */     else
/*     */     {
/*  95 */       fname = "";
/*     */     }
/*     */ 
/*  98 */     return fname;
/*     */   }
/*     */ 
/*     */   private String getFormattedString(String domain, String key, XMLParseException xexp)
/*     */   {
/* 107 */     StringBuilder buf = new StringBuilder(getFileName(xexp));
/* 108 */     buf.append("[domain:");
/* 109 */     buf.append(domain).append("]::[key=").append(key).append("]::");
/* 110 */     buf.append("Message=");
/* 111 */     buf.append(xexp.getLocalizedMessage());
/* 112 */     return buf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler
 * JD-Core Version:    0.6.0
 */