/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class WSDLService extends Extendable
/*     */ {
/*     */   private static final long serialVersionUID = 1274166611190648479L;
/*  47 */   private static final Logger log = Logger.getLogger(WSDLService.class);
/*     */   private final WSDLDefinitions wsdlDefinitions;
/*     */   private final QName name;
/*     */   private QName interfaceName;
/*  58 */   private ArrayList<WSDLEndpoint> endpoints = new ArrayList();
/*     */ 
/*     */   public WSDLService(WSDLDefinitions wsdlDefinitions, QName name)
/*     */   {
/*  62 */     this.wsdlDefinitions = wsdlDefinitions;
/*  63 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinitions()
/*     */   {
/*  68 */     return this.wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public QName getName()
/*     */   {
/*  73 */     return this.name;
/*     */   }
/*     */ 
/*     */   public QName getInterfaceName()
/*     */   {
/*  78 */     return this.interfaceName;
/*     */   }
/*     */ 
/*     */   public void setInterfaceName(QName interfaceName)
/*     */   {
/*  83 */     this.interfaceName = interfaceName;
/*     */   }
/*     */ 
/*     */   public WSDLEndpoint[] getEndpoints()
/*     */   {
/*  88 */     WSDLEndpoint[] arr = new WSDLEndpoint[this.endpoints.size()];
/*  89 */     this.endpoints.toArray(arr);
/*  90 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addEndpoint(WSDLEndpoint endpoint)
/*     */   {
/*  95 */     this.endpoints.add(endpoint);
/*     */   }
/*     */ 
/*     */   public WSDLEndpoint getEndpoint(QName portName)
/*     */   {
/* 102 */     Iterator it = this.endpoints.iterator();
/* 103 */     while (it.hasNext())
/*     */     {
/* 105 */       WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)it.next();
/* 106 */       if (portName.equals(wsdlEndpoint.getName()))
/* 107 */         return wsdlEndpoint;
/*     */     }
/* 109 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLService
 * JD-Core Version:    0.6.0
 */