/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class WSDLProperty
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7528676719881753461L;
/*     */   private String uri;
/*     */   private boolean required;
/*     */   private String value;
/*     */   private QName constraint;
/*     */   private QName qnameValue;
/*     */ 
/*     */   public WSDLProperty(String uri, String value)
/*     */   {
/*  62 */     if (uri == null) {
/*  63 */       throw new IllegalArgumentException("Illegal property URI: " + uri);
/*     */     }
/*  65 */     this.uri = uri;
/*  66 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public WSDLProperty(String uri, QName value)
/*     */   {
/*  71 */     if (uri == null) {
/*  72 */       throw new IllegalArgumentException("Illegal property URI: " + uri);
/*     */     }
/*  74 */     this.uri = uri;
/*  75 */     this.qnameValue = value;
/*     */   }
/*     */ 
/*     */   public WSDLProperty(String uri, boolean required, String value, QName constraint)
/*     */   {
/*  80 */     if (uri == null) {
/*  81 */       throw new IllegalArgumentException("Illegal property URI: " + uri);
/*     */     }
/*  83 */     this.uri = uri;
/*  84 */     this.required = required;
/*  85 */     this.value = value;
/*  86 */     this.constraint = constraint;
/*     */   }
/*     */ 
/*     */   public String getURI()
/*     */   {
/*  91 */     return this.uri;
/*     */   }
/*     */ 
/*     */   public boolean isRequired()
/*     */   {
/*  96 */     return this.required;
/*     */   }
/*     */ 
/*     */   public void setRequired(boolean required)
/*     */   {
/* 101 */     this.required = required;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 106 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/* 111 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public QName getConstraint()
/*     */   {
/* 116 */     return this.constraint;
/*     */   }
/*     */ 
/*     */   public void setConstraint(QName constraint)
/*     */   {
/* 121 */     this.constraint = constraint;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 126 */     return "[" + this.uri + "=" + this.value + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLProperty
 * JD-Core Version:    0.6.0
 */