/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.LinkedHashMap;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public abstract class WSDLInterfaceMessageReference extends Extendable
/*     */   implements Comparable
/*     */ {
/*  48 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private WSDLInterfaceOperation wsdlOperation;
/*     */   private String messageLabel;
/*     */   private QName element;
/*  71 */   private LinkedHashMap<String, WSDLRPCPart> childParts = new LinkedHashMap();
/*     */   private String partName;
/*     */   private QName messageName;
/*     */ 
/*     */   public WSDLInterfaceMessageReference(WSDLInterfaceOperation wsdlOperation)
/*     */   {
/*  85 */     this.log.trace("New part for wsdlOperation: " + wsdlOperation.getName());
/*  86 */     this.wsdlOperation = wsdlOperation;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation getWsdlOperation()
/*     */   {
/*  91 */     return this.wsdlOperation;
/*     */   }
/*     */ 
/*     */   public String getMessageLabel()
/*     */   {
/*  96 */     return this.messageLabel;
/*     */   }
/*     */ 
/*     */   public void setMessageLabel(String messageLabel)
/*     */   {
/* 101 */     this.messageLabel = messageLabel;
/*     */   }
/*     */ 
/*     */   public QName getElement()
/*     */   {
/* 106 */     return this.element;
/*     */   }
/*     */ 
/*     */   public void setElement(QName element)
/*     */   {
/* 111 */     this.log.trace("setElement: " + element);
/* 112 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public QName getXMLType()
/*     */   {
/* 120 */     QName xmlType = null;
/*     */ 
/* 123 */     WSDLDefinitions wsdlDefinitions = this.wsdlOperation.getWsdlInterface().getWsdlDefinitions();
/* 124 */     WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
/* 125 */     xmlType = wsdlTypes.getXMLType(this.element);
/*     */ 
/* 128 */     if (xmlType == null)
/*     */     {
/* 130 */       WSDLProperty property = getProperty("http://www.jboss.org/jbossws/part/xmltype");
/* 131 */       if (property != null)
/*     */       {
/* 133 */         String qnameRef = property.getValue();
/* 134 */         int colIndex = qnameRef.indexOf(':');
/* 135 */         String prefix = qnameRef.substring(0, colIndex);
/* 136 */         String localPart = qnameRef.substring(colIndex + 1);
/* 137 */         String nsURI = wsdlDefinitions.getNamespaceURI(prefix);
/* 138 */         xmlType = new QName(nsURI, localPart, prefix);
/*     */       }
/*     */     }
/*     */ 
/* 142 */     if (xmlType == null) {
/* 143 */       throw new WSException("Cannot obtain xmlType for element: " + this.element);
/*     */     }
/* 145 */     return xmlType;
/*     */   }
/*     */ 
/*     */   public Collection<WSDLRPCPart> getChildParts()
/*     */   {
/* 156 */     return this.childParts.values();
/*     */   }
/*     */ 
/*     */   public WSDLRPCPart getChildPart(String name)
/*     */   {
/* 168 */     return (WSDLRPCPart)this.childParts.get(name);
/*     */   }
/*     */ 
/*     */   public void addChildPart(WSDLRPCPart childPart)
/*     */   {
/* 179 */     this.childParts.put(childPart.getName(), childPart);
/*     */   }
/*     */ 
/*     */   public void removeChildPart(String name)
/*     */   {
/* 190 */     this.childParts.remove(name);
/*     */   }
/*     */ 
/*     */   public String getPartName()
/*     */   {
/* 200 */     return this.partName;
/*     */   }
/*     */ 
/*     */   public void setMessageName(QName messageName)
/*     */   {
/* 210 */     this.messageName = messageName;
/*     */   }
/*     */ 
/*     */   public QName getMessageName()
/*     */   {
/* 220 */     return this.messageName;
/*     */   }
/*     */ 
/*     */   public void setPartName(String partName)
/*     */   {
/* 230 */     this.partName = partName;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object o)
/*     */   {
/* 235 */     int c = -1;
/* 236 */     if ((o instanceof WSDLInterfaceMessageReference))
/*     */     {
/* 238 */       WSDLInterfaceMessageReference w = (WSDLInterfaceMessageReference)o;
/* 239 */       String oname = w.getElement().getLocalPart();
/* 240 */       String myname = getElement().getLocalPart();
/* 241 */       c = myname.compareTo(oname);
/*     */     }
/* 243 */     return c;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLInterfaceMessageReference
 * JD-Core Version:    0.6.0
 */