/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class WSDLEndpoint extends Extendable
/*     */ {
/*     */   private static final long serialVersionUID = 4991302339046047865L;
/*  44 */   private static final Logger log = Logger.getLogger(WSDLEndpoint.class);
/*     */   private final WSDLService wsdlService;
/*     */   private final QName name;
/*     */   private QName binding;
/*     */   private String address;
/*     */ 
/*     */   public WSDLEndpoint(WSDLService wsdlService, QName name)
/*     */   {
/*  59 */     this.wsdlService = wsdlService;
/*  60 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public WSDLService getWsdlService()
/*     */   {
/*  65 */     return this.wsdlService;
/*     */   }
/*     */ 
/*     */   public WSDLInterface getInterface()
/*     */   {
/*  74 */     WSDLInterface wsdlInterface = null;
/*     */ 
/*  76 */     WSDLDefinitions wsdlDefinitions = this.wsdlService.getWsdlDefinitions();
/*  77 */     if (this.wsdlService.getInterfaceName() != null)
/*     */     {
/*  79 */       QName qname = this.wsdlService.getInterfaceName();
/*  80 */       wsdlInterface = wsdlDefinitions.getInterface(qname);
/*     */     }
/*     */     else
/*     */     {
/*  84 */       WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(this.binding);
/*  85 */       if (wsdlBinding == null) {
/*  86 */         throw new WSException("Cannot obtain the binding: " + this.binding);
/*     */       }
/*  88 */       if (wsdlBinding.getInterfaceName() != null)
/*     */       {
/*  90 */         QName qname = wsdlBinding.getInterfaceName();
/*  91 */         wsdlInterface = wsdlDefinitions.getInterface(qname);
/*     */       }
/*     */     }
/*     */ 
/*  95 */     if (wsdlInterface == null) {
/*  96 */       throw new WSException("Cannot obtain the interface associated with this endpoint: " + this.name);
/*     */     }
/*  98 */     return wsdlInterface;
/*     */   }
/*     */ 
/*     */   public QName getName()
/*     */   {
/* 104 */     return this.name;
/*     */   }
/*     */ 
/*     */   public QName getBinding()
/*     */   {
/* 109 */     return this.binding;
/*     */   }
/*     */ 
/*     */   public void setBinding(QName binding)
/*     */   {
/* 114 */     log.trace("setBinding: " + binding);
/* 115 */     this.binding = binding;
/*     */   }
/*     */ 
/*     */   public String getAddress()
/*     */   {
/* 120 */     return this.address;
/*     */   }
/*     */ 
/*     */   public void setAddress(String address)
/*     */   {
/* 125 */     this.address = address;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLEndpoint
 * JD-Core Version:    0.6.0
 */