/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.wsdl.Definition;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class WSDLDefinitions extends Extendable
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1643422922694990226L;
/*  55 */   private final Logger log = Logger.getLogger(WSDLDefinitions.class);
/*     */   private String targetNamespace;
/*     */   private String wsdlNamespace;
/*  65 */   private List<WSDLImport> imports = new ArrayList();
/*     */ 
/*  67 */   private List<WSDLInclude> includes = new ArrayList();
/*     */   private WSDLTypes types;
/*  71 */   private Map<QName, WSDLInterface> interfaces = new LinkedHashMap();
/*     */ 
/*  73 */   private Map<QName, WSDLBinding> bindings = new LinkedHashMap();
/*     */ 
/*  75 */   private Map<QName, WSDLService> services = new LinkedHashMap();
/*     */ 
/*  79 */   private NamespaceRegistry namespaces = new NamespaceRegistry();
/*     */   private Definition wsdlOneOneDefinition;
/*     */   private Document wsdlDocument;
/*     */ 
/*     */   public void setWsdlOneOneDefinition(Definition wsdlDefinition)
/*     */   {
/*  91 */     this.wsdlOneOneDefinition = wsdlDefinition;
/*     */   }
/*     */ 
/*     */   public Definition getWsdlOneOneDefinition()
/*     */   {
/* 101 */     return this.wsdlOneOneDefinition;
/*     */   }
/*     */ 
/*     */   public Document getWsdlDocument()
/*     */   {
/* 106 */     return this.wsdlDocument;
/*     */   }
/*     */ 
/*     */   public void setWsdlDocument(Document wsdlDocument)
/*     */   {
/* 111 */     this.wsdlDocument = wsdlDocument;
/*     */   }
/*     */ 
/*     */   public String registerNamespaceURI(String nsURI, String prefix)
/*     */   {
/* 117 */     String pre = this.namespaces.getPrefix(nsURI);
/* 118 */     if ((pre == null) || (pre == ""))
/*     */     {
/* 120 */       pre = this.namespaces.registerURI(nsURI, prefix);
/* 121 */       this.log.trace("registerNamespaceURI: " + pre + "=" + nsURI);
/*     */     }
/* 123 */     return pre;
/*     */   }
/*     */ 
/*     */   public QName registerQName(QName qname)
/*     */   {
/* 129 */     return this.namespaces.registerQName(qname);
/*     */   }
/*     */ 
/*     */   public String getPrefix(String namespaceURI)
/*     */   {
/* 135 */     return this.namespaces.getPrefix(namespaceURI);
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI(String prefix)
/*     */   {
/* 141 */     return this.namespaces.getNamespaceURI(prefix);
/*     */   }
/*     */ 
/*     */   public String getTargetPrefix()
/*     */   {
/* 147 */     return this.namespaces.getPrefix(this.targetNamespace);
/*     */   }
/*     */ 
/*     */   public Iterator getRegisteredNamespaceURIs()
/*     */   {
/* 153 */     return this.namespaces.getRegisteredURIs();
/*     */   }
/*     */ 
/*     */   public Iterator getRegisteredPrefix()
/*     */   {
/* 159 */     return this.namespaces.getRegisteredPrefixes();
/*     */   }
/*     */ 
/*     */   public String getTargetNamespace()
/*     */   {
/* 164 */     return this.targetNamespace;
/*     */   }
/*     */ 
/*     */   public void setTargetNamespace(String namespaceURI)
/*     */   {
/* 169 */     if (namespaceURI == null) {
/* 170 */       throw new IllegalArgumentException("Illegal Null Argument:namespaceURI");
/*     */     }
/* 172 */     this.log.trace("setTargetNamespace: " + namespaceURI);
/* 173 */     this.targetNamespace = namespaceURI;
/*     */   }
/*     */ 
/*     */   public String getWsdlNamespace()
/*     */   {
/* 178 */     return this.wsdlNamespace;
/*     */   }
/*     */ 
/*     */   public void setWsdlNamespace(String namespaceURI)
/*     */   {
/* 183 */     if (!"http://schemas.xmlsoap.org/wsdl/".equals(namespaceURI)) {
/* 184 */       throw new IllegalArgumentException("Invalid default namespace: " + namespaceURI);
/*     */     }
/* 186 */     this.wsdlNamespace = namespaceURI;
/*     */   }
/*     */ 
/*     */   public WSDLImport[] getImports()
/*     */   {
/* 191 */     WSDLImport[] arr = new WSDLImport[this.imports.size()];
/* 192 */     this.imports.toArray(arr);
/* 193 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addImport(WSDLImport anImport)
/*     */   {
/* 198 */     this.imports.add(anImport);
/*     */   }
/*     */ 
/*     */   public WSDLInclude[] getIncludes()
/*     */   {
/* 203 */     WSDLInclude[] arr = new WSDLInclude[this.includes.size()];
/* 204 */     this.includes.toArray(arr);
/* 205 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addInclude(WSDLInclude include)
/*     */   {
/* 210 */     this.includes.add(include);
/*     */   }
/*     */ 
/*     */   public WSDLTypes getWsdlTypes()
/*     */   {
/* 215 */     return this.types;
/*     */   }
/*     */ 
/*     */   public void setWsdlTypes(WSDLTypes types)
/*     */   {
/* 220 */     this.types = types;
/* 221 */     this.types.setWSDLDefintiions(this);
/*     */   }
/*     */ 
/*     */   public WSDLInterface getInterface(QName name)
/*     */   {
/* 226 */     return (WSDLInterface)this.interfaces.get(name);
/*     */   }
/*     */ 
/*     */   public WSDLInterface[] getInterfaces()
/*     */   {
/* 231 */     WSDLInterface[] arr = new WSDLInterface[this.interfaces.size()];
/* 232 */     new ArrayList(this.interfaces.values()).toArray(arr);
/* 233 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addInterface(WSDLInterface wsdlInterface)
/*     */   {
/* 238 */     this.interfaces.put(wsdlInterface.getName(), wsdlInterface);
/*     */   }
/*     */ 
/*     */   public WSDLBinding[] getBindings()
/*     */   {
/* 243 */     WSDLBinding[] arr = new WSDLBinding[this.bindings.size()];
/* 244 */     new ArrayList(this.bindings.values()).toArray(arr);
/* 245 */     return arr;
/*     */   }
/*     */ 
/*     */   public WSDLBinding getBinding(QName name)
/*     */   {
/* 250 */     return (WSDLBinding)this.bindings.get(name);
/*     */   }
/*     */ 
/*     */   public WSDLBinding getBindingByInterfaceName(QName qname)
/*     */   {
/* 255 */     WSDLBinding wsdlBinding = null;
/* 256 */     for (WSDLBinding aux : this.bindings.values())
/*     */     {
/* 258 */       if (aux.getInterfaceName().equals(qname))
/*     */       {
/* 260 */         if (wsdlBinding != null) {
/* 261 */           this.log.warn("Multiple WSDL bindings referrence the same interface: " + qname);
/*     */         }
/* 263 */         wsdlBinding = aux;
/*     */       }
/*     */     }
/* 266 */     return wsdlBinding;
/*     */   }
/*     */ 
/*     */   public void addBinding(WSDLBinding binding)
/*     */   {
/* 271 */     this.bindings.put(binding.getName(), binding);
/*     */   }
/*     */ 
/*     */   public WSDLService[] getServices()
/*     */   {
/* 276 */     WSDLService[] arr = new WSDLService[this.services.size()];
/* 277 */     new ArrayList(this.services.values()).toArray(arr);
/* 278 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addService(WSDLService service)
/*     */   {
/* 283 */     this.services.put(service.getName(), service);
/*     */   }
/*     */ 
/*     */   public WSDLService getService(QName name)
/*     */   {
/* 288 */     return (WSDLService)this.services.get(name);
/*     */   }
/*     */ 
/*     */   public WSDLService getService(String localName)
/*     */   {
/* 293 */     return (WSDLService)this.services.get(new QName(this.targetNamespace, localName));
/*     */   }
/*     */ 
/*     */   public void unRegisterNamespaceURI(String namespaceURI, String prefix)
/*     */   {
/* 299 */     String pre = this.namespaces.getPrefix(namespaceURI);
/* 300 */     if ((pre != null) && (pre.equals(prefix)))
/* 301 */       this.namespaces.removePrefixMapping(prefix);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLDefinitions
 * JD-Core Version:    0.6.0
 */