/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class WSDLBindingOperation extends Extendable
/*     */   implements Comparable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -1986624862746844610L;
/*     */   private WSDLBinding wsdlBinding;
/*     */   private QName ref;
/*  57 */   private String encodingStyle = "";
/*     */   private String soapAction;
/*     */   private String namespaceURI;
/*  64 */   private List<WSDLBindingOperationInput> inputs = new ArrayList();
/*     */ 
/*  66 */   private List<WSDLBindingOperationOutput> outputs = new ArrayList();
/*     */ 
/*     */   public WSDLBindingOperation(WSDLBinding wsdlBinding)
/*     */   {
/*  70 */     this.wsdlBinding = wsdlBinding;
/*     */   }
/*     */ 
/*     */   public WSDLBinding getWsdlBinding()
/*     */   {
/*  75 */     return this.wsdlBinding;
/*     */   }
/*     */ 
/*     */   public QName getRef()
/*     */   {
/*  80 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public void setRef(QName ref)
/*     */   {
/*  85 */     this.ref = ref;
/*     */   }
/*     */ 
/*     */   public String getEncodingStyle()
/*     */   {
/*  90 */     return this.encodingStyle;
/*     */   }
/*     */ 
/*     */   public void setEncodingStyle(String encodingStyle)
/*     */   {
/*  95 */     this.encodingStyle = encodingStyle;
/*     */   }
/*     */ 
/*     */   public String getSOAPAction()
/*     */   {
/* 101 */     return this.soapAction;
/*     */   }
/*     */ 
/*     */   public void setSOAPAction(String soapAction)
/*     */   {
/* 106 */     this.soapAction = soapAction;
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI()
/*     */   {
/* 111 */     return this.namespaceURI;
/*     */   }
/*     */ 
/*     */   public void setNamespaceURI(String namespaceURI)
/*     */   {
/* 116 */     this.namespaceURI = namespaceURI;
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperationInput[] getInputs()
/*     */   {
/* 121 */     WSDLBindingOperationInput[] arr = new WSDLBindingOperationInput[this.inputs.size()];
/* 122 */     this.inputs.toArray(arr);
/* 123 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addInput(WSDLBindingOperationInput input)
/*     */   {
/* 128 */     this.inputs.add(input);
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperationOutput[] getOutputs()
/*     */   {
/* 133 */     WSDLBindingOperationOutput[] arr = new WSDLBindingOperationOutput[this.outputs.size()];
/* 134 */     this.outputs.toArray(arr);
/* 135 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addOutput(WSDLBindingOperationOutput output)
/*     */   {
/* 140 */     this.outputs.add(output);
/*     */   }
/*     */ 
/*     */   public int compareTo(Object obj)
/*     */   {
/* 148 */     int c = -1;
/* 149 */     if ((obj instanceof WSDLBindingOperation))
/*     */     {
/* 151 */       WSDLBindingOperation w = (WSDLBindingOperation)obj;
/* 152 */       String oname = w.getRef().getLocalPart();
/* 153 */       String myname = this.ref.getLocalPart();
/* 154 */       c = myname.compareTo(oname);
/*     */     }
/* 156 */     return c;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLBindingOperation
 * JD-Core Version:    0.6.0
 */