/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ 
/*     */ public class TypesMetaData
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(TypesMetaData.class);
/*     */   private ServiceMetaData serviceMetaData;
/*  52 */   private List<TypeMappingMetaData> typeList = new ArrayList();
/*     */   private JBossXSModel schemaModel;
/*     */ 
/*     */   public TypesMetaData(ServiceMetaData serviceMetaData)
/*     */   {
/*  58 */     this.serviceMetaData = serviceMetaData;
/*     */   }
/*     */ 
/*     */   public ServiceMetaData getServiceMetaData()
/*     */   {
/*  63 */     return this.serviceMetaData;
/*     */   }
/*     */ 
/*     */   public JBossXSModel getSchemaModel()
/*     */   {
/*  68 */     return this.schemaModel;
/*     */   }
/*     */ 
/*     */   public void setSchemaModel(JBossXSModel model)
/*     */   {
/*  73 */     this.schemaModel = model;
/*     */   }
/*     */ 
/*     */   public void addSchemaModel(JBossXSModel model)
/*     */   {
/*  78 */     if (this.schemaModel == null)
/*     */     {
/*  80 */       this.schemaModel = model;
/*     */     }
/*     */     else
/*     */     {
/*  84 */       this.schemaModel.merge(model);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<TypeMappingMetaData> getTypeMappings()
/*     */   {
/*  90 */     return new ArrayList(this.typeList);
/*     */   }
/*     */ 
/*     */   public void addTypeMapping(TypeMappingMetaData tmMetaData)
/*     */   {
/*  95 */     if (!this.typeList.contains(tmMetaData))
/*     */     {
/*  97 */       log.trace("Add type mapping: " + tmMetaData);
/*  98 */       this.typeList.add(tmMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   public TypeMappingMetaData getTypeMappingByXMLType(QName xmlType)
/*     */   {
/* 104 */     TypeMappingMetaData tmMetaData = null;
/* 105 */     for (TypeMappingMetaData aux : this.typeList)
/*     */     {
/* 107 */       boolean isElementScope = "element".equals(aux.getQNameScope());
/* 108 */       if ((aux.getXmlType().equals(xmlType)) && (!isElementScope))
/*     */       {
/* 110 */         if (tmMetaData != null)
/*     */         {
/* 112 */           log.error(tmMetaData + "\n" + aux);
/* 113 */           throw new WSException("Ambiguous type mappping for: " + xmlType);
/*     */         }
/* 115 */         tmMetaData = aux;
/*     */       }
/*     */     }
/*     */ 
/* 119 */     if ((tmMetaData == null) && (this.schemaModel != null))
/*     */     {
/* 122 */       XSTypeDefinition xsType = this.schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 123 */       if ((xsType instanceof XSSimpleTypeDefinition))
/*     */       {
/* 125 */         XSSimpleTypeDefinition xsSimpleType = (XSSimpleTypeDefinition)xsType;
/* 126 */         String javaTypeName = null;
/*     */ 
/* 131 */         if (xsSimpleType.getVariety() == 2)
/*     */         {
/* 133 */           XSSimpleTypeDefinition itemType = xsSimpleType.getItemType();
/* 134 */           QName xmlBaseType = new QName(itemType.getNamespace(), itemType.getName());
/* 135 */           javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType);
/* 136 */           if (javaTypeName != null)
/*     */           {
/* 138 */             javaTypeName = javaTypeName + "[]";
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 147 */         XSTypeDefinition xsBaseType = xsType.getBaseType();
/* 148 */         while ((javaTypeName == null) && (xsBaseType != null))
/*     */         {
/* 150 */           QName xmlBaseType = new QName(xsBaseType.getNamespace(), xsBaseType.getName());
/* 151 */           javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType);
/* 152 */           xsBaseType = xsBaseType.getBaseType();
/*     */         }
/*     */ 
/* 155 */         if (javaTypeName != null)
/*     */         {
/* 157 */           tmMetaData = new TypeMappingMetaData(this, xmlType, javaTypeName);
/* 158 */           tmMetaData.setQNameScope("simpleType");
/* 159 */           if (log.isDebugEnabled()) log.debug("Adding a simpleType without jaxrpc-mapping: " + tmMetaData);
/* 160 */           addTypeMapping(tmMetaData);
/*     */         }
/*     */         else
/*     */         {
/* 164 */           log.warn("Cannot obtain javaTypeName for xmlType: " + xmlType);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 169 */     return tmMetaData;
/*     */   }
/*     */ 
/*     */   public TypeMappingMetaData getTypeMappingByJavaType(String javaTypeName)
/*     */   {
/* 174 */     TypeMappingMetaData tmMetaData = null;
/* 175 */     for (TypeMappingMetaData aux : this.typeList)
/*     */     {
/* 177 */       if (aux.getJavaTypeName().equals(javaTypeName))
/* 178 */         tmMetaData = aux;
/*     */     }
/* 180 */     return tmMetaData;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 185 */     StringBuilder buffer = new StringBuilder("\nTypesMetaData: ");
/* 186 */     for (TypeMappingMetaData tmd : this.typeList)
/*     */     {
/* 188 */       buffer.append("\n  " + tmd);
/*     */     }
/* 190 */     buffer.append("\n" + (this.schemaModel != null ? this.schemaModel.serialize() : "<schema/>"));
/* 191 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.TypesMetaData
 * JD-Core Version:    0.6.0
 */