/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class ServerEndpointMetaData extends EndpointMetaData
/*     */ {
/*  48 */   protected static final Logger log = Logger.getLogger(ServerEndpointMetaData.class);
/*     */   public static final String SEPID_DOMAIN = "jboss.ws";
/*     */   public static final String SEPID_PROPERTY_CONTEXT = "context";
/*     */   public static final String SEPID_PROPERTY_ENDPOINT = "endpoint";
/*     */   private Endpoint endpoint;
/*     */   private String linkName;
/*     */   private String portComponentName;
/*     */   private String implName;
/*     */   private ObjectName sepID;
/*     */   private String contextRoot;
/*     */   private String[] virtualHosts;
/*     */   private String urlPattern;
/*     */   private String transportGuarantee;
/*     */   private boolean secureWSDLAccess;
/*     */ 
/*     */   public ServerEndpointMetaData(ServiceMetaData service, Endpoint endpoint, QName portName, QName portTypeName, EndpointMetaData.Type type)
/*     */   {
/*  78 */     super(service, portName, portTypeName, type);
/*  79 */     this.endpoint = endpoint;
/*     */ 
/*  81 */     this.configName = "Standard Endpoint";
/*  82 */     if (type == EndpointMetaData.Type.JAXRPC)
/*  83 */       this.configFile = "META-INF/standard-jaxrpc-endpoint-config.xml";
/*     */     else
/*  85 */       this.configFile = "META-INF/standard-jaxws-endpoint-config.xml";
/*     */   }
/*     */ 
/*     */   public Endpoint getEndpoint()
/*     */   {
/*  90 */     return this.endpoint;
/*     */   }
/*     */ 
/*     */   public void setEndpoint(Endpoint endpoint)
/*     */   {
/*  95 */     this.endpoint = endpoint;
/*     */   }
/*     */ 
/*     */   public String getLinkName()
/*     */   {
/* 100 */     return this.linkName;
/*     */   }
/*     */ 
/*     */   public void setLinkName(String linkName)
/*     */   {
/* 105 */     this.linkName = linkName;
/*     */   }
/*     */ 
/*     */   public String getPortComponentName()
/*     */   {
/* 110 */     return this.portComponentName;
/*     */   }
/*     */ 
/*     */   public void setPortComponentName(String portComponentName)
/*     */   {
/* 115 */     this.portComponentName = portComponentName;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointImplName()
/*     */   {
/* 120 */     return this.implName;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointImplName(String endpointImpl)
/*     */   {
/* 125 */     this.implName = endpointImpl;
/*     */   }
/*     */ 
/*     */   public ObjectName getServiceEndpointID()
/*     */   {
/* 130 */     return this.sepID;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointID(ObjectName endpointID)
/*     */   {
/* 135 */     this.sepID = endpointID;
/*     */   }
/*     */ 
/*     */   public String[] getVirtualHosts()
/*     */   {
/* 140 */     return this.virtualHosts;
/*     */   }
/*     */ 
/*     */   public void setVirtualHosts(String[] virtualHosts)
/*     */   {
/* 145 */     this.virtualHosts = virtualHosts;
/*     */   }
/*     */ 
/*     */   public String getContextRoot()
/*     */   {
/* 150 */     return this.contextRoot;
/*     */   }
/*     */ 
/*     */   public void setContextRoot(String contextRoot)
/*     */   {
/* 155 */     if ((contextRoot != null) && (!contextRoot.startsWith("/"))) {
/* 156 */       throw new IllegalArgumentException("context root should start with '/'");
/*     */     }
/* 158 */     this.contextRoot = contextRoot;
/*     */   }
/*     */ 
/*     */   public String getURLPattern()
/*     */   {
/* 163 */     return this.urlPattern;
/*     */   }
/*     */ 
/*     */   public void setURLPattern(String urlPattern)
/*     */   {
/* 168 */     if ((urlPattern != null) && (!urlPattern.startsWith("/"))) {
/* 169 */       throw new IllegalArgumentException("URL pattern should start with '/'");
/*     */     }
/* 171 */     this.urlPattern = urlPattern;
/*     */   }
/*     */ 
/*     */   public String getTransportGuarantee()
/*     */   {
/* 176 */     return this.transportGuarantee;
/*     */   }
/*     */ 
/*     */   public void setTransportGuarantee(String transportGuarantee)
/*     */   {
/* 181 */     this.transportGuarantee = transportGuarantee;
/*     */   }
/*     */ 
/*     */   public boolean isSecureWSDLAccess()
/*     */   {
/* 186 */     return this.secureWSDLAccess;
/*     */   }
/*     */ 
/*     */   public void setSecureWSDLAccess(boolean secureWSDLAccess)
/*     */   {
/* 191 */     this.secureWSDLAccess = secureWSDLAccess;
/*     */   }
/*     */ 
/*     */   public String getEndpointAddress()
/*     */   {
/* 197 */     return this.endpoint != null ? this.endpoint.getAddress() : null;
/*     */   }
/*     */ 
/*     */   public void setEndpointAddress(String endpointAddress)
/*     */   {
/* 203 */     if (this.endpoint == null) {
/* 204 */       throw new IllegalStateException("Endpoint not available");
/*     */     }
/* 206 */     this.endpoint.setAddress(endpointAddress);
/*     */   }
/*     */ 
/*     */   public Collection<BindingCustomization> getBindingCustomizations()
/*     */   {
/* 215 */     List list = new ArrayList();
/* 216 */     for (Iterator i$ = this.endpoint.getAttachments().iterator(); i$.hasNext(); ) { Object att = i$.next();
/*     */ 
/* 218 */       if ((att instanceof BindingCustomization))
/* 219 */         list.add((BindingCustomization)att);
/*     */     }
/* 221 */     return list;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 226 */     StringBuilder buffer = new StringBuilder("\nServerEndpointMetaData:");
/* 227 */     buffer.append("\n type=").append(getType());
/* 228 */     buffer.append("\n qname=").append(getPortName());
/* 229 */     buffer.append("\n id=").append(getServiceEndpointID().getCanonicalName());
/* 230 */     buffer.append("\n address=").append(getEndpointAddress());
/* 231 */     buffer.append("\n binding=").append(getBindingId());
/* 232 */     buffer.append("\n linkName=").append(getLinkName());
/* 233 */     buffer.append("\n implName=").append(getServiceEndpointImplName());
/* 234 */     buffer.append("\n seiName=").append(getServiceEndpointInterfaceName());
/* 235 */     buffer.append("\n serviceMode=").append(getServiceMode());
/* 236 */     buffer.append("\n portComponentName=").append(getPortComponentName());
/* 237 */     buffer.append("\n contextRoot=").append(getContextRoot());
/* 238 */     buffer.append("\n urlPattern=").append(getURLPattern());
/* 239 */     buffer.append("\n configFile=").append(getConfigFile());
/* 240 */     buffer.append("\n configName=").append(getConfigName());
/* 241 */     buffer.append("\n authMethod=").append(getAuthMethod());
/* 242 */     buffer.append("\n transportGuarantee=").append(getTransportGuarantee());
/* 243 */     buffer.append("\n secureWSDLAccess=").append(isSecureWSDLAccess());
/* 244 */     buffer.append("\n properties=").append(getProperties());
/*     */ 
/* 246 */     for (OperationMetaData opMetaData : getOperations())
/*     */     {
/* 248 */       buffer.append("\n").append(opMetaData);
/*     */     }
/* 250 */     for (HandlerMetaData hdlMetaData : getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL))
/*     */     {
/* 252 */       buffer.append("\n").append(hdlMetaData);
/*     */     }
/* 254 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.ServerEndpointMetaData
 * JD-Core Version:    0.6.0
 */