/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class ServiceEndpointInterfaceMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3336973427288868587L;
/*     */   private JavaWsdlMapping javaWsdlMapping;
/*     */   private String serviceEndpointInterface;
/*     */   private QName wsdlPortType;
/*     */   private QName wsdlBinding;
/*  53 */   private List serviceEndpointMethodMappings = new ArrayList();
/*     */ 
/*     */   public ServiceEndpointInterfaceMapping(JavaWsdlMapping javaWsdlMapping)
/*     */   {
/*  57 */     this.javaWsdlMapping = javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/*  62 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointInterface()
/*     */   {
/*  67 */     return this.serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointInterface(String serviceEndpointInterface)
/*     */   {
/*  72 */     this.serviceEndpointInterface = serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public QName getWsdlPortType()
/*     */   {
/*  77 */     return this.wsdlPortType;
/*     */   }
/*     */ 
/*     */   public void setWsdlPortType(QName wsdlPortType)
/*     */   {
/*  82 */     this.wsdlPortType = wsdlPortType;
/*     */   }
/*     */ 
/*     */   public QName getWsdlBinding()
/*     */   {
/*  87 */     return this.wsdlBinding;
/*     */   }
/*     */ 
/*     */   public void setWsdlBinding(QName wsdlBinding)
/*     */   {
/*  92 */     this.wsdlBinding = wsdlBinding;
/*     */   }
/*     */ 
/*     */   public ServiceEndpointMethodMapping[] getServiceEndpointMethodMappings()
/*     */   {
/*  97 */     ServiceEndpointMethodMapping[] arr = new ServiceEndpointMethodMapping[this.serviceEndpointMethodMappings.size()];
/*  98 */     this.serviceEndpointMethodMappings.toArray(arr);
/*  99 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addServiceEndpointMethodMapping(ServiceEndpointMethodMapping serviceEndpointMethodMapping)
/*     */   {
/* 104 */     this.serviceEndpointMethodMappings.add(serviceEndpointMethodMapping);
/*     */   }
/*     */ 
/*     */   public ServiceEndpointMethodMapping getServiceEndpointMethodMappingByWsdlOperation(String wsdlOperation)
/*     */   {
/* 109 */     ServiceEndpointMethodMapping semMapping = null;
/*     */ 
/* 111 */     Iterator it = this.serviceEndpointMethodMappings.iterator();
/* 112 */     while (it.hasNext())
/*     */     {
/* 114 */       ServiceEndpointMethodMapping aux = (ServiceEndpointMethodMapping)it.next();
/* 115 */       if (aux.getWsdlOperation().equals(wsdlOperation))
/* 116 */         semMapping = aux;
/*     */     }
/* 118 */     return semMapping;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 123 */     StringBuffer sb = new StringBuffer();
/* 124 */     sb.append("<service-endpoint-interface-mapping><service-endpoint-interface>");
/* 125 */     sb.append(this.serviceEndpointInterface).append("</service-endpoint-interface>");
/* 126 */     sb.append("<wsdl-port-type xmlns:").append(this.wsdlPortType.getPrefix()).append("='");
/* 127 */     sb.append(this.wsdlPortType.getNamespaceURI()).append("'>").append(this.wsdlPortType.getPrefix());
/* 128 */     sb.append(":").append(this.wsdlPortType.getLocalPart()).append("</wsdl-port-type>");
/*     */ 
/* 130 */     sb.append("<wsdl-binding xmlns:").append(this.wsdlBinding.getPrefix()).append("='");
/* 131 */     sb.append(this.wsdlBinding.getNamespaceURI()).append("'>").append(this.wsdlBinding.getPrefix());
/* 132 */     sb.append(":").append(this.wsdlBinding.getLocalPart()).append("</wsdl-binding>");
/*     */ 
/* 134 */     Iterator iter = this.serviceEndpointMethodMappings.iterator();
/* 135 */     while ((iter != null) && (iter.hasNext()))
/* 136 */       sb.append(((ServiceEndpointMethodMapping)iter.next()).serialize());
/* 137 */     sb.append("</service-endpoint-interface-mapping>");
/* 138 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping
 * JD-Core Version:    0.6.0
 */