/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JavaWsdlMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -142671631068024054L;
/*  46 */   private static Logger log = Logger.getLogger(JavaWsdlMapping.class);
/*     */ 
/*  49 */   private List packageMappings = new ArrayList();
/*     */ 
/*  51 */   private List javaXmlTypeMappings = new ArrayList();
/*     */ 
/*  53 */   private List exceptionMappings = new ArrayList();
/*     */ 
/*  55 */   private List serviceInterfaceMappings = new ArrayList();
/*     */ 
/*  57 */   private List serviceEndpointInterfaceMappings = new ArrayList();
/*     */ 
/*     */   public PackageMapping[] getPackageMappings()
/*     */   {
/*  61 */     PackageMapping[] arr = new PackageMapping[this.packageMappings.size()];
/*  62 */     this.packageMappings.toArray(arr);
/*  63 */     return arr;
/*     */   }
/*     */ 
/*     */   public JavaXmlTypeMapping[] getJavaXmlTypeMappings()
/*     */   {
/*  68 */     JavaXmlTypeMapping[] arr = new JavaXmlTypeMapping[this.javaXmlTypeMappings.size()];
/*  69 */     this.javaXmlTypeMappings.toArray(arr);
/*  70 */     return arr;
/*     */   }
/*     */ 
/*     */   public ExceptionMapping[] getExceptionMappings()
/*     */   {
/*  75 */     ExceptionMapping[] arr = new ExceptionMapping[this.exceptionMappings.size()];
/*  76 */     this.exceptionMappings.toArray(arr);
/*  77 */     return arr;
/*     */   }
/*     */ 
/*     */   public ServiceInterfaceMapping[] getServiceInterfaceMappings()
/*     */   {
/*  82 */     ServiceInterfaceMapping[] arr = new ServiceInterfaceMapping[this.serviceInterfaceMappings.size()];
/*  83 */     this.serviceInterfaceMappings.toArray(arr);
/*  84 */     return arr;
/*     */   }
/*     */ 
/*     */   public ServiceEndpointInterfaceMapping[] getServiceEndpointInterfaceMappings()
/*     */   {
/*  89 */     ServiceEndpointInterfaceMapping[] arr = new ServiceEndpointInterfaceMapping[this.serviceEndpointInterfaceMappings.size()];
/*  90 */     this.serviceEndpointInterfaceMappings.toArray(arr);
/*  91 */     return arr;
/*     */   }
/*     */ 
/*     */   public String getPackageNameForNamespaceURI(String nsURI)
/*     */   {
/* 100 */     String packageStr = null;
/* 101 */     for (int i = 0; (packageStr == null) && (i < this.packageMappings.size()); i++)
/*     */     {
/* 103 */       PackageMapping mapping = (PackageMapping)this.packageMappings.get(i);
/* 104 */       if (mapping.getNamespaceURI().equals(nsURI))
/* 105 */         packageStr = mapping.getPackageType();
/*     */     }
/* 107 */     return packageStr;
/*     */   }
/*     */ 
/*     */   public JavaXmlTypeMapping getTypeMappingForQName(QName xmlType)
/*     */   {
/* 114 */     JavaXmlTypeMapping typeMapping = null;
/*     */ 
/* 116 */     if (xmlType != null)
/*     */     {
/* 119 */       Iterator it = this.javaXmlTypeMappings.iterator();
/* 120 */       while ((typeMapping == null) && (it.hasNext()))
/*     */       {
/* 122 */         JavaXmlTypeMapping mapping = (JavaXmlTypeMapping)it.next();
/* 123 */         if (xmlType.equals(mapping.getRootTypeQName())) {
/* 124 */           typeMapping = mapping;
/*     */         }
/*     */       }
/*     */ 
/* 128 */       it = this.javaXmlTypeMappings.iterator();
/* 129 */       while ((typeMapping == null) && (it.hasNext()))
/*     */       {
/* 131 */         JavaXmlTypeMapping mapping = (JavaXmlTypeMapping)it.next();
/* 132 */         QName anonymousQName = mapping.getAnonymousTypeQName();
/* 133 */         if (anonymousQName != null)
/*     */         {
/* 135 */           if (xmlType.getNamespaceURI().equals(anonymousQName.getNamespaceURI()))
/*     */           {
/* 137 */             String localPart = xmlType.getLocalPart();
/* 138 */             if (anonymousQName.getLocalPart().equals(localPart))
/* 139 */               typeMapping = mapping;
/* 140 */             if (anonymousQName.getLocalPart().equals(">" + localPart)) {
/* 141 */               typeMapping = mapping;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 146 */       if (typeMapping == null) {
/* 147 */         log.warn("Cannot find jaxrpc-mapping for type: " + xmlType);
/*     */       }
/*     */     }
/* 150 */     return typeMapping;
/*     */   }
/*     */ 
/*     */   public ExceptionMapping getExceptionMappingForMessageQName(QName wsdlMessage)
/*     */   {
/* 157 */     ExceptionMapping exMapping = null;
/*     */ 
/* 159 */     if (wsdlMessage != null)
/*     */     {
/* 161 */       Iterator it = this.exceptionMappings.iterator();
/* 162 */       while (it.hasNext())
/*     */       {
/* 164 */         ExceptionMapping mapping = (ExceptionMapping)it.next();
/* 165 */         if (wsdlMessage.equals(mapping.getWsdlMessage())) {
/* 166 */           exMapping = mapping;
/*     */         }
/*     */       }
/*     */     }
/* 170 */     return exMapping;
/*     */   }
/*     */ 
/*     */   public ExceptionMapping getExceptionMappingForExceptionType(String javaType)
/*     */   {
/* 177 */     ExceptionMapping exMapping = null;
/*     */ 
/* 179 */     if (javaType != null)
/*     */     {
/* 181 */       Iterator it = this.exceptionMappings.iterator();
/* 182 */       while (it.hasNext())
/*     */       {
/* 184 */         ExceptionMapping mapping = (ExceptionMapping)it.next();
/* 185 */         if (javaType.equals(mapping.getExceptionType())) {
/* 186 */           exMapping = mapping;
/*     */         }
/*     */       }
/*     */     }
/* 190 */     return exMapping;
/*     */   }
/*     */ 
/*     */   public QName getPortTypeQNameForServiceEndpointInterface(String seiName)
/*     */   {
/* 197 */     QName portTypeQName = null;
/*     */ 
/* 199 */     ServiceEndpointInterfaceMapping[] seiMappings = getServiceEndpointInterfaceMappings();
/* 200 */     for (int i = 0; i < seiMappings.length; i++)
/*     */     {
/* 202 */       ServiceEndpointInterfaceMapping aux = seiMappings[i];
/* 203 */       if (aux.getServiceEndpointInterface().equals(seiName)) {
/* 204 */         portTypeQName = aux.getWsdlPortType();
/*     */       }
/*     */     }
/* 207 */     return portTypeQName;
/*     */   }
/*     */ 
/*     */   public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMappingByPortType(QName portType)
/*     */   {
/* 214 */     ServiceEndpointInterfaceMapping seiMapping = null;
/*     */ 
/* 216 */     ServiceEndpointInterfaceMapping[] seiMappings = getServiceEndpointInterfaceMappings();
/* 217 */     for (int i = 0; (seiMapping == null) && (i < seiMappings.length); i++)
/*     */     {
/* 219 */       ServiceEndpointInterfaceMapping aux = seiMappings[i];
/* 220 */       if (aux.getWsdlPortType().equals(portType)) {
/* 221 */         seiMapping = aux;
/*     */       }
/*     */     }
/* 224 */     return seiMapping;
/*     */   }
/*     */ 
/*     */   public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping(String seiName)
/*     */   {
/* 231 */     ServiceEndpointInterfaceMapping seiMapping = null;
/*     */ 
/* 233 */     ServiceEndpointInterfaceMapping[] seiMappings = getServiceEndpointInterfaceMappings();
/* 234 */     for (int i = 0; (seiMapping == null) && (i < seiMappings.length); i++)
/*     */     {
/* 236 */       ServiceEndpointInterfaceMapping aux = seiMappings[i];
/* 237 */       if (aux.getServiceEndpointInterface().equals(seiName)) {
/* 238 */         seiMapping = aux;
/*     */       }
/*     */     }
/* 241 */     return seiMapping;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 251 */     StringBuffer sb = new StringBuffer();
/*     */ 
/* 253 */     sb.append("<java-wsdl-mapping version='1.1' ").append("xmlns='http://java.sun.com/xml/ns/j2ee' ");
/* 254 */     sb.append("xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' ");
/* 255 */     sb.append("xsi:schemaLocation='http://java.sun.com/xml/ns/j2ee ");
/* 256 */     sb.append("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd'>");
/*     */ 
/* 258 */     Iterator piter = this.packageMappings.iterator();
/* 259 */     while ((piter != null) && (piter.hasNext())) {
/* 260 */       sb.append(((PackageMapping)piter.next()).serialize());
/*     */     }
/* 262 */     Iterator jxiter = this.javaXmlTypeMappings.iterator();
/* 263 */     while (jxiter.hasNext()) {
/* 264 */       sb.append(((JavaXmlTypeMapping)jxiter.next()).serialize());
/*     */     }
/* 266 */     for (Iterator i = this.exceptionMappings.iterator(); i.hasNext(); ) {
/* 267 */       sb.append(((ExceptionMapping)i.next()).serialize());
/*     */     }
/*     */ 
/* 270 */     int lenSIM = this.serviceInterfaceMappings.size();
/* 271 */     for (int i = 0; i < lenSIM; i++)
/*     */     {
/* 273 */       ServiceInterfaceMapping sim = (ServiceInterfaceMapping)this.serviceInterfaceMappings.get(i);
/* 274 */       sb.append(sim.serialize());
/* 275 */       ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)this.serviceEndpointInterfaceMappings.get(i);
/* 276 */       sb.append(seim.serialize());
/*     */     }
/*     */ 
/* 279 */     int lenSEI = this.serviceEndpointInterfaceMappings.size();
/* 280 */     for (int i = lenSIM; i < lenSEI; i++)
/*     */     {
/* 282 */       ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)this.serviceEndpointInterfaceMappings.get(i);
/* 283 */       sb.append(seim.serialize());
/*     */     }
/*     */ 
/* 286 */     sb.append("</java-wsdl-mapping>");
/*     */ 
/* 288 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public void addPackageMapping(PackageMapping packageMapping)
/*     */   {
/* 295 */     this.packageMappings.add(packageMapping);
/*     */   }
/*     */ 
/*     */   public void addJavaXmlTypeMappings(JavaXmlTypeMapping typeMapping)
/*     */   {
/* 300 */     this.javaXmlTypeMappings.add(typeMapping);
/*     */   }
/*     */ 
/*     */   public void addExceptionMappings(ExceptionMapping exceptionMapping)
/*     */   {
/* 305 */     this.exceptionMappings.add(exceptionMapping);
/*     */   }
/*     */ 
/*     */   public void addServiceInterfaceMappings(ServiceInterfaceMapping serviceInterfaceMapping)
/*     */   {
/* 310 */     this.serviceInterfaceMappings.add(serviceInterfaceMapping);
/*     */   }
/*     */ 
/*     */   public void addServiceEndpointInterfaceMappings(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping)
/*     */   {
/* 315 */     this.serviceEndpointInterfaceMappings.add(serviceEndpointInterfaceMapping);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping
 * JD-Core Version:    0.6.0
 */