/*     */ package org.jboss.ws.metadata.config.binding;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.config.EndpointProperty;
/*     */ import org.jboss.ws.metadata.config.jaxws.ClientConfigJAXWS;
/*     */ import org.jboss.ws.metadata.config.jaxws.CommonConfigJAXWS;
/*     */ import org.jboss.ws.metadata.config.jaxws.ConfigRootJAXWS;
/*     */ import org.jboss.ws.metadata.config.jaxws.EndpointConfigJAXWS;
/*     */ import org.jboss.ws.metadata.config.jaxws.HandlerChainsConfigJAXWS;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.HandlerChainsObjectFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class OMFactoryJAXWS extends HandlerChainsObjectFactory
/*     */ {
/*  48 */   private final Logger log = Logger.getLogger(OMFactoryJAXWS.class);
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  52 */     return new ConfigRootJAXWS();
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  57 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(ConfigRootJAXWS config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  65 */     this.log.trace("WSConfig newChild: " + localName);
/*  66 */     if ("endpoint-config".equals(localName))
/*     */     {
/*  68 */       EndpointConfigJAXWS wsEndpointConfig = new EndpointConfigJAXWS();
/*  69 */       config.getEndpointConfig().add(wsEndpointConfig);
/*  70 */       return wsEndpointConfig;
/*     */     }
/*  72 */     if ("client-config".equals(localName))
/*     */     {
/*  74 */       ClientConfigJAXWS clientConfig = new ClientConfigJAXWS();
/*  75 */       config.getClientConfig().add(clientConfig);
/*  76 */       return clientConfig;
/*     */     }
/*  78 */     return null;
/*     */   }
/*     */ 
/*     */   public void setValue(CommonConfigJAXWS commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/*  86 */     if (this.log.isTraceEnabled()) {
/*  87 */       this.log.trace("CommonConfig setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*  89 */     if (localName.equals("config-name"))
/*  90 */       commonConfig.setConfigName(value);
/*  91 */     if (localName.equals("feature")) {
/*  92 */       commonConfig.setFeature(value, true);
/*     */     }
/*  94 */     if ("property-name".equals(localName))
/*     */     {
/*  96 */       commonConfig.addProperty(value, null);
/*     */     }
/*  98 */     else if ("property-value".equals(localName))
/*     */     {
/* 100 */       int lastEntry = commonConfig.getProperties().isEmpty() ? 0 : commonConfig.getProperties().size() - 1;
/* 101 */       EndpointProperty p = (EndpointProperty)commonConfig.getProperties().get(lastEntry);
/* 102 */       p.value = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(CommonConfigJAXWS commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 111 */     this.log.trace("CommonConfig newChild: " + localName);
/*     */ 
/* 113 */     if ("pre-handler-chains".equals(localName))
/*     */     {
/* 115 */       HandlerChainsConfigJAXWS preHandlerChains = new HandlerChainsConfigJAXWS();
/* 116 */       commonConfig.setPreHandlerChains(preHandlerChains);
/* 117 */       return preHandlerChains;
/*     */     }
/* 119 */     if ("post-handler-chains".equals(localName))
/*     */     {
/* 121 */       HandlerChainsConfigJAXWS postHandlerChains = new HandlerChainsConfigJAXWS();
/* 122 */       commonConfig.setPostHandlerChains(postHandlerChains);
/* 123 */       return postHandlerChains;
/*     */     }
/*     */ 
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(HandlerChainsConfigJAXWS handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 134 */     this.log.trace("WSHandlerChainsConfig newChild: " + localName);
/*     */ 
/* 136 */     if ("handler-chain".equals(localName))
/*     */     {
/* 138 */       UnifiedHandlerChainMetaData handlerChain = new UnifiedHandlerChainMetaData(null);
/* 139 */       handlerChains.getHandlerChains().add(handlerChain);
/* 140 */       return handlerChain;
/*     */     }
/* 142 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.binding.OMFactoryJAXWS
 * JD-Core Version:    0.6.0
 */