/*     */ package org.jboss.ws.metadata.config;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public abstract class CommonConfig
/*     */ {
/*     */   private String configName;
/*  44 */   private List<URI> features = new ArrayList();
/*  45 */   private List<EndpointProperty> properties = new ArrayList();
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/*  49 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/*  54 */     this.configName = configName;
/*     */   }
/*     */   public abstract List<HandlerMetaData> getHandlers(EndpointMetaData paramEndpointMetaData, UnifiedHandlerMetaData.HandlerType paramHandlerType);
/*     */ 
/*     */   public boolean hasFeature(URI type) {
/*  60 */     return this.features.contains(type);
/*     */   }
/*     */ 
/*     */   public boolean hasFeature(String uri)
/*     */   {
/*  65 */     return hasFeature(nameToURI(uri));
/*     */   }
/*     */ 
/*     */   public void setFeature(String type, boolean enabled)
/*     */   {
/*  70 */     if (enabled) {
/*  71 */       this.features.add(nameToURI(type));
/*     */     }
/*     */     else
/*  74 */       this.features.remove(nameToURI(type));
/*     */   }
/*     */ 
/*     */   public void addProperty(String name, String value)
/*     */   {
/*  79 */     EndpointProperty p = new EndpointProperty();
/*  80 */     p.name = nameToURI(name);
/*  81 */     p.value = value;
/*  82 */     this.properties.add(p);
/*     */   }
/*     */ 
/*     */   public String getProperty(String name)
/*     */   {
/*  87 */     String value = null;
/*  88 */     URI uri = nameToURI(name);
/*     */ 
/*  90 */     for (EndpointProperty wsp : this.properties)
/*     */     {
/*  92 */       if (wsp.name.equals(uri))
/*     */       {
/*  94 */         value = wsp.value;
/*  95 */         break;
/*     */       }
/*     */     }
/*  98 */     return value;
/*     */   }
/*     */ 
/*     */   public List<EndpointProperty> getProperties() {
/* 102 */     return this.properties;
/*     */   }
/*     */ 
/*     */   private static URI nameToURI(String name)
/*     */   {
/* 107 */     URI uri = null;
/*     */     try {
/* 109 */       uri = new URI(name);
/*     */     } catch (URISyntaxException e) {
/* 111 */       throw new IllegalArgumentException(e.getMessage());
/*     */     }
/* 113 */     return uri;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.CommonConfig
 * JD-Core Version:    0.6.0
 */