/*     */ package org.jboss.ws.metadata.builder.jaxws;
/*     */ 
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.ws.WebServiceProvider;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.annotation.EndpointConfig;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.wsf.spi.annotation.WebContext;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment.DeploymentType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
/*     */ 
/*     */ public abstract class JAXWSServerMetaDataBuilder extends JAXWSMetaDataBuilder
/*     */ {
/*     */   static void setupProviderOrWebService(ArchiveDeployment dep, UnifiedMetaData umd, Class<?> beanClass, String beanName)
/*     */     throws Exception
/*     */   {
/*  49 */     if (beanClass.isAnnotationPresent(WebService.class))
/*     */     {
/*  51 */       JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
/*  52 */       builder.buildWebServiceMetaData(dep, umd, beanClass, beanName);
/*     */     }
/*  54 */     else if (beanClass.isAnnotationPresent(WebServiceProvider.class))
/*     */     {
/*  56 */       JAXWSProviderMetaDataBuilder builder = new JAXWSProviderMetaDataBuilder();
/*  57 */       builder.buildProviderMetaData(dep, umd, beanClass, beanName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processEndpointConfig(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> wsClass, String linkName)
/*     */   {
/*  63 */     String configName = null;
/*  64 */     String configFile = null;
/*     */ 
/*  66 */     EndpointConfig anEndpointConfig = (EndpointConfig)wsClass.getAnnotation(EndpointConfig.class);
/*  67 */     if (anEndpointConfig != null)
/*     */     {
/*  69 */       if (anEndpointConfig.configName().length() > 0) {
/*  70 */         configName = anEndpointConfig.configName();
/*     */       }
/*  72 */       if (anEndpointConfig.configFile().length() > 0) {
/*  73 */         configFile = anEndpointConfig.configFile();
/*     */       }
/*     */     }
/*  76 */     JSEArchiveMetaData jseMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
/*  77 */     if (jseMetaData != null)
/*     */     {
/*  79 */       if (jseMetaData.getConfigName() != null)
/*  80 */         configName = jseMetaData.getConfigName();
/*  81 */       if (jseMetaData.getConfigFile() != null) {
/*  82 */         configFile = jseMetaData.getConfigFile();
/*     */       }
/*     */     }
/*  85 */     EJBArchiveMetaData ejbMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
/*  86 */     if (ejbMetaData != null)
/*     */     {
/*  88 */       if (ejbMetaData.getConfigName() != null)
/*  89 */         configName = ejbMetaData.getConfigName();
/*  90 */       if (ejbMetaData.getConfigFile() != null) {
/*  91 */         configFile = ejbMetaData.getConfigFile();
/*     */       }
/*     */     }
/*  94 */     if ((configName != null) || (configFile != null))
/*  95 */       sepMetaData.setConfigName(configName, configFile);
/*     */   }
/*     */ 
/*     */   protected void processWebContext(Deployment dep, Class<?> wsClass, String linkName, ServerEndpointMetaData sepMetaData)
/*     */   {
/* 100 */     WebContext anWebContext = (WebContext)wsClass.getAnnotation(WebContext.class);
/*     */ 
/* 102 */     if (anWebContext == null) {
/* 103 */       return;
/*     */     }
/* 105 */     boolean isJSEEndpoint = dep.getType() == Deployment.DeploymentType.JAXWS_JSE;
/*     */ 
/* 108 */     if (anWebContext.contextRoot().length() > 0)
/*     */     {
/* 110 */       if (isJSEEndpoint)
/*     */       {
/* 112 */         log.warn("@WebContext.contextRoot is only valid on EJB endpoints");
/*     */       }
/*     */       else
/*     */       {
/* 116 */         String contextRoot = anWebContext.contextRoot();
/* 117 */         if (!contextRoot.startsWith("/")) {
/* 118 */           contextRoot = "/" + contextRoot;
/*     */         }
/* 120 */         sepMetaData.setContextRoot(contextRoot);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 125 */     if (anWebContext.urlPattern().length() > 0)
/*     */     {
/* 127 */       if (isJSEEndpoint)
/*     */       {
/* 129 */         log.warn("@WebContext.urlPattern is only valid on EJB endpoints");
/*     */       }
/*     */       else
/*     */       {
/* 133 */         String urlPattern = anWebContext.urlPattern();
/* 134 */         sepMetaData.setURLPattern(urlPattern);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 139 */     if (anWebContext.authMethod().length() > 0)
/*     */     {
/* 141 */       if (isJSEEndpoint)
/*     */       {
/* 143 */         log.warn("@WebContext.authMethod is only valid on EJB endpoints");
/*     */       }
/*     */       else
/*     */       {
/* 147 */         String authMethod = anWebContext.authMethod();
/* 148 */         sepMetaData.setAuthMethod(authMethod);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 153 */     if (anWebContext.transportGuarantee().length() > 0)
/*     */     {
/* 155 */       if (isJSEEndpoint)
/*     */       {
/* 157 */         log.warn("@WebContext.transportGuarantee is only valid on EJB endpoints");
/*     */       }
/*     */       else
/*     */       {
/* 161 */         String transportGuarantee = anWebContext.transportGuarantee();
/* 162 */         sepMetaData.setTransportGuarantee(transportGuarantee);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 167 */     sepMetaData.setSecureWSDLAccess(anWebContext.secureWSDLAccess());
/*     */ 
/* 170 */     String[] virtualHosts = anWebContext.virtualHosts();
/* 171 */     if (((virtualHosts != null ? 1 : 0) & (virtualHosts.length > 0 ? 1 : 0)) != 0)
/*     */     {
/* 173 */       sepMetaData.setVirtualHosts(virtualHosts);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder
 * JD-Core Version:    0.6.0
 */