/*     */ package org.jboss.ws.metadata.builder.jaxrpc;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.rpc.encoding.TypeMappingRegistry;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.EncodedTypeMapping;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.core.jaxrpc.TypeMappingRegistryImpl;
/*     */ import org.jboss.ws.core.jaxrpc.UnqualifiedFaultException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.ws.extensions.xop.jaxrpc.XOPScanner;
/*     */ import org.jboss.ws.metadata.builder.MetaDataBuilder;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem.Direction;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public abstract class JAXRPCMetaDataBuilder extends MetaDataBuilder
/*     */ {
/*  98 */   final Logger log = Logger.getLogger(JAXRPCMetaDataBuilder.class);
/*     */ 
/*     */   protected QName lookupSchemaType(WSDLInterfaceOperation operation, QName element)
/*     */   {
/* 102 */     WSDLDefinitions wsdlDefinitions = operation.getWsdlInterface().getWsdlDefinitions();
/* 103 */     WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
/* 104 */     return wsdlTypes.getXMLType(element);
/*     */   }
/*     */ 
/*     */   protected void setupTypesMetaData(ServiceMetaData serviceMetaData)
/*     */   {
/* 109 */     WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/* 110 */     JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
/* 111 */     TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
/*     */ 
/* 114 */     if (wsdlDefinitions != null)
/*     */     {
/* 116 */       WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
/* 117 */       typesMetaData.setSchemaModel(WSDLUtils.getSchemaModel(wsdlTypes));
/*     */     }
/*     */ 
/* 121 */     if (javaWsdlMapping != null)
/*     */     {
/* 123 */       for (JavaXmlTypeMapping xmlTypeMapping : javaWsdlMapping.getJavaXmlTypeMappings())
/*     */       {
/* 125 */         String javaTypeName = xmlTypeMapping.getJavaType();
/* 126 */         String qnameScope = xmlTypeMapping.getQnameScope();
/*     */ 
/* 128 */         QName xmlType = xmlTypeMapping.getRootTypeQName();
/* 129 */         QName anonymousXMLType = xmlTypeMapping.getAnonymousTypeQName();
/* 130 */         if ((xmlType == null) && (anonymousXMLType != null)) {
/* 131 */           xmlType = anonymousXMLType;
/*     */         }
/* 133 */         String nsURI = xmlType.getNamespaceURI();
/* 134 */         if (("http://www.w3.org/2001/XMLSchema".equals(nsURI)) || ("http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)))
/*     */           continue;
/* 136 */         TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
/* 137 */         tmMetaData.setQNameScope(qnameScope);
/* 138 */         typesMetaData.addTypeMapping(tmMetaData);
/*     */       }
/*     */ 
/* 142 */       for (ExceptionMapping exceptionMapping : javaWsdlMapping.getExceptionMappings())
/*     */       {
/* 144 */         QName xmlType = exceptionMapping.getWsdlMessage();
/* 145 */         String javaTypeName = exceptionMapping.getExceptionType();
/* 146 */         TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
/* 147 */         typesMetaData.addTypeMapping(tmMetaData);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint, ServiceEndpointInterfaceMapping seiMapping)
/*     */   {
/* 154 */     WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getInterface().getWsdlDefinitions();
/*     */ 
/* 157 */     WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
/* 158 */     for (WSDLInterfaceOperation wsdlOperation : wsdlInterface.getOperations())
/*     */     {
/* 160 */       QName opQName = wsdlOperation.getName();
/* 161 */       String opName = opQName.getLocalPart();
/*     */ 
/* 163 */       WSDLBindingOperation wsdlBindingOperation = wsdlOperation.getBindingOperation();
/* 164 */       if (wsdlBindingOperation == null) {
/* 165 */         this.log.warn("Could not locate binding operation for:" + opQName);
/*     */       }
/*     */ 
/* 169 */       String namespaceURI = wsdlBindingOperation.getNamespaceURI();
/* 170 */       if (namespaceURI != null) {
/* 171 */         opQName = new QName(namespaceURI, opName);
/*     */       }
/*     */ 
/* 174 */       String javaName = opName.substring(0, 1).toLowerCase() + opName.substring(1);
/* 175 */       ServiceEndpointMethodMapping seiMethodMapping = null;
/* 176 */       if (seiMapping != null)
/*     */       {
/* 178 */         epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
/*     */ 
/* 180 */         seiMethodMapping = seiMapping.getServiceEndpointMethodMappingByWsdlOperation(opName);
/* 181 */         if (seiMethodMapping == null) {
/* 182 */           throw new WSException("Cannot obtain method mapping for: " + opName);
/*     */         }
/* 184 */         javaName = seiMethodMapping.getJavaMethodName();
/*     */       }
/*     */ 
/* 187 */       OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
/* 188 */       epMetaData.addOperation(opMetaData);
/*     */ 
/* 191 */       String style = wsdlOperation.getStyle();
/* 192 */       epMetaData.setStyle("http://www.w3.org/2004/03/wsdl/style/iri".equals(style) ? Style.DOCUMENT : Style.RPC);
/*     */ 
/* 195 */       if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
/* 196 */         opMetaData.setOneWay(true);
/*     */       }
/*     */ 
/* 199 */       if (wsdlBindingOperation != null) {
/* 200 */         opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
/*     */       }
/*     */ 
/* 203 */       String encStyle = epMetaData.getEncodingStyle().toURI();
/* 204 */       TypeMappingRegistry tmRegistry = new TypeMappingRegistryImpl();
/* 205 */       TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
/*     */ 
/* 208 */       if (opMetaData.getStyle() == Style.RPC)
/*     */       {
/* 210 */         buildParameterMetaDataRpc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
/*     */       }
/*     */       else
/*     */       {
/* 214 */         buildParameterMetaDataDoc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
/*     */       }
/*     */ 
/* 218 */       buildFaultMetaData(opMetaData, wsdlOperation);
/*     */ 
/* 221 */       processOpMetaExtensions(opMetaData, wsdlOperation);
/*     */     }
/*     */   }
/*     */ 
/*     */   private ParameterMetaData buildInputParameter(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, String partName, QName xmlName, QName xmlType, int pos, boolean optional)
/*     */   {
/* 228 */     WSDLRPCSignatureItem item = wsdlOperation.getRpcSignatureitem(partName);
/* 229 */     if (item != null) {
/* 230 */       pos = item.getPosition();
/*     */     }
/* 232 */     String javaTypeName = typeMapping.getJavaTypeName(xmlType);
/* 233 */     boolean mapped = false;
/* 234 */     if (seiMethodMapping != null)
/*     */     {
/* 236 */       MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
/* 237 */       if (paramMapping != null)
/*     */       {
/* 239 */         javaTypeName = paramMapping.getParamType();
/* 240 */         pos = paramMapping.getParamPosition();
/* 241 */         mapped = true;
/*     */       }
/* 243 */       else if (!optional)
/*     */       {
/* 245 */         throw new WSException("Cannot obtain method parameter mapping for message part '" + partName + "' in wsdl operation: " + seiMethodMapping.getWsdlOperation());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 251 */     if ((!mapped) && (optional)) {
/* 252 */       return null;
/*     */     }
/* 254 */     JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
/* 255 */     if ((javaTypeName == null) && (javaWsdlMapping != null))
/*     */     {
/* 257 */       String packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI());
/* 258 */       if (packageName != null)
/*     */       {
/* 260 */         javaTypeName = packageName + "." + xmlType.getLocalPart();
/* 261 */         this.log.warn("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]");
/*     */       }
/*     */     }
/*     */ 
/* 265 */     if (javaTypeName == null) {
/* 266 */       throw new WSException("Cannot obtain java type mapping for: " + xmlType);
/*     */     }
/* 268 */     ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
/* 269 */     inMetaData.setPartName(partName);
/* 270 */     inMetaData.setIndex(pos);
/* 271 */     opMetaData.addParameter(inMetaData);
/*     */ 
/* 273 */     TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/*     */ 
/* 275 */     if (typesMetaData.getTypeMappingByXMLType(xmlType) == null)
/*     */     {
/* 277 */       String nsURI = xmlType.getNamespaceURI();
/* 278 */       if ((!"http://www.w3.org/2001/XMLSchema".equals(nsURI)) && (!"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)))
/*     */       {
/* 280 */         TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
/* 281 */         typesMetaData.addTypeMapping(tmMetaData);
/*     */       }
/*     */     }
/*     */ 
/* 285 */     return inMetaData;
/*     */   }
/*     */ 
/*     */   private ParameterMetaData buildOutputParameter(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, int pos, String partName, QName xmlName, QName xmlType, TypeMappingImpl typeMapping, boolean optional)
/*     */   {
/* 292 */     boolean hasReturnMapping = opMetaData.getReturnParameter() == null;
/*     */ 
/* 294 */     WSDLRPCSignatureItem item = wsdlOperation.getRpcSignatureitem(partName);
/* 295 */     if (item != null)
/*     */     {
/* 297 */       hasReturnMapping = item.getDirection() == WSDLRPCSignatureItem.Direction.RETURN;
/* 298 */       pos = item.getPosition();
/*     */     }
/*     */ 
/* 301 */     String javaTypeName = typeMapping.getJavaTypeName(xmlType);
/*     */ 
/* 303 */     boolean mapped = false;
/* 304 */     if (seiMethodMapping != null)
/*     */     {
/* 306 */       MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
/* 307 */       if (paramMapping != null)
/*     */       {
/* 309 */         javaTypeName = paramMapping.getParamType();
/* 310 */         pos = paramMapping.getParamPosition();
/* 311 */         hasReturnMapping = false;
/* 312 */         mapped = true;
/*     */       }
/*     */       else
/*     */       {
/* 316 */         WsdlReturnValueMapping returnMapping = seiMethodMapping.getWsdlReturnValueMapping();
/* 317 */         if (returnMapping != null)
/*     */         {
/* 319 */           String mappingPart = returnMapping.getWsdlMessagePartName();
/* 320 */           if ((mappingPart != null) && (partName.equals(mappingPart)))
/*     */           {
/* 322 */             javaTypeName = returnMapping.getMethodReturnValue();
/* 323 */             hasReturnMapping = true;
/* 324 */             mapped = true;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 331 */     if ((!mapped) && (optional)) {
/* 332 */       return null;
/*     */     }
/* 334 */     JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
/* 335 */     if ((javaTypeName == null) && (javaWsdlMapping != null))
/*     */     {
/* 337 */       String packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI());
/* 338 */       if (packageName != null)
/*     */       {
/* 340 */         javaTypeName = packageName + "." + xmlType.getLocalPart();
/* 341 */         this.log.warn("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]");
/*     */       }
/*     */     }
/*     */ 
/* 345 */     if (javaTypeName == null) {
/* 346 */       throw new WSException("Cannot obtain java type mapping for: " + xmlType);
/*     */     }
/* 348 */     ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
/* 349 */     outMetaData.setPartName(partName);
/*     */ 
/* 351 */     if (hasReturnMapping)
/*     */     {
/* 353 */       opMetaData.setReturnParameter(outMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 357 */       outMetaData.setIndex(pos);
/* 358 */       outMetaData.setMode(ParameterMode.OUT);
/* 359 */       opMetaData.addParameter(outMetaData);
/*     */     }
/*     */ 
/* 362 */     TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/*     */ 
/* 364 */     if (typesMetaData.getTypeMappingByXMLType(xmlType) == null)
/*     */     {
/* 366 */       String nsURI = xmlType.getNamespaceURI();
/* 367 */       if ((!"http://www.w3.org/2001/XMLSchema".equals(nsURI)) && (!"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)))
/*     */       {
/* 369 */         TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
/* 370 */         typesMetaData.addTypeMapping(tmMetaData);
/*     */       }
/*     */     }
/*     */ 
/* 374 */     setupSOAPArrayParameter(outMetaData);
/* 375 */     return outMetaData;
/*     */   }
/*     */ 
/*     */   private int processBindingParameters(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, WSDLBindingOperation bindingOperation, int wsdlPosition)
/*     */   {
/* 381 */     WSDLBindingOperationInput bindingInput = bindingOperation.getInputs()[0];
/* 382 */     for (WSDLSOAPHeader header : bindingInput.getSoapHeaders())
/*     */     {
/* 384 */       QName xmlName = header.getElement();
/* 385 */       QName xmlType = lookupSchemaType(wsdlOperation, xmlName);
/* 386 */       String partName = header.getPartName();
/*     */ 
/* 388 */       ParameterMetaData pmd = buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, !header.isIncludeInSignature());
/*     */ 
/* 390 */       if (pmd != null)
/* 391 */         pmd.setInHeader(true);
/*     */     }
/* 393 */     for (WSDLMIMEPart mimePart : bindingInput.getMimeParts())
/*     */     {
/* 395 */       String partName = mimePart.getPartName();
/* 396 */       QName xmlName = new QName(partName);
/* 397 */       QName xmlType = mimePart.getXmlType();
/*     */ 
/* 399 */       ParameterMetaData pmd = buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, false);
/* 400 */       pmd.setSwA(true);
/* 401 */       pmd.setMimeTypes(mimePart.getMimeTypes());
/*     */     }
/*     */ 
/* 404 */     return wsdlPosition;
/*     */   }
/*     */ 
/*     */   private int processBindingOutputParameters(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, WSDLBindingOperation bindingOperation, int wsdlPosition)
/*     */   {
/* 410 */     WSDLBindingOperationOutput bindingOutput = bindingOperation.getOutputs()[0];
/* 411 */     for (WSDLSOAPHeader header : bindingOutput.getSoapHeaders())
/*     */     {
/* 413 */       String partName = header.getPartName();
/* 414 */       QName xmlName = header.getElement();
/*     */ 
/* 416 */       ParameterMetaData outMetaData = opMetaData.getParameter(xmlName);
/* 417 */       if (outMetaData != null)
/*     */       {
/* 419 */         outMetaData.setMode(ParameterMode.INOUT);
/*     */       }
/*     */       else
/*     */       {
/* 423 */         QName xmlType = lookupSchemaType(wsdlOperation, xmlName);
/*     */ 
/* 425 */         ParameterMetaData pmd = buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, !header.isIncludeInSignature());
/*     */ 
/* 427 */         if (pmd != null)
/*     */         {
/* 429 */           pmd.setInHeader(true);
/* 430 */           if (opMetaData.getReturnParameter() != pmd) {
/* 431 */             wsdlPosition++;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 436 */     for (WSDLMIMEPart mimePart : bindingOutput.getMimeParts())
/*     */     {
/* 438 */       String partName = mimePart.getPartName();
/* 439 */       QName xmlName = new QName(partName);
/*     */ 
/* 441 */       ParameterMetaData outMetaData = opMetaData.getParameter(xmlName);
/* 442 */       if (outMetaData != null)
/*     */       {
/* 444 */         outMetaData.setMode(ParameterMode.INOUT);
/*     */       }
/*     */       else
/*     */       {
/* 448 */         QName xmlType = mimePart.getXmlType();
/*     */ 
/* 450 */         ParameterMetaData pmd = buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, false);
/* 451 */         pmd.setSwA(true);
/* 452 */         pmd.setMimeTypes(mimePart.getMimeTypes());
/*     */ 
/* 454 */         if (opMetaData.getReturnParameter() != pmd) {
/* 455 */           wsdlPosition++;
/*     */         }
/*     */       }
/*     */     }
/* 459 */     return wsdlPosition;
/*     */   }
/*     */ 
/*     */   private void setupSOAPArrayParameter(ParameterMetaData paramMetaData)
/*     */   {
/* 469 */     Use use = paramMetaData.getOperationMetaData().getUse();
/* 470 */     String xmlTypeLocalPart = paramMetaData.getXmlType().getLocalPart();
/* 471 */     if ((use == Use.ENCODED) && (xmlTypeLocalPart.indexOf("ArrayOf") >= 0))
/*     */     {
/* 473 */       paramMetaData.setSOAPArrayParam(true);
/*     */       try
/*     */       {
/* 476 */         String javaTypeName = paramMetaData.getJavaTypeName();
/*     */ 
/* 481 */         Class javaType = JavaUtils.loadJavaType(javaTypeName);
/* 482 */         Class compJavaType = javaType.getComponentType();
/*     */ 
/* 484 */         if (xmlTypeLocalPart.indexOf("ArrayOfArrayOf") >= 0) {
/* 485 */           compJavaType = compJavaType.getComponentType();
/*     */         }
/* 487 */         boolean isSoapEnc = xmlTypeLocalPart.toLowerCase().indexOf("soapenc") > 0;
/* 488 */         TypeMappingImpl typeMapping = isSoapEnc ? new EncodedTypeMapping() : new LiteralTypeMapping();
/* 489 */         QName compXMLType = typeMapping.getXMLType(compJavaType);
/*     */ 
/* 491 */         if (compXMLType != null)
/*     */         {
/* 493 */           boolean isBase64 = compXMLType.getLocalPart().startsWith("base64");
/* 494 */           if ((isBase64) && (xmlTypeLocalPart.toLowerCase().indexOf("hex") > 0)) {
/* 495 */             compXMLType = isSoapEnc ? Constants.TYPE_SOAP11_HEXBINARY : Constants.TYPE_LITERAL_HEXBINARY;
/*     */           }
/*     */         }
/* 498 */         paramMetaData.setSOAPArrayCompType(compXMLType);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupXOPAttachmentParameter(WSDLInterfaceOperation operation, ParameterMetaData paramMetaData)
/*     */   {
/* 509 */     QName xmlType = paramMetaData.getXmlType();
/*     */ 
/* 512 */     WSDLTypes wsdlTypes = operation.getWsdlInterface().getWsdlDefinitions().getWsdlTypes();
/* 513 */     JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlTypes);
/* 514 */     String localPart = xmlType.getLocalPart() != null ? xmlType.getLocalPart() : "";
/* 515 */     String ns = xmlType.getNamespaceURI() != null ? xmlType.getNamespaceURI() : "";
/* 516 */     XSTypeDefinition xsType = schemaModel.getTypeDefinition(localPart, ns);
/* 517 */     XOPScanner scanner = new XOPScanner();
/* 518 */     if (((scanner.findXOPTypeDef(xsType) != null ? 1 : 0) | ((localPart.equals("base64Binary")) && (ns.equals("http://www.w3.org/2001/XMLSchema")) ? 1 : 0)) != 0)
/*     */     {
/* 530 */       paramMetaData.setXOP(true);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Map<String, String> createVariableMappingMap(VariableMapping[] mappings)
/*     */   {
/* 540 */     HashMap map = new HashMap();
/* 541 */     if (mappings != null) {
/* 542 */       for (VariableMapping mapping : mappings)
/* 543 */         map.put(mapping.getXmlElementName(), mapping.getJavaVariableName());
/*     */     }
/* 545 */     return map;
/*     */   }
/*     */ 
/*     */   private void buildParameterMetaDataRpc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping)
/*     */   {
/* 551 */     this.log.trace("buildParameterMetaDataRpc: " + opMetaData.getQName());
/*     */ 
/* 553 */     WSDLBindingOperation bindingOperation = wsdlOperation.getBindingOperation();
/* 554 */     if (bindingOperation == null) {
/* 555 */       throw new WSException("Could not locate binding operation for:" + opMetaData.getQName());
/*     */     }
/*     */ 
/* 558 */     WSDLInterfaceOperationInput input = wsdlOperation.getInputs()[0];
/* 559 */     int wsdlPosition = 0;
/* 560 */     for (WSDLRPCPart part : input.getChildParts())
/*     */     {
/* 562 */       QName xmlType = part.getType();
/* 563 */       String partName = part.getName();
/* 564 */       QName xmlName = new QName(partName);
/*     */ 
/* 566 */       ParameterMetaData pmd = buildInputParameter(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, partName, xmlName, xmlType, wsdlPosition++, false);
/*     */ 
/* 568 */       setupXOPAttachmentParameter(wsdlOperation, pmd);
/* 569 */       setupSOAPArrayParameter(pmd);
/*     */     }
/*     */ 
/* 572 */     wsdlPosition = processBindingParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
/*     */ 
/* 574 */     WSDLInterfaceOperationOutput[] outputs = wsdlOperation.getOutputs();
/* 575 */     if (outputs.length > 0)
/*     */     {
/* 577 */       WSDLInterfaceOperationOutput output = outputs[0];
/* 578 */       for (WSDLRPCPart part : output.getChildParts())
/*     */       {
/* 580 */         String partName = part.getName();
/*     */ 
/* 582 */         ParameterMetaData outMetaData = opMetaData.getParameter(new QName(partName));
/* 583 */         if (outMetaData != null)
/*     */         {
/* 585 */           outMetaData.setMode(ParameterMode.INOUT);
/*     */         }
/*     */         else
/*     */         {
/* 589 */           QName xmlName = new QName(partName);
/* 590 */           QName xmlType = part.getType();
/*     */ 
/* 592 */           ParameterMetaData pmd = buildOutputParameter(opMetaData, wsdlOperation, seiMethodMapping, wsdlPosition, partName, xmlName, xmlType, typeMapping, false);
/* 593 */           if (opMetaData.getReturnParameter() != pmd) {
/* 594 */             wsdlPosition++;
/*     */           }
/* 596 */           setupXOPAttachmentParameter(wsdlOperation, pmd);
/* 597 */           setupSOAPArrayParameter(pmd);
/*     */         }
/*     */       }
/*     */ 
/* 601 */       processBindingOutputParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
/*     */     }
/* 603 */     else if (wsdlOperation.getPattern() != "http://www.w3.org/2004/08/wsdl/in-only")
/*     */     {
/* 605 */       throw new WSException("RPC style was missing an output, and was not an IN-ONLY MEP.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private int processDocElement(OperationMetaData operation, WSDLInterfaceOperation wsdlOperation, WSDLBindingOperation bindingOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, List<WrappedParameter> wrappedParameters, List<WrappedParameter> wrappedResponseParameters)
/*     */   {
/* 613 */     WSDLInterfaceOperationInput input = wsdlOperation.getInputs()[0];
/* 614 */     WSDLBindingOperationInput bindingInput = bindingOperation.getInputs()[0];
/*     */ 
/* 617 */     QName xmlName = input.getElement();
/* 618 */     QName xmlType = input.getXMLType();
/* 619 */     String javaTypeName = typeMapping.getJavaTypeName(xmlType);
/*     */ 
/* 621 */     TypesMetaData typesMetaData = operation.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/* 622 */     TypeMappingMetaData typeMetaData = typesMetaData.getTypeMappingByXMLType(xmlType);
/* 623 */     if (typeMetaData != null) {
/* 624 */       javaTypeName = typeMetaData.getJavaTypeName();
/*     */     }
/* 626 */     if (javaTypeName == null) {
/* 627 */       throw new WSException("Cannot obtain java type mapping for: " + xmlType);
/*     */     }
/*     */ 
/* 630 */     boolean isWrapped = isWrapped(seiMethodMapping, javaTypeName);
/* 631 */     operation.getEndpointMetaData().setParameterStyle(isWrapped ? SOAPBinding.ParameterStyle.WRAPPED : SOAPBinding.ParameterStyle.BARE);
/*     */ 
/* 633 */     ParameterMetaData inMetaData = new ParameterMetaData(operation, xmlName, xmlType, javaTypeName);
/* 634 */     operation.addParameter(inMetaData);
/*     */     int wsdlPosition;
/*     */     int wsdlPosition;
/* 637 */     if (inMetaData.getOperationMetaData().isDocumentWrapped())
/*     */     {
/* 639 */       if (seiMethodMapping == null) {
/* 640 */         throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
/*     */       }
/* 642 */       ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
/* 643 */       JavaXmlTypeMapping javaXmlTypeMapping = seiMapping.getJavaWsdlMapping().getTypeMappingForQName(xmlType);
/* 644 */       if (javaXmlTypeMapping == null) {
/* 645 */         throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
/*     */       }
/* 647 */       Map variableMap = createVariableMappingMap(javaXmlTypeMapping.getVariableMappings());
/* 648 */       for (MethodParamPartsMapping partMapping : seiMethodMapping.getMethodParamPartsMappings())
/*     */       {
/* 650 */         WsdlMessageMapping wsdlMessageMapping = partMapping.getWsdlMessageMapping();
/* 651 */         if (wsdlMessageMapping.isSoapHeader()) {
/*     */           continue;
/*     */         }
/* 654 */         if (wsdlMessageMapping == null) {
/* 655 */           throw new IllegalArgumentException("wsdl-message-message mapping required for document/literal wrapped");
/*     */         }
/* 657 */         String elementName = wsdlMessageMapping.getWsdlMessagePartName();
/*     */ 
/* 660 */         if (bindingInput.getMimePart(elementName) != null) {
/*     */           continue;
/*     */         }
/* 663 */         String variable = (String)variableMap.get(elementName);
/* 664 */         if (variable == null) {
/* 665 */           throw new IllegalArgumentException("Could not determine variable name for element: " + elementName);
/*     */         }
/* 667 */         WrappedParameter wrapped = new WrappedParameter(new QName(elementName), partMapping.getParamType(), variable, partMapping.getParamPosition());
/*     */ 
/* 669 */         String parameterMode = wsdlMessageMapping.getParameterMode();
/* 670 */         if ((parameterMode == null) || (parameterMode.length() < 2)) {
/* 671 */           throw new IllegalArgumentException("Invalid parameter mode for element: " + elementName);
/*     */         }
/* 673 */         if (!"OUT".equals(parameterMode))
/* 674 */           wrappedParameters.add(wrapped);
/* 675 */         if ("IN".equals(parameterMode))
/*     */           continue;
/* 677 */         wrapped.setHolder(true);
/*     */ 
/* 679 */         if ("INOUT".equals(parameterMode))
/* 680 */           wrapped = new WrappedParameter(wrapped);
/* 681 */         wrappedResponseParameters.add(wrapped);
/*     */       }
/*     */ 
/* 684 */       inMetaData.setWrappedParameters(wrappedParameters);
/* 685 */       wsdlPosition = wrappedParameters.size();
/*     */     }
/*     */     else
/*     */     {
/* 689 */       if (seiMethodMapping != null)
/*     */       {
/* 691 */         MethodParamPartsMapping part = seiMethodMapping.getMethodParamPartsMappingByPartName(input.getPartName());
/* 692 */         if (part != null)
/*     */         {
/* 694 */           inMetaData.setJavaTypeName(part.getParamType());
/* 695 */           inMetaData.setIndex(part.getParamPosition());
/*     */         }
/*     */       }
/*     */ 
/* 699 */       setupXOPAttachmentParameter(wsdlOperation, inMetaData);
/* 700 */       wsdlPosition = 1;
/*     */     }
/*     */ 
/* 703 */     return wsdlPosition;
/*     */   }
/*     */ 
/*     */   private boolean isWrapped(ServiceEndpointMethodMapping seiMethodMapping, String javaTypeName)
/*     */   {
/* 708 */     boolean isWrapParameters = seiMethodMapping != null ? seiMethodMapping.isWrappedElement() : false;
/* 709 */     this.log.trace("isWrapParameters based on wrapped-element: " + isWrapParameters);
/* 710 */     if ((!isWrapParameters) && (seiMethodMapping != null))
/*     */     {
/* 713 */       MethodParamPartsMapping[] partsMappings = seiMethodMapping.getMethodParamPartsMappings();
/* 714 */       if (partsMappings.length > 0)
/*     */       {
/* 716 */         List anyTypes = new ArrayList();
/* 717 */         anyTypes.add("javax.xml.soap.SOAPElement");
/* 718 */         anyTypes.add("org.w3c.dom.Element");
/*     */ 
/* 720 */         boolean matchingPartFound = false;
/* 721 */         for (MethodParamPartsMapping partsMapping : partsMappings)
/*     */         {
/* 723 */           String methodMappingTypeName = partsMapping.getParamType();
/* 724 */           if (methodMappingTypeName.equals(javaTypeName))
/*     */           {
/* 726 */             matchingPartFound = true;
/* 727 */             break;
/*     */           }
/*     */ 
/* 730 */           if ((anyTypes.contains(javaTypeName)) && (anyTypes.contains(methodMappingTypeName)))
/*     */           {
/* 732 */             matchingPartFound = true;
/* 733 */             break;
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 740 */             Class paramType = JavaUtils.loadJavaType(methodMappingTypeName);
/* 741 */             Class javaType = JavaUtils.loadJavaType(javaTypeName);
/*     */ 
/* 743 */             if (JavaUtils.isAssignableFrom(javaType, paramType))
/*     */             {
/* 745 */               matchingPartFound = true;
/* 746 */               break;
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 757 */         isWrapParameters = !matchingPartFound;
/* 758 */         this.log.trace("isWrapParameters based on matching parts: " + isWrapParameters);
/*     */       }
/*     */     }
/* 761 */     return isWrapParameters;
/*     */   }
/*     */ 
/*     */   private int processOutputDocElement(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping, List<WrappedParameter> wrappedResponseParameters, int wsdlPosition)
/*     */   {
/* 767 */     WSDLInterfaceOperationOutput opOutput = wsdlOperation.getOutputs()[0];
/* 768 */     QName xmlName = opOutput.getElement();
/* 769 */     QName xmlType = opOutput.getXMLType();
/*     */ 
/* 771 */     String javaTypeName = typeMapping.getJavaTypeName(xmlType);
/*     */ 
/* 773 */     TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/* 774 */     if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
/* 775 */       javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
/*     */     }
/* 777 */     if (javaTypeName == null) {
/* 778 */       throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
/*     */     }
/* 780 */     ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
/*     */ 
/* 782 */     boolean hasReturnMapping = true;
/* 783 */     if (opMetaData.isDocumentWrapped())
/*     */     {
/* 785 */       if (seiMethodMapping == null) {
/* 786 */         throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
/*     */       }
/* 788 */       WsdlReturnValueMapping returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping();
/* 789 */       if (returnValueMapping != null)
/*     */       {
/* 791 */         ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
/* 792 */         JavaWsdlMapping javaWsdlMapping = seiMapping.getJavaWsdlMapping();
/* 793 */         JavaXmlTypeMapping javaXmlTypeMapping = javaWsdlMapping.getTypeMappingForQName(xmlType);
/* 794 */         if (javaXmlTypeMapping == null) {
/* 795 */           throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
/*     */         }
/* 797 */         Map map = createVariableMappingMap(javaXmlTypeMapping.getVariableMappings());
/* 798 */         String elementName = returnValueMapping.getWsdlMessagePartName();
/* 799 */         String variable = (String)map.get(elementName);
/* 800 */         if (variable == null) {
/* 801 */           throw new IllegalArgumentException("Could not determine variable name for element: " + elementName);
/*     */         }
/* 803 */         String wrappedType = returnValueMapping.getMethodReturnValue();
/* 804 */         QName element = new QName(elementName);
/* 805 */         WrappedParameter wrappedParameter = new WrappedParameter(element, wrappedType, variable, -1);
/* 806 */         wrappedResponseParameters.add(0, wrappedParameter);
/*     */       }
/*     */ 
/* 809 */       outMetaData.setWrappedParameters(wrappedResponseParameters);
/*     */     }
/*     */     else
/*     */     {
/* 813 */       if (seiMethodMapping != null)
/*     */       {
/* 815 */         MethodParamPartsMapping part = seiMethodMapping.getMethodParamPartsMappingByPartName(opOutput.getPartName());
/* 816 */         String mode = null;
/* 817 */         if (part != null)
/*     */         {
/* 819 */           WsdlMessageMapping wsdlMessageMapping = part.getWsdlMessageMapping();
/* 820 */           mode = wsdlMessageMapping.getParameterMode();
/*     */         }
/* 822 */         if ("INOUT".equals(mode))
/*     */         {
/* 824 */           ParameterMetaData inMetaData = opMetaData.getParameter(xmlName);
/* 825 */           if (inMetaData != null)
/*     */           {
/* 827 */             inMetaData.setMode(ParameterMode.INOUT);
/* 828 */             return wsdlPosition;
/*     */           }
/*     */ 
/* 831 */           throw new WSException("Could not update IN parameter to be INOUT, as indicated in the mapping: " + opOutput.getPartName());
/*     */         }
/*     */ 
/* 834 */         if ("OUT".equals(mode))
/*     */         {
/* 836 */           hasReturnMapping = false;
/* 837 */           javaTypeName = part.getParamType();
/* 838 */           outMetaData.setIndex(part.getParamPosition());
/* 839 */           outMetaData.setJavaTypeName(javaTypeName);
/*     */         }
/*     */         else
/*     */         {
/* 843 */           WsdlReturnValueMapping returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping();
/* 844 */           if (returnValueMapping != null)
/*     */           {
/* 846 */             javaTypeName = returnValueMapping.getMethodReturnValue();
/* 847 */             outMetaData.setJavaTypeName(javaTypeName);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 852 */       setupXOPAttachmentParameter(wsdlOperation, outMetaData);
/* 853 */       setupSOAPArrayParameter(outMetaData);
/*     */     }
/*     */ 
/* 856 */     if (hasReturnMapping)
/*     */     {
/* 858 */       opMetaData.setReturnParameter(outMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 862 */       opMetaData.addParameter(outMetaData);
/* 863 */       outMetaData.setMode(ParameterMode.OUT);
/* 864 */       wsdlPosition++;
/*     */     }
/*     */ 
/* 867 */     return wsdlPosition;
/*     */   }
/*     */ 
/*     */   private void buildParameterMetaDataDoc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping)
/*     */   {
/* 873 */     this.log.trace("buildParameterMetaDataDoc: " + opMetaData.getQName());
/*     */ 
/* 875 */     WSDLBindingOperation bindingOperation = wsdlOperation.getBindingOperation();
/* 876 */     if (bindingOperation == null) {
/* 877 */       throw new WSException("Could not locate binding operation for:" + bindingOperation);
/*     */     }
/* 879 */     List wrappedParameters = new ArrayList();
/* 880 */     List wrappedResponseParameters = new ArrayList();
/*     */ 
/* 882 */     int wsdlPosition = 0;
/*     */ 
/* 884 */     if (wsdlOperation.getInputs().length > 0)
/*     */     {
/* 886 */       wsdlPosition = processDocElement(opMetaData, wsdlOperation, bindingOperation, seiMethodMapping, typeMapping, wrappedParameters, wrappedResponseParameters);
/* 887 */       wsdlPosition = processBindingParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
/*     */     }
/*     */     else
/*     */     {
/* 892 */       opMetaData.getEndpointMetaData().setParameterStyle(SOAPBinding.ParameterStyle.BARE);
/*     */     }
/*     */ 
/* 895 */     if (wsdlOperation.getOutputs().length > 0)
/*     */     {
/* 897 */       wsdlPosition = processOutputDocElement(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, wrappedResponseParameters, wsdlPosition);
/* 898 */       wsdlPosition = processBindingOutputParameters(opMetaData, wsdlOperation, seiMethodMapping, typeMapping, bindingOperation, wsdlPosition);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String buildWsaActionValue(WSDLInterfaceOperation wsdlOperation)
/*     */   {
/* 913 */     WSDLProperty wsaAction = wsdlOperation.getProperty(Constants.WSDL_ATTRIBUTE_WSA_ACTION.toString());
/* 914 */     String actionValue = null;
/*     */ 
/* 916 */     if (null == wsaAction)
/*     */     {
/* 919 */       String tns = wsdlOperation.getName().getNamespaceURI();
/* 920 */       String portTypeName = wsdlOperation.getName().getLocalPart();
/* 921 */       WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
/*     */ 
/* 923 */       actionValue = new String(tns + "/" + portTypeName + "/" + messageName.getValue());
/*     */     }
/*     */     else
/*     */     {
/* 927 */       actionValue = wsaAction.getValue();
/*     */     }
/*     */ 
/* 930 */     return actionValue;
/*     */   }
/*     */ 
/*     */   protected void buildFaultMetaData(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation)
/*     */   {
/* 935 */     TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/*     */ 
/* 937 */     WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
/* 938 */     for (WSDLInterfaceOperationOutfault outFault : wsdlOperation.getOutfaults())
/*     */     {
/* 940 */       QName ref = outFault.getRef();
/*     */ 
/* 942 */       WSDLInterfaceFault wsdlFault = wsdlInterface.getFault(ref);
/* 943 */       QName xmlName = wsdlFault.getElement();
/* 944 */       QName xmlType = wsdlFault.getXmlType();
/* 945 */       String javaTypeName = null;
/*     */ 
/* 947 */       if (xmlType == null)
/*     */       {
/* 949 */         this.log.warn("Cannot obtain fault type for element: " + xmlName);
/* 950 */         xmlType = xmlName;
/*     */       }
/*     */ 
/* 953 */       TypeMappingMetaData tmMetaData = typesMetaData.getTypeMappingByXMLType(xmlType);
/* 954 */       if (tmMetaData != null) {
/* 955 */         javaTypeName = tmMetaData.getJavaTypeName();
/*     */       }
/* 957 */       if (javaTypeName == null)
/*     */       {
/* 959 */         this.log.warn("Cannot obtain java type mapping for: " + xmlType);
/* 960 */         javaTypeName = new UnqualifiedFaultException(xmlType).getClass().getName();
/*     */       }
/*     */ 
/* 963 */       FaultMetaData faultMetaData = new FaultMetaData(opMetaData, xmlName, xmlType, javaTypeName);
/* 964 */       opMetaData.addFault(faultMetaData);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxrpc.JAXRPCMetaDataBuilder
 * JD-Core Version:    0.6.0
 */