/*     */ package org.jboss.ws.extensions.xop.jaxws;
/*     */ 
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.bind.attachment.AttachmentMarshaller;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.attachment.CIDGenerator;
/*     */ import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ 
/*     */ public class AttachmentMarshallerImpl extends AttachmentMarshaller
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(AttachmentMarshallerImpl.class);
/*     */ 
/*     */   public String addMtomAttachment(DataHandler data, String elementNamespace, String elementLocalName)
/*     */   {
/*  77 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  78 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/*  80 */     QName xmlName = new QName(elementNamespace, elementLocalName);
/*  81 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + "]");
/*     */ 
/*  83 */     String cid = soapMessage.getCidGenerator().generateFromName(xmlName.getLocalPart());
/*  84 */     AttachmentPart xopPart = soapMessage.createAttachmentPart(data);
/*  85 */     xopPart.addMimeHeader("Content-Id", '<' + cid + '>');
/*  86 */     soapMessage.addAttachmentPart(xopPart);
/*     */ 
/*  88 */     if (log.isDebugEnabled()) log.debug("Created attachment part " + cid + ", with content-type " + xopPart.getContentType());
/*     */ 
/*  90 */     return "cid:" + cid;
/*     */   }
/*     */ 
/*     */   public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName)
/*     */   {
/* 108 */     mimeType = null;
/*     */ 
/* 110 */     String contentType = mimeType != null ? mimeType : "application/octet-stream";
/* 111 */     DataHandler dh = new DataHandler(data, contentType);
/* 112 */     return addMtomAttachment(dh, elementNamespace, elementLocalName);
/*     */   }
/*     */ 
/*     */   public String addSwaRefAttachment(DataHandler dataHandler)
/*     */   {
/* 117 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 118 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/* 120 */     String cid = soapMessage.getCidGenerator().generateFromCount();
/* 121 */     AttachmentPart swaRefPart = soapMessage.createAttachmentPart(dataHandler);
/* 122 */     swaRefPart.addMimeHeader("Content-Id", '<' + cid + '>');
/* 123 */     soapMessage.addAttachmentPart(swaRefPart);
/*     */ 
/* 125 */     if (log.isDebugEnabled()) log.debug("Created attachment part " + cid + ", with content-type " + swaRefPart.getContentType());
/*     */ 
/* 127 */     return "cid:" + cid;
/*     */   }
/*     */ 
/*     */   public boolean isXOPPackage()
/*     */   {
/* 132 */     return XOPContext.isXOPMessage();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  60 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxws.AttachmentMarshallerImpl
 * JD-Core Version:    0.6.0
 */