/*     */ package org.jboss.ws.extensions.xop.jaxrpc;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPObject;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
/*     */ 
/*     */ public class XOPUnmarshallerImpl
/*     */   implements XOPUnmarshaller
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(XOPUnmarshallerImpl.class);
/*  53 */   private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
/*     */ 
/*     */   public boolean isXOPPackage()
/*     */   {
/*  63 */     return XOPContext.isXOPMessage();
/*     */   }
/*     */ 
/*     */   public XOPObject getAttachmentAsDataHandler(String cid)
/*     */   {
/*     */     try
/*     */     {
/*  70 */       AttachmentPart part = XOPContext.getAttachmentByCID(cid);
/*  71 */       DataHandler dataHandler = part.getDataHandler();
/*  72 */       String contentType = dataHandler.getContentType();
/*     */ 
/*  75 */       XOPObject xopObject = new XOPObject(dataHandler);
/*  76 */       xopObject.setContentType(contentType);
/*     */ 
/*  78 */       return xopObject;
/*     */     }
/*     */     catch (SOAPException e) {
/*     */     }
/*  82 */     throw new WSException("Failed to access attachment part", e);
/*     */   }
/*     */ 
/*     */   public byte[] getAttachmentAsByteArray(String cid)
/*     */   {
/*     */     try
/*     */     {
/*  90 */       AttachmentPart part = XOPContext.getAttachmentByCID(cid);
/*  91 */       DataHandler dh = part.getDataHandler();
/*  92 */       ByteArrayOutputStream bout = new ByteArrayOutputStream();
/*  93 */       dh.writeTo(bout);
/*     */ 
/*  95 */       return bout.toByteArray();
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/*  99 */       throw new WSException(ex);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 103 */     throw new WSException(e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  58 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl
 * JD-Core Version:    0.6.0
 */