/*     */ package org.jboss.ws.extensions.security.jaxws;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
/*     */ import org.jboss.ws.extensions.security.Constants;
/*     */ import org.jboss.ws.extensions.security.WSSecurityDispatcher;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public abstract class WSSecurityHandler extends GenericSOAPHandler
/*     */ {
/*  56 */   private static Logger log = Logger.getLogger(WSSecurityHandler.class);
/*     */   private static Set<QName> headers;
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/*  69 */     return headers;
/*     */   }
/*     */ 
/*     */   protected boolean handleInboundSecurity(MessageContext msgContext)
/*     */   {
/*     */     try
/*     */     {
/*  76 */       if (getSecurityConfiguration(msgContext) != null)
/*     */       {
/*  78 */         WSSecurityDispatcher.handleInbound((CommonMessageContext)msgContext);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/*  83 */       log.error("Cannot handle inbound ws-security", ex);
/*  84 */       return false;
/*     */     }
/*  86 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean handleOutboundSecurity(MessageContext msgContext)
/*     */   {
/*     */     try
/*     */     {
/*  93 */       if (getSecurityConfiguration(msgContext) != null)
/*     */       {
/*  95 */         WSSecurityDispatcher.handleOutbound((CommonMessageContext)msgContext);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 100 */       log.error("Cannot handle outbound ws-security", ex);
/* 101 */       return false;
/*     */     }
/* 103 */     return true;
/*     */   }
/*     */ 
/*     */   private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext)
/*     */   {
/* 112 */     EndpointMetaData epMetaData = ((CommonMessageContext)msgContext).getEndpointMetaData();
/* 113 */     ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/*     */ 
/* 115 */     if (serviceMetaData.getSecurityConfiguration() == null)
/*     */     {
/* 117 */       UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
/* 118 */       WSSecurityConfiguration config = null;
/*     */       try
/*     */       {
/* 121 */         WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 122 */         config = wsseConfFactory.createConfiguration(vfsRoot, getConfigResourceName());
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 126 */         WSException.rethrow("Cannot load ws-security config", ex);
/*     */       }
/*     */ 
/* 130 */       serviceMetaData.setSecurityConfiguration(config);
/*     */     }
/*     */ 
/* 134 */     return serviceMetaData.getSecurityConfiguration();
/*     */   }
/*     */ 
/*     */   protected abstract String getConfigResourceName();
/*     */ 
/*     */   static
/*     */   {
/*  62 */     HashSet set = new HashSet();
/*  63 */     set.add(Constants.WSSE_HEADER_QNAME);
/*  64 */     headers = Collections.unmodifiableSet(set);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.jaxws.WSSecurityHandler
 * JD-Core Version:    0.6.0
 */