/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class UsernameToken
/*     */   implements Token
/*     */ {
/*     */   private String username;
/*     */   private String password;
/*     */   private Document doc;
/*     */   private String id;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public UsernameToken(String username, String password, Document doc)
/*     */   {
/*  50 */     this.username = username;
/*  51 */     this.password = password;
/*  52 */     this.doc = doc;
/*     */   }
/*     */ 
/*     */   public UsernameToken(Element element) throws WSSecurityException
/*     */   {
/*  57 */     this.doc = element.getOwnerDocument();
/*  58 */     String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/*  59 */     if ((id == null) || (id.length() == 0)) {
/*  60 */       throw new WSSecurityException("Invalid message, UsernameToken is missing an id");
/*     */     }
/*  62 */     setId(id);
/*     */ 
/*  64 */     Element child = Util.getFirstChildElement(element);
/*  65 */     if ((child == null) || (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) || (!"Username".equals(child.getLocalName()))) {
/*  66 */       throw new WSSecurityException("Username child expected in UsernameToken element");
/*     */     }
/*  68 */     this.username = XMLUtils.getFullTextChildrenFromElement(child);
/*     */ 
/*  70 */     child = Util.getNextSiblingElement(child);
/*  71 */     if ((child == null) || (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) || (!"Password".equals(child.getLocalName()))) {
/*  72 */       throw new WSSecurityException("Password child expected in UsernameToken element");
/*     */     }
/*  74 */     this.password = XMLUtils.getFullTextChildrenFromElement(child);
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/*  79 */     if (this.id == null) {
/*  80 */       this.id = Util.generateId("token");
/*     */     }
/*  82 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(String id)
/*     */   {
/*  87 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/*  93 */     return this.password;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/*  99 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getUsername()
/*     */   {
/* 104 */     return this.username;
/*     */   }
/*     */ 
/*     */   public void setUsername(String username)
/*     */   {
/* 109 */     this.username = username;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/* 114 */     if (this.cachedElement != null) {
/* 115 */       return this.cachedElement;
/*     */     }
/* 117 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
/* 118 */     element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", getId());
/* 119 */     Element child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
/* 120 */     child.appendChild(this.doc.createTextNode(this.username));
/* 121 */     element.appendChild(child);
/* 122 */     child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
/* 123 */     child.appendChild(this.doc.createTextNode(this.password));
/* 124 */     element.appendChild(child);
/*     */ 
/* 126 */     this.cachedElement = element;
/* 127 */     return this.cachedElement;
/*     */   }
/*     */ 
/*     */   public Object getUniqueContent()
/*     */   {
/* 132 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.UsernameToken
 * JD-Core Version:    0.6.0
 */