/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.security.PrivateKey;
/*     */ import java.security.cert.X509Certificate;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.crypto.SecretKey;
/*     */ import org.apache.xml.security.encryption.XMLCipher;
/*     */ import org.apache.xml.security.exceptions.XMLSecurityException;
/*     */ import org.apache.xml.security.keys.KeyInfo;
/*     */ import org.jboss.ws.extensions.security.InvalidSecurityHeaderException;
/*     */ import org.jboss.ws.extensions.security.KeyResolver;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EncryptedKey
/*     */   implements SecurityProcess
/*     */ {
/*     */   private Document document;
/*     */   private SecretKey secretKey;
/*     */   private X509Token token;
/*     */   private ReferenceList list;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public EncryptedKey(Document document, SecretKey secretKey, X509Token token)
/*     */   {
/*  59 */     this(document, secretKey, token, new ReferenceList());
/*     */   }
/*     */ 
/*     */   public EncryptedKey(Document document, SecretKey secretKey, X509Token token, ReferenceList list)
/*     */   {
/*  64 */     this.document = document;
/*  65 */     this.secretKey = secretKey;
/*  66 */     this.token = token;
/*  67 */     this.list = list;
/*     */   }
/*     */ 
/*     */   public EncryptedKey(Element element, KeyResolver resolver) throws WSSecurityException
/*     */   {
/*     */     XMLCipher cipher;
/*     */     org.apache.xml.security.encryption.EncryptedKey key;
/*     */     try {
/*  77 */       cipher = XMLCipher.getInstance();
/*  78 */       key = cipher.loadEncryptedKey(element);
/*     */     }
/*     */     catch (XMLSecurityException e)
/*     */     {
/*  82 */       throw new WSSecurityException("Could not parse encrypted key: " + e.getMessage(), e);
/*     */     }
/*     */ 
/*  85 */     KeyInfo info = key.getKeyInfo();
/*     */ 
/*  87 */     if (info == null) {
/*  88 */       throw new WSSecurityException("EncryptedKey element did not contain KeyInfo");
/*     */     }
/*  90 */     PrivateKey privateKey = resolver.resolvePrivateKey(info);
/*     */ 
/*  95 */     Element referenceList = Util.findElement(element, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
/*  96 */     if (referenceList == null) {
/*  97 */       throw new WSSecurityException("Encrypted key did not contain a reference list");
/*     */     }
/*  99 */     this.list = new ReferenceList(referenceList);
/*     */ 
/* 102 */     String alg = getKeyAlgorithm(element);
/* 103 */     if (alg == null) {
/* 104 */       throw new WSSecurityException("Could not determine encrypted key algorithm!");
/*     */     }
/*     */     try
/*     */     {
/* 108 */       cipher.init(4, privateKey);
/* 109 */       this.secretKey = ((SecretKey)cipher.decryptKey(key, alg));
/*     */     }
/*     */     catch (XMLSecurityException e)
/*     */     {
/* 113 */       throw new WSSecurityException("Could not parse encrypted key: " + e.getMessage(), e);
/*     */     }
/*     */ 
/* 116 */     this.document = element.getOwnerDocument();
/* 117 */     this.token = new X509Token(resolver.resolveCertificate(info), this.document);
/*     */   }
/*     */ 
/*     */   private String getKeyAlgorithm(Element element)
/*     */     throws WSSecurityException
/*     */   {
/* 123 */     String id = (String)this.list.getAllReferences().iterator().next();
/* 124 */     if (id == null) {
/* 125 */       return null;
/*     */     }
/* 127 */     Element dataElement = Util.findElementByWsuId(element.getOwnerDocument().getDocumentElement(), id);
/* 128 */     if (dataElement == null) {
/* 129 */       return null;
/*     */     }
/* 131 */     return getEncryptionAlgorithm(dataElement);
/*     */   }
/*     */ 
/*     */   private String getEncryptionAlgorithm(Element element) throws WSSecurityException
/*     */   {
/* 136 */     element = Util.findElement(element, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
/* 137 */     if (element == null) {
/* 138 */       throw new InvalidSecurityHeaderException("Encrypted element corrupted, no encryption method");
/*     */     }
/* 140 */     String alg = element.getAttribute("Algorithm");
/* 141 */     if ((alg == null) || (alg.length() == 0)) {
/* 142 */       throw new InvalidSecurityHeaderException("Encrypted element corrupted, no algorithm specified");
/*     */     }
/* 144 */     return alg;
/*     */   }
/*     */ 
/*     */   public Element getElement() throws WSSecurityException
/*     */   {
/* 149 */     if (this.cachedElement != null)
/* 150 */       return this.cachedElement;
/*     */     XMLCipher cipher;
/*     */     org.apache.xml.security.encryption.EncryptedKey key;
/*     */     try
/*     */     {
/* 157 */       cipher = XMLCipher.getInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
/* 158 */       cipher.init(3, this.token.getCert().getPublicKey());
/* 159 */       key = cipher.encryptKey(this.document, this.secretKey);
/*     */     }
/*     */     catch (XMLSecurityException e)
/*     */     {
/* 163 */       throw new WSSecurityException("Error encrypting key: " + e.getMessage(), e);
/*     */     }
/*     */ 
/* 166 */     SecurityTokenReference reference = new SecurityTokenReference(new DirectReference(this.document, this.token));
/* 167 */     KeyInfo keyInfo = new KeyInfo(this.document);
/* 168 */     keyInfo.addUnknownElement(reference.getElement());
/* 169 */     key.setKeyInfo(keyInfo);
/*     */ 
/* 171 */     key.setReferenceList(cipher.createReferenceList(1));
/* 172 */     this.list.populateRealReferenceList(key.getReferenceList());
/*     */ 
/* 174 */     this.cachedElement = cipher.martial(key);
/* 175 */     return this.cachedElement;
/*     */   }
/*     */ 
/*     */   public void addReference(String id)
/*     */   {
/* 180 */     this.list.add(id);
/*     */   }
/*     */ 
/*     */   public SecretKey getSecretKey()
/*     */   {
/* 185 */     return this.secretKey;
/*     */   }
/*     */ 
/*     */   public ReferenceList getReferenceList()
/*     */   {
/* 190 */     return this.list;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.EncryptedKey
 * JD-Core Version:    0.6.0
 */