/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import org.apache.xml.security.signature.XMLSignatureInput;
/*    */ import org.apache.xml.security.utils.resolver.ResourceResolverException;
/*    */ import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
/*    */ import org.w3c.dom.Attr;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class WsuIdResolver extends ResourceResolverSpi
/*    */ {
/*    */   Document doc;
/*    */   Element header;
/*    */ 
/*    */   public WsuIdResolver(Document doc)
/*    */   {
/* 43 */     this.doc = doc;
/*    */   }
/*    */ 
/*    */   public WsuIdResolver(Document doc, Element header)
/*    */   {
/* 48 */     this.doc = doc;
/* 49 */     this.header = header;
/*    */   }
/*    */ 
/*    */   public boolean engineCanResolve(Attr uri, String baseURI)
/*    */   {
/* 57 */     if (uri == null) {
/* 58 */       return false;
/*    */     }
/* 60 */     String nodeValue = uri.getNodeValue();
/* 61 */     return (nodeValue != null) && (nodeValue.startsWith("#"));
/*    */   }
/*    */ 
/*    */   public XMLSignatureInput engineResolve(Attr uri, String BaseURI)
/*    */     throws ResourceResolverException
/*    */   {
/* 70 */     String id = uri.getValue().substring(1);
/*    */ 
/* 72 */     Element element = this.doc.getDocumentElement();
/* 73 */     element = Util.findElementByWsuId(element, id);
/*    */ 
/* 76 */     if ((element == null) && (this.header != null)) {
/* 77 */       element = Util.findElementByWsuId(this.header, id);
/*    */     }
/* 79 */     if (element == null) {
/* 80 */       throw new ResourceResolverException(id, uri, BaseURI);
/*    */     }
/* 82 */     XMLSignatureInput input = new XMLSignatureInput(element);
/* 83 */     input.setMIMEType("text/xml");
/*    */ 
/* 85 */     input.setSourceURI(BaseURI + uri);
/*    */ 
/* 87 */     return input;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.WsuIdResolver
 * JD-Core Version:    0.6.0
 */