/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Calendar;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import org.apache.xml.security.Init;
/*     */ import org.jboss.ws.extensions.security.element.EncryptedKey;
/*     */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*     */ import org.jboss.ws.extensions.security.element.SecurityProcess;
/*     */ import org.jboss.ws.extensions.security.element.Signature;
/*     */ import org.jboss.ws.extensions.security.element.Timestamp;
/*     */ import org.jboss.ws.extensions.security.element.Token;
/*     */ import org.jboss.ws.extensions.security.element.UsernameToken;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class SecurityDecoder
/*     */ {
/*     */   private Element headerElement;
/*  48 */   private Calendar now = null;
/*     */   private SecurityHeader header;
/*     */   private Document message;
/*     */   private SecurityStore store;
/*  56 */   private HashSet<String> signedIds = new HashSet();
/*     */ 
/*  58 */   private HashSet<String> encryptedIds = new HashSet();
/*     */ 
/*     */   public SecurityDecoder(SecurityStore store)
/*     */   {
/*  62 */     Init.init();
/*  63 */     this.store = store;
/*     */   }
/*     */ 
/*     */   public SecurityDecoder(SecurityStore store, Calendar now)
/*     */   {
/*  75 */     this(store);
/*  76 */     this.now = now;
/*     */   }
/*     */ 
/*     */   private Element getHeader(Document message) throws WSSecurityException
/*     */   {
/*  81 */     Element header = Util.findElement(message.getDocumentElement(), "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
/*  82 */     if (header == null) {
/*  83 */       throw new WSSecurityException("Expected security header was not found");
/*     */     }
/*  85 */     return header;
/*     */   }
/*     */ 
/*     */   private void detachHeader()
/*     */   {
/*  90 */     this.headerElement.getParentNode().removeChild(this.headerElement);
/*     */   }
/*     */ 
/*     */   private void decode()
/*     */     throws WSSecurityException
/*     */   {
/*  97 */     Timestamp timestamp = this.header.getTimestamp();
/*     */ 
/*  99 */     if (timestamp != null)
/*     */     {
/* 101 */       TimestampVerificationOperation operation = this.now == null ? new TimestampVerificationOperation() : new TimestampVerificationOperation(this.now);
/*     */ 
/* 103 */       operation.process(this.message, timestamp);
/*     */     }
/*     */ 
/* 106 */     for (Token token : this.header.getTokens())
/*     */     {
/* 108 */       if ((token instanceof UsernameToken)) {
/* 109 */         new ReceiveUsernameOperation(this.header, this.store).process(this.message, token);
/*     */       }
/*     */     }
/* 112 */     this.signedIds.clear();
/* 113 */     this.encryptedIds.clear();
/*     */ 
/* 115 */     SignatureVerificationOperation signatureVerifier = new SignatureVerificationOperation(this.header, this.store);
/* 116 */     DecryptionOperation decrypter = new DecryptionOperation(this.header, this.store);
/*     */ 
/* 118 */     for (SecurityProcess process : this.header.getSecurityProcesses())
/*     */     {
/* 121 */       if ((process instanceof Signature))
/*     */       {
/* 123 */         Collection ids = signatureVerifier.process(this.message, process);
/* 124 */         if (ids != null)
/* 125 */           this.signedIds.addAll(ids);
/*     */       }
/* 127 */       else if ((process instanceof EncryptedKey))
/*     */       {
/* 129 */         Collection ids = decrypter.process(this.message, process);
/* 130 */         if (ids != null)
/* 131 */           this.encryptedIds.addAll(ids);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void verify(List<OperationDescription<RequireOperation>> requireOperations) throws WSSecurityException
/*     */   {
/* 138 */     if (requireOperations == null) {
/* 139 */       return;
/*     */     }
/* 141 */     for (OperationDescription o : requireOperations)
/*     */     {
/* 143 */       Class operation = o.getOperation();
/*     */ 
/* 145 */       Collection processedIds = null;
/*     */       RequireOperation op;
/* 147 */       if (operation.equals(RequireSignatureOperation.class))
/*     */       {
/* 149 */         RequireOperation op = new RequireSignatureOperation(this.header, this.store);
/* 150 */         processedIds = this.signedIds;
/*     */       }
/* 152 */       else if (operation.equals(RequireEncryptionOperation.class))
/*     */       {
/* 154 */         RequireOperation op = new RequireEncryptionOperation(this.header, this.store);
/* 155 */         processedIds = this.encryptedIds;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 161 */           Constructor c = operation.getConstructor(new Class[] { SecurityHeader.class, SecurityStore.class });
/* 162 */           op = (RequireOperation)c.newInstance(new Object[] { this.header, this.store });
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 166 */           throw new WSSecurityException("Error constructing operation: " + operation);
/*     */         }
/*     */       }
/*     */ 
/* 170 */       op.process(this.message, o.getTargets(), o.getCertificateAlias(), o.getCredential(), processedIds);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void decode(Document message) throws WSSecurityException
/*     */   {
/* 176 */     decode(message, getHeader(message));
/*     */   }
/*     */ 
/*     */   public void decode(Document message, Element headerElement) throws WSSecurityException
/*     */   {
/* 181 */     this.headerElement = headerElement;
/* 182 */     this.header = new SecurityHeader(this.headerElement, this.store);
/* 183 */     this.message = message;
/*     */ 
/* 185 */     decode();
/*     */   }
/*     */ 
/*     */   public void complete()
/*     */   {
/* 192 */     detachHeader();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.SecurityDecoder
 * JD-Core Version:    0.6.0
 */