/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import java.util.Collection;
/*    */ import java.util.List;
/*    */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*    */ import org.jboss.ws.extensions.security.element.Timestamp;
/*    */ import org.w3c.dom.Document;
/*    */ 
/*    */ public class RequireTimestampOperation
/*    */   implements RequireOperation
/*    */ {
/*    */   private SecurityHeader header;
/*    */ 
/*    */   public RequireTimestampOperation(SecurityHeader header, SecurityStore store)
/*    */     throws WSSecurityException
/*    */   {
/* 39 */     this.header = header;
/*    */   }
/*    */ 
/*    */   public void process(Document message, List<Target> targets, String maxAge, String credential, Collection<String> processedIds) throws WSSecurityException
/*    */   {
/* 44 */     Timestamp stamp = this.header.getTimestamp();
/* 45 */     if (stamp == null) {
/* 46 */       throw new FailedCheckException("Required timestamp not present.");
/*    */     }
/*    */ 
/* 49 */     if (maxAge == null) {
/* 50 */       return;
/*    */     }
/* 52 */     int max = Integer.parseInt(maxAge);
/*    */ 
/* 54 */     Calendar expired = (Calendar)stamp.getCreated().clone();
/* 55 */     expired.add(13, max);
/*    */ 
/* 57 */     if (!Calendar.getInstance().before(expired))
/* 58 */       throw new FailedCheckException("Timestamp of message is too old.");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.RequireTimestampOperation
 * JD-Core Version:    0.6.0
 */