/*    */ package org.jboss.ws.extensions.policy.deployer.domainAssertion;
/*    */ 
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.StringReader;
/*    */ import org.apache.ws.policy.PrimitiveAssertion;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.extensions.policy.deployer.PolicyDeployer;
/*    */ import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
/*    */ import org.jboss.ws.extensions.policy.deployer.util.PrimitiveAssertionWriter;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*    */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*    */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*    */ import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
/*    */ 
/*    */ public class WSSecurityAssertionDeployer
/*    */   implements AssertionDeployer
/*    */ {
/* 47 */   private static final Logger log = Logger.getLogger(PolicyDeployer.class);
/*    */ 
/*    */   public void deployServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion
/*    */   {
/* 51 */     ByteArrayOutputStream stream = new ByteArrayOutputStream();
/* 52 */     if ((extMetaData instanceof EndpointMetaData))
/*    */     {
/* 54 */       EndpointMetaData ep = (EndpointMetaData)extMetaData;
/*    */       try
/*    */       {
/* 60 */         PrimitiveAssertionWriter.newInstance().writePrimitiveAssertion(assertion, stream);
/* 61 */         StringReader reader = new StringReader(stream.toString());
/*    */ 
/* 64 */         WSSecurityConfiguration securityConfiguration = WSSecurityOMFactory.newInstance().parse(reader);
/* 65 */         WSSecurityConfigFactory.newInstance().initKeystorePath(ep.getRootFile(), securityConfiguration);
/* 66 */         ep.getServiceMetaData().setSecurityConfiguration(securityConfiguration);
/*    */ 
/* 69 */         ep.setConfigName("Standard WSSecurity Endpoint");
/* 70 */         ep.initEndpointConfig();
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 75 */         e.printStackTrace();
/* 76 */         throw new UnsupportedAssertion();
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public void deployClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion
/*    */   {
/* 83 */     if ((extMetaData instanceof EndpointMetaData))
/*    */     {
/* 85 */       ByteArrayOutputStream stream = new ByteArrayOutputStream();
/* 86 */       EndpointMetaData epMetaData = (EndpointMetaData)extMetaData;
/* 87 */       ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/* 88 */       if (serviceMetaData.getSecurityConfiguration() == null)
/*    */       {
/*    */         try
/*    */         {
/* 92 */           PrimitiveAssertionWriter.newInstance().writePrimitiveAssertion(assertion, stream);
/* 93 */           StringReader reader = new StringReader(stream.toString());
/*    */ 
/* 95 */           WSSecurityConfiguration securityConfiguration = WSSecurityOMFactory.newInstance().parse(reader);
/* 96 */           serviceMetaData.setSecurityConfiguration(securityConfiguration);
/*    */ 
/* 98 */           epMetaData.setConfigName("Standard WSSecurity Client");
/* 99 */           epMetaData.initEndpointConfig();
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 103 */           e.printStackTrace();
/* 104 */           throw new UnsupportedAssertion();
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.deployer.domainAssertion.WSSecurityAssertionDeployer
 * JD-Core Version:    0.6.0
 */