/*     */ package org.jboss.ws.extensions.policy.deployer;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.ws.policy.AndCompositeAssertion;
/*     */ import org.apache.ws.policy.Assertion;
/*     */ import org.apache.ws.policy.Policy;
/*     */ import org.apache.ws.policy.PrimitiveAssertion;
/*     */ import org.apache.ws.policy.XorCompositeAssertion;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
/*     */ import org.jboss.ws.extensions.policy.deployer.domainAssertion.NopAssertionDeployer;
/*     */ import org.jboss.ws.extensions.policy.deployer.domainAssertion.WSSecurityAssertionDeployer;
/*     */ import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAlternative;
/*     */ import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
/*     */ import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedPolicy;
/*     */ import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
/*     */ 
/*     */ public class PolicyDeployer
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(PolicyDeployer.class);
/*     */ 
/*  57 */   private static PolicyDeployer me = new PolicyDeployer();
/*     */ 
/*  53 */   private Map<String, Class> domainDeployerMap = new HashMap();
/*     */ 
/*     */   public static PolicyDeployer getInstance()
/*     */   {
/*  68 */     return me;
/*     */   }
/*     */ 
/*     */   public static PolicyDeployer newInstance(Map<String, Class> customDomainMap)
/*     */   {
/*  74 */     PolicyDeployer instance = new PolicyDeployer();
/*  75 */     instance.domainDeployerMap = customDomainMap;
/*  76 */     return instance;
/*     */   }
/*     */ 
/*     */   public static PolicyDeployer newInstanceForTools()
/*     */   {
/*  83 */     PolicyDeployer instance = new PolicyDeployer();
/*  84 */     instance.domainDeployerMap.put("http://www.jboss.com/ws-security/schema/jboss-ws-security_1_0.xsd", NopAssertionDeployer.class);
/*  85 */     return instance;
/*     */   }
/*     */ 
/*     */   public Policy deployServerside(Policy policy, ExtensibleMetaData extMetaData)
/*     */     throws UnsupportedPolicy
/*     */   {
/*  92 */     if (policy == null) {
/*  93 */       throw new WSException("Cannot deploy null policy!");
/*     */     }
/*  95 */     List returnedPolicyTerms = new LinkedList();
/*     */ 
/*  97 */     if (!policy.isNormalized())
/*     */     {
/*  99 */       policy = (Policy)policy.normalize();
/*     */     }
/*     */ 
/* 103 */     XorCompositeAssertion exactlyOne = (XorCompositeAssertion)policy.getTerms().get(0);
/* 104 */     log.debug("####" + exactlyOne.getClass());
/* 105 */     log.debug("####" + exactlyOne.getTerms());
/* 106 */     for (AndCompositeAssertion alternative : exactlyOne.getTerms())
/*     */     {
/* 108 */       log.debug("alternative");
/*     */       try
/*     */       {
/* 111 */         deployAlternativeServerSide(alternative, extMetaData);
/* 112 */         returnedPolicyTerms.add(alternative);
/*     */       }
/*     */       catch (UnsupportedAlternative e)
/*     */       {
/* 116 */         log.debug("Unsupported Alternative");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 121 */     if (returnedPolicyTerms.size() == 0)
/*     */     {
/* 123 */       if (log.isDebugEnabled())
/*     */       {
/* 125 */         log.debug("XorComposite zero element...Policy not supported");
/*     */       }
/* 127 */       throw new UnsupportedPolicy();
/*     */     }
/* 129 */     policy.getTerms().clear();
/* 130 */     policy.addTerms(returnedPolicyTerms);
/* 131 */     return policy;
/*     */   }
/*     */ 
/*     */   public void deployClientSide(Policy policy, ExtensibleMetaData extMetaData)
/*     */     throws UnsupportedPolicy
/*     */   {
/* 145 */     if (policy == null) {
/* 146 */       throw new WSException("Cannot deploy null policy!");
/*     */     }
/* 148 */     if (!policy.isNormalized())
/*     */     {
/* 150 */       policy = (Policy)policy.normalize();
/*     */     }
/*     */ 
/* 153 */     XorCompositeAssertion exactlyOne = (XorCompositeAssertion)policy.getTerms().get(0);
/* 154 */     for (AndCompositeAssertion alternative : exactlyOne.getTerms())
/*     */     {
/* 156 */       for (Assertion assertion : alternative.getTerms())
/*     */       {
/* 158 */         if ((assertion instanceof PrimitiveAssertion))
/*     */         {
/*     */           try
/*     */           {
/* 162 */             deployAssertionClientSide((PrimitiveAssertion)assertion, extMetaData);
/*     */           }
/*     */           catch (UnsupportedAssertion e)
/*     */           {
/* 166 */             log.error("Unsupported assertion!");
/* 167 */             throw new UnsupportedPolicy();
/*     */           }
/*     */         }
/* 170 */         else if ((assertion instanceof Policy))
/*     */         {
/* 172 */           deployClientSide((Policy)assertion, extMetaData);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployAlternativeServerSide(AndCompositeAssertion alternative, ExtensibleMetaData extMetaData)
/*     */     throws UnsupportedAlternative
/*     */   {
/* 181 */     for (Assertion assertion : alternative.getTerms())
/*     */     {
/*     */       try
/*     */       {
/* 186 */         if ((assertion instanceof PrimitiveAssertion))
/*     */         {
/* 188 */           deployAssertionServerSide((PrimitiveAssertion)assertion, extMetaData);
/*     */         }
/* 190 */         else if ((assertion instanceof Policy))
/*     */         {
/* 192 */           deployServerside((Policy)assertion, extMetaData);
/*     */         }
/*     */         else
/*     */         {
/* 196 */           if (log.isDebugEnabled())
/*     */           {
/* 198 */             log.debug("Unknown Alternative type....Alternative not supported");
/*     */           }
/* 200 */           throw new UnsupportedAlternative();
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (UnsupportedAssertion e)
/*     */       {
/* 207 */         throw new UnsupportedAlternative();
/*     */       }
/*     */       catch (UnsupportedPolicy ep)
/*     */       {
/* 212 */         throw new UnsupportedAlternative();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployAssertionServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion
/*     */   {
/* 219 */     AssertionDeployer deployer = getDomainDeployerInstance(assertion.getName().getNamespaceURI());
/* 220 */     deployer.deployServerSide(assertion, extMetaData);
/*     */   }
/*     */ 
/*     */   private void deployAssertionClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion
/*     */   {
/* 225 */     AssertionDeployer deployer = getDomainDeployerInstance(assertion.getName().getNamespaceURI());
/* 226 */     deployer.deployClientSide(assertion, extMetaData);
/*     */   }
/*     */ 
/*     */   private AssertionDeployer getDomainDeployerInstance(String namespace)
/*     */     throws UnsupportedAssertion
/*     */   {
/*     */     try
/*     */     {
/* 238 */       if (!this.domainDeployerMap.containsKey(namespace))
/*     */       {
/* 240 */         if (log.isDebugEnabled())
/*     */         {
/* 242 */           log.debug("Unknown namespace:" + namespace + "...Assertion not supported");
/*     */         }
/* 244 */         throw new UnsupportedAssertion();
/*     */       }
/* 246 */       return (AssertionDeployer)((Class)this.domainDeployerMap.get(namespace)).newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 251 */     throw new UnsupportedAssertion();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  58 */     me.domainDeployerMap.put("http://www.jboss.com/ws-security/schema/jboss-ws-security_1_0.xsd", WSSecurityAssertionDeployer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.deployer.PolicyDeployer
 * JD-Core Version:    0.6.0
 */