/*     */ package org.jboss.ws.extensions.policy;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class Policy
/*     */ {
/*     */   public static final String URI_POLICY = "http://schemas.xmlsoap.org/ws/2004/09/policy";
/*     */   public static final String URI_SECURITY_UTILITY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
/*     */   private String targetNamespace;
/*     */   private String baseURI;
/*     */   private String id;
/*  65 */   private Collection<PolicyAlternative> alternatives = new ArrayList();
/*     */ 
/*  67 */   private NamespaceRegistry nsRegistry = new NamespaceRegistry();
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/*  76 */     return this.nsRegistry;
/*     */   }
/*     */ 
/*     */   public String getTargetNamespace()
/*     */   {
/*  81 */     return this.targetNamespace;
/*     */   }
/*     */ 
/*     */   public void setTargetNamespace(String targetNamespace)
/*     */   {
/*  86 */     this.targetNamespace = targetNamespace;
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/*  91 */     return this.baseURI;
/*     */   }
/*     */ 
/*     */   public void setBaseURI(String baseURI)
/*     */   {
/*  96 */     this.baseURI = baseURI;
/*     */   }
/*     */ 
/*     */   public String getID()
/*     */   {
/* 101 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setID(String id)
/*     */   {
/* 106 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void addPolicyAlternative(PolicyAlternative polAlternative)
/*     */   {
/* 111 */     this.alternatives.add(polAlternative);
/*     */   }
/*     */ 
/*     */   public Collection<PolicyAlternative> getPolicyAlternatives()
/*     */   {
/* 116 */     return new ArrayList(this.alternatives);
/*     */   }
/*     */ 
/*     */   public void clearPolicyAlternatives()
/*     */   {
/* 121 */     this.alternatives.clear();
/*     */   }
/*     */ 
/*     */   public Element toElement()
/*     */   {
/* 126 */     String xmlString = toXMLString(false);
/*     */     try
/*     */     {
/* 129 */       return DOMUtils.parse(xmlString);
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/* 133 */     throw new WSException("Cannot parse: " + xmlString, ex);
/*     */   }
/*     */ 
/*     */   public String toXMLString(boolean pretty)
/*     */   {
/* 139 */     if (pretty)
/*     */     {
/* 141 */       Element elPolicy = toElement();
/* 142 */       return DOMWriter.printNode(elPolicy, true);
/*     */     }
/*     */ 
/* 145 */     StringBuilder xmlBuffer = new StringBuilder("<wsp:Policy");
/*     */ 
/* 147 */     Iterator it = this.nsRegistry.getRegisteredURIs();
/* 148 */     while (it.hasNext())
/*     */     {
/* 150 */       String nsURI = (String)it.next();
/* 151 */       String prefix = this.nsRegistry.getPrefix(nsURI);
/* 152 */       xmlBuffer.append(" xmlns:" + prefix + "='" + nsURI + "'");
/*     */     }
/*     */ 
/* 155 */     if (this.id != null)
/*     */     {
/* 157 */       xmlBuffer.append(" xmlns:wsu='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'");
/* 158 */       xmlBuffer.append(" wsu:Id='" + this.id + "'");
/*     */     }
/* 160 */     if (this.baseURI != null)
/*     */     {
/* 162 */       xmlBuffer.append(" xml:base='" + this.baseURI + "'");
/*     */     }
/* 164 */     if (this.targetNamespace != null)
/*     */     {
/* 166 */       xmlBuffer.append(" TargetNamespace='" + this.targetNamespace + "'");
/*     */     }
/* 168 */     xmlBuffer.append(">");
/*     */ 
/* 170 */     xmlBuffer.append("<wsp:ExactlyOne>");
/* 171 */     for (PolicyAlternative polAlternative : this.alternatives)
/*     */     {
/* 173 */       xmlBuffer.append(polAlternative.toXMLString(false));
/*     */     }
/* 175 */     xmlBuffer.append("</wsp:ExactlyOne>");
/*     */ 
/* 177 */     xmlBuffer.append("</wsp:Policy>");
/*     */ 
/* 179 */     String xmlString = xmlBuffer.toString();
/* 180 */     return xmlString;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 185 */     return toXMLString(true);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.Policy
 * JD-Core Version:    0.6.0
 */