/*    */ package org.jboss.ws.extensions.eventing.mgmt;
/*    */ 
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import java.util.List;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.extensions.eventing.EventingConstants;
/*    */ import org.jboss.ws.extensions.eventing.deployment.EventingEndpointDeployment;
/*    */ 
/*    */ public class EventingBuilder
/*    */ {
/*    */   public static EventingBuilder createEventingBuilder()
/*    */   {
/* 23 */     return new EventingBuilder();
/*    */   }
/*    */ 
/*    */   public EventSource newEventSource(EventingEndpointDeployment desc)
/*    */   {
/* 28 */     URI eventSourceNS = newEventSourceURI(desc.getName());
/* 29 */     EventSource eventSource = new EventSource(desc.getName(), eventSourceNS, desc.getSchema(), desc.getNotificationRootElementNS());
/* 30 */     eventSource.getSupportedFilterDialects().add(EventingConstants.getDefaultFilterDialect());
/* 31 */     return eventSource;
/*    */   }
/*    */ 
/*    */   public URI newEventSourceURI(String name)
/*    */   {
/*    */     try
/*    */     {
/* 38 */       return new URI(name);
/*    */     }
/*    */     catch (URISyntaxException e) {
/*    */     }
/* 42 */     throw new WSException("Failed to create eventsource URI: " + e.getMessage());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.mgmt.EventingBuilder
 * JD-Core Version:    0.6.0
 */