/*    */ package org.jboss.ws.extensions.eventing.mgmt;
/*    */ 
/*    */ import java.net.URI;
/*    */ import javax.management.MBeanServerConnection;
/*    */ import javax.management.MBeanServerInvocationHandler;
/*    */ import javax.management.ObjectName;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.Referenceable;
/*    */ import javax.naming.StringRefAddr;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class DispatcherDelegate
/*    */   implements EventDispatcher, Referenceable
/*    */ {
/*    */   private String hostname;
/*    */   public static final String MANAGER_HOSTNAME = "manager.hostname";
/* 29 */   private SubscriptionManagerMBean subscriptionManager = null;
/*    */ 
/*    */   public DispatcherDelegate()
/*    */   {
/*    */   }
/*    */ 
/*    */   public DispatcherDelegate(String hostname)
/*    */   {
/* 37 */     setHostname(hostname);
/*    */   }
/*    */ 
/*    */   public void dispatch(URI eventSourceNS, Element payload)
/*    */   {
/* 42 */     getSubscriptionManager().dispatch(eventSourceNS, payload);
/*    */   }
/*    */ 
/*    */   public Reference getReference()
/*    */     throws NamingException
/*    */   {
/* 48 */     Reference myRef = new Reference(DispatcherDelegate.class.getName(), DispatcherFactory.class.getName(), null);
/*    */ 
/* 51 */     myRef.add(new StringRefAddr("manager.hostname", this.hostname));
/*    */ 
/* 53 */     return myRef;
/*    */   }
/*    */ 
/*    */   private SubscriptionManagerMBean getSubscriptionManager()
/*    */   {
/* 58 */     if (null == this.subscriptionManager)
/*    */     {
/*    */       try
/*    */       {
/* 62 */         ObjectName objectName = SubscriptionManager.OBJECT_NAME;
/* 63 */         this.subscriptionManager = ((SubscriptionManagerMBean)MBeanServerInvocationHandler.newProxyInstance(getServer(), objectName, SubscriptionManagerMBean.class, false));
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 68 */         throw new WSException("Failed to access subscription manager: " + e.getMessage());
/*    */       }
/*    */     }
/*    */ 
/* 72 */     return this.subscriptionManager;
/*    */   }
/*    */ 
/*    */   private MBeanServerConnection getServer()
/*    */     throws NamingException
/*    */   {
/* 78 */     InitialContext iniCtx = new InitialContext();
/* 79 */     MBeanServerConnection server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
/* 80 */     return server;
/*    */   }
/*    */ 
/*    */   void setHostname(String hostname)
/*    */   {
/* 85 */     if (null == hostname)
/* 86 */       throw new IllegalArgumentException("Hostname may not be null");
/* 87 */     this.hostname = hostname;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.mgmt.DispatcherDelegate
 * JD-Core Version:    0.6.0
 */