/*    */ package org.jboss.ws.extensions.addressing.soap;
/*    */ 
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.ws.addressing.AddressingConstants;
/*    */ import javax.xml.ws.addressing.AddressingProperties;
/*    */ import javax.xml.ws.addressing.AttributedQName;
/*    */ import javax.xml.ws.addressing.AttributedURI;
/*    */ import javax.xml.ws.addressing.EndpointReference;
/*    */ import javax.xml.ws.addressing.Relationship;
/*    */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*    */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*    */ import org.jboss.ws.extensions.addressing.AddressingTypeImpl;
/*    */ import org.jboss.ws.extensions.addressing.AttributedQNameImpl;
/*    */ import org.jboss.ws.extensions.addressing.AttributedURIImpl;
/*    */ import org.jboss.ws.extensions.addressing.EndpointReferenceImpl;
/*    */ import org.jboss.ws.extensions.addressing.RelationshipImpl;
/*    */ 
/*    */ public class SOAPAddressingBuilderImpl extends SOAPAddressingBuilder
/*    */ {
/*    */   public AttributedURI newURI(URI uri)
/*    */   {
/* 55 */     return new AttributedURIImpl(uri);
/*    */   }
/*    */ 
/*    */   public AttributedURI newURI(String uri) throws URISyntaxException
/*    */   {
/* 60 */     return newURI(new URI(uri));
/*    */   }
/*    */ 
/*    */   public AttributedQName newQName(QName name)
/*    */   {
/* 65 */     return new AttributedQNameImpl(name);
/*    */   }
/*    */ 
/*    */   public Relationship newRelationship(URI uri)
/*    */   {
/* 70 */     return new RelationshipImpl(uri);
/*    */   }
/*    */ 
/*    */   public EndpointReference newEndpointReference(URI uri)
/*    */   {
/* 75 */     return new EndpointReferenceImpl(uri);
/*    */   }
/*    */ 
/*    */   public AddressingProperties newAddressingProperties()
/*    */   {
/* 80 */     return new SOAPAddressingPropertiesImpl();
/*    */   }
/*    */ 
/*    */   public AddressingConstants newAddressingConstants()
/*    */   {
/* 85 */     return new AddressingConstantsImpl();
/*    */   }
/*    */ 
/*    */   public String getNamespaceURI()
/*    */   {
/* 90 */     return new AddressingTypeImpl().getNamespaceURI();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl
 * JD-Core Version:    0.6.0
 */