/*     */ package org.jboss.ws.extensions.addressing.jaxws;
/*     */ 
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import javax.xml.ws.handler.soap.SOAPMessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ 
/*     */ public class WSAddressingServerHandler extends GenericSOAPHandler
/*     */ {
/*  56 */   private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
/*     */   private static AddressingBuilder ADDR_BUILDER;
/*     */   private static AddressingConstantsImpl ADDR_CONSTANTS;
/*  60 */   private static Set<QName> HEADERS = new HashSet();
/*     */ 
/*     */   public Set getHeaders()
/*     */   {
/*  73 */     return Collections.unmodifiableSet(HEADERS);
/*     */   }
/*     */ 
/*     */   protected boolean handleInbound(MessageContext msgContext)
/*     */   {
/*  78 */     if (log.isDebugEnabled()) log.debug("handleInbound");
/*     */ 
/*  80 */     SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
/*  81 */     SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*  82 */     addrProps.readHeaders(soapMessage);
/*  83 */     msgContext.put("javax.xml.ws.addressing.context.inbound", addrProps);
/*  84 */     msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
/*     */ 
/*  86 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean handleOutbound(MessageContext msgContext)
/*     */   {
/*  91 */     if (log.isDebugEnabled()) log.debug("handleOutbound");
/*  92 */     handleResponseOrFault(msgContext, false);
/*  93 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext)
/*     */   {
/* 102 */     if (log.isDebugEnabled()) log.debug("handleFault");
/* 103 */     handleResponseOrFault(msgContext, true);
/* 104 */     return true;
/*     */   }
/*     */ 
/*     */   private void handleResponseOrFault(MessageContext msgContext, boolean isFault)
/*     */   {
/* 109 */     SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
/* 110 */     SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*     */ 
/* 112 */     SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
/* 113 */     SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
/*     */ 
/* 115 */     if (outProps == null)
/*     */     {
/* 118 */       outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
/* 119 */       msgContext.put("javax.xml.ws.addressing.context.outbound", outProps);
/* 120 */       msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
/*     */     }
/*     */ 
/* 123 */     outProps.initializeAsReply(inProps, isFault);
/*     */     try
/*     */     {
/* 129 */       OperationMetaData opMetaData = ((CommonMessageContext)msgContext).getOperationMetaData();
/*     */ 
/* 131 */       if ((!isFault) && (!opMetaData.isOneWay()))
/*     */       {
/* 134 */         AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
/* 135 */         if (addrExt != null)
/*     */         {
/* 137 */           outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
/*     */         }
/*     */         else
/*     */         {
/* 141 */           log.warn("Unable to resolve replyAction for " + opMetaData.getQName());
/*     */         }
/*     */ 
/*     */       }
/* 145 */       else if (isFault)
/*     */       {
/* 147 */         outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 153 */       log.error("Error setting response action", e);
/*     */     }
/*     */ 
/* 156 */     outProps.writeHeaders(soapMessage);
/*     */   }
/*     */ 
/*     */   private void validateRequest(SOAPAddressingProperties addrProps)
/*     */   {
/* 163 */     if ((addrProps.getReplyTo() != null) && (addrProps.getMessageID() == null))
/* 164 */       throw new IllegalArgumentException("wsa:MessageId is required when wsa:ReplyTo is supplied");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  64 */     ADDR_CONSTANTS = new AddressingConstantsImpl();
/*  65 */     ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
/*     */ 
/*  67 */     HEADERS.add(ADDR_CONSTANTS.getActionQName());
/*  68 */     HEADERS.add(ADDR_CONSTANTS.getToQName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.jaxws.WSAddressingServerHandler
 * JD-Core Version:    0.6.0
 */