/*    */ package org.jboss.ws.core.utils;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.soap.SOAPElement;
/*    */ import javax.xml.soap.SOAPException;
/*    */ 
/*    */ public class SAAJUtils
/*    */ {
/*    */   public static void setQualifiedElementValue(SOAPElement element, QName value)
/*    */     throws SOAPException
/*    */   {
/* 42 */     String prefix = ensureNamespaceDeclared(element, value.getPrefix(), value.getNamespaceURI());
/* 43 */     element.setValue(prefix + ':' + value.getLocalPart());
/*    */   }
/*    */ 
/*    */   public static void setQualifiedAttributeValue(SOAPElement element, String attributeName, QName value)
/*    */     throws SOAPException
/*    */   {
/* 51 */     String prefix = ensureNamespaceDeclared(element, value.getPrefix(), value.getNamespaceURI());
/* 52 */     element.setAttribute(attributeName, prefix + ':' + value.getLocalPart());
/*    */   }
/*    */ 
/*    */   private static String ensureNamespaceDeclared(SOAPElement element, String prefix, String nsURI)
/*    */     throws SOAPException
/*    */   {
/* 59 */     if (prefix.length() == 0)
/*    */     {
/* 62 */       prefix = getNamespacePrefix(element, nsURI);
/* 63 */       if (prefix == null)
/*    */       {
/* 66 */         prefix = "valueNS";
/* 67 */         element.addNamespaceDeclaration(prefix, nsURI);
/*    */       }
/*    */ 
/*    */     }
/* 71 */     else if (!nsURI.equals(element.getNamespaceURI(prefix)))
/*    */     {
/* 74 */       element.addNamespaceDeclaration(prefix, nsURI);
/*    */     }
/* 76 */     return prefix;
/*    */   }
/*    */ 
/*    */   public static String getNamespacePrefix(SOAPElement element, String nsURI)
/*    */   {
/* 86 */     Iterator it = element.getVisibleNamespacePrefixes();
/* 87 */     while (it.hasNext())
/*    */     {
/* 89 */       String prefix = (String)it.next();
/* 90 */       if (nsURI.equals(element.getNamespaceURI(prefix)))
/* 91 */         return prefix;
/*    */     }
/* 93 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.SAAJUtils
 * JD-Core Version:    0.6.0
 */