/*    */ package org.jboss.ws.core.utils;
/*    */ 
/*    */ import javax.xml.parsers.DocumentBuilder;
/*    */ import javax.xml.parsers.DocumentBuilderFactory;
/*    */ import javax.xml.parsers.ParserConfigurationException;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class DocumentBuilderFactoryImpl extends DocumentBuilderFactory
/*    */ {
/* 40 */   private static Logger log = Logger.getLogger(DocumentBuilderFactoryImpl.class);
/*    */   public static final String XERCES_DOCUMENT_BUILDER_FACTORY = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
/*    */   private DocumentBuilderFactory delegate;
/*    */ 
/*    */   public DocumentBuilderFactoryImpl()
/*    */   {
/*    */     try
/*    */     {
/* 50 */       ClassLoader classLoader = getClass().getClassLoader();
/* 51 */       Class clazz = classLoader.loadClass("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
/* 52 */       this.delegate = ((DocumentBuilderFactory)clazz.newInstance());
/*    */ 
/* 55 */       this.delegate.setNamespaceAware(true);
/*    */     }
/*    */     catch (Exception ex)
/*    */     {
/* 59 */       throw new IllegalStateException("Cannot create delegate document builder factory: org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", ex);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object getAttribute(String name) throws IllegalArgumentException
/*    */   {
/* 65 */     return this.delegate.getAttribute(name);
/*    */   }
/*    */ 
/*    */   public boolean getFeature(String name) throws ParserConfigurationException
/*    */   {
/* 70 */     return this.delegate.getFeature(name);
/*    */   }
/*    */ 
/*    */   public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException
/*    */   {
/* 75 */     DocumentBuilder builder = this.delegate.newDocumentBuilder();
/* 76 */     builder.setEntityResolver(new JBossWSEntityResolver());
/* 77 */     return builder;
/*    */   }
/*    */ 
/*    */   public void setAttribute(String name, Object value) throws IllegalArgumentException
/*    */   {
/* 82 */     this.delegate.setAttribute(name, value);
/*    */   }
/*    */ 
/*    */   public void setFeature(String name, boolean value) throws ParserConfigurationException
/*    */   {
/* 87 */     this.delegate.setFeature(name, value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.DocumentBuilderFactoryImpl
 * JD-Core Version:    0.6.0
 */