/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import javax.activation.DataSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ 
/*     */ public class SwapableMemoryDataSource
/*     */   implements DataSource
/*     */ {
/*  46 */   private static Logger log = Logger.getLogger(SwapableMemoryDataSource.class);
/*     */   private static final int BLOCK_SIZE = 32768;
/*     */   private static final int DEFAULT_MAX_MEMORY_SIZE = 65536;
/*     */   private static final String SWAP_PREFIX = "JBossWSattachment";
/*     */   private static final String SWAP_SUFFIX = ".dat";
/*     */   private File swapFile;
/*  58 */   private String contentType = "application/octet-stream";
/*     */   private byte[] content;
/*     */   private int contentLength;
/*  64 */   private int maxMemorySize = 65536;
/*     */ 
/*     */   public SwapableMemoryDataSource(InputStream inputStream, String contentType)
/*     */     throws IOException
/*     */   {
/*  78 */     this(inputStream, contentType, 65536);
/*     */   }
/*     */ 
/*     */   public SwapableMemoryDataSource(InputStream inputStream, String contentType, int maxMemorySize)
/*     */     throws IOException
/*     */   {
/*  94 */     if (contentType != null) {
/*  95 */       this.contentType = contentType;
/*     */     }
/*  97 */     this.maxMemorySize = maxMemorySize;
/*     */ 
/*  99 */     load(inputStream);
/*     */   }
/*     */ 
/*     */   private void load(InputStream inputStream) throws IOException
/*     */   {
/* 104 */     RawByteArrayOutputStream rbaos = new RawByteArrayOutputStream();
/* 105 */     OutputStream os = rbaos;
/*     */ 
/* 107 */     byte[] buffer = new byte[32768];
/* 108 */     int count = inputStream.read(buffer);
/* 109 */     while (count > 0) {
/* 110 */       os.write(buffer, 0, count);
/*     */ 
/* 112 */       if ((rbaos != null) && (rbaos.size() > this.maxMemorySize))
/*     */       {
/* 114 */         File tmpdir = IOUtils.createTempDirectory();
/* 115 */         this.swapFile = File.createTempFile("JBossWSattachment", ".dat", tmpdir);
/* 116 */         this.swapFile.deleteOnExit();
/* 117 */         os = new FileOutputStream(this.swapFile);
/* 118 */         rbaos.writeTo(os);
/* 119 */         rbaos = null;
/*     */       }
/*     */ 
/* 122 */       count = inputStream.read(buffer);
/*     */     }
/*     */ 
/* 125 */     os.flush();
/* 126 */     os.close();
/*     */ 
/* 128 */     if (rbaos == null)
/*     */     {
/* 130 */       if (log.isDebugEnabled()) log.debug("Using swap file, location = " + this.swapFile.toURL() + " size = " + this.swapFile.length());
/*     */     }
/*     */     else
/*     */     {
/* 134 */       this.contentLength = rbaos.size();
/* 135 */       if (log.isDebugEnabled()) log.debug("Using memory buffer, size = " + this.contentLength);
/* 136 */       this.content = rbaos.getBytes();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 142 */     super.finalize();
/* 143 */     cleanup();
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */   {
/* 148 */     if (this.swapFile != null)
/* 149 */       this.swapFile.delete();
/*     */   }
/*     */ 
/*     */   public String getContentType()
/*     */   {
/* 159 */     return this.contentType;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws IOException
/*     */   {
/* 170 */     if (this.content != null) {
/* 171 */       return new ByteArrayInputStream(this.content, 0, this.contentLength);
/*     */     }
/* 173 */     if (this.swapFile != null) {
/* 174 */       return new FileInputStream(this.swapFile);
/*     */     }
/* 176 */     throw new WSException("No content available");
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 186 */     return null;
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */     throws IOException
/*     */   {
/* 196 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource
 * JD-Core Version:    0.6.0
 */