/*    */ package org.jboss.ws.core.soap.attachment;
/*    */ 
/*    */ import javax.mail.MessagingException;
/*    */ import javax.mail.internet.MimeBodyPart;
/*    */ import javax.mail.internet.MimeMultipart;
/*    */ import javax.mail.internet.ParameterList;
/*    */ import javax.xml.soap.SOAPEnvelope;
/*    */ import javax.xml.soap.SOAPException;
/*    */ import javax.xml.soap.SOAPPart;
/*    */ import org.jboss.ws.core.soap.SOAPElementImpl;
/*    */ import org.jboss.ws.core.soap.SOAPElementWriter;
/*    */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*    */ 
/*    */ public class MultipartRelatedSwAEncoder extends MultipartRelatedEncoder
/*    */ {
/*    */   public MultipartRelatedSwAEncoder(SOAPMessageImpl soapMessage)
/*    */     throws SOAPException
/*    */   {
/* 54 */     super(soapMessage);
/*    */   }
/*    */ 
/*    */   public void encodeMultipartRelatedMessage() throws SOAPException, MessagingException
/*    */   {
/* 59 */     ParameterList p = new ParameterList();
/* 60 */     p.set("type", "text/xml");
/* 61 */     p.set("start", "<rootpart@ws.jboss.org>");
/*    */ 
/* 63 */     MimeMultipart multipart = new MimeMultipart("related" + p);
/* 64 */     MimeBodyPart rootPart = new MimeBodyPart();
/*    */ 
/* 72 */     SOAPEnvelope soapEnv = this.soapMessage.getSOAPPart().getEnvelope();
/* 73 */     String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, false);
/* 74 */     rootPart.setText(envStr, "UTF-8");
/*    */ 
/* 76 */     rootPart.setContentID("<rootpart@ws.jboss.org>");
/* 77 */     rootPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
/* 78 */     rootPart.setHeader("Content-Transfer-Encoding", "8bit");
/*    */ 
/* 80 */     multipart.addBodyPart(rootPart);
/*    */ 
/* 82 */     addAttachmentParts(multipart);
/*    */ 
/* 84 */     this.multipart = multipart;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.MultipartRelatedSwAEncoder
 * JD-Core Version:    0.6.0
 */