/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Iterator;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.mail.MessagingException;
/*     */ import javax.mail.internet.MimeBodyPart;
/*     */ import javax.mail.internet.MimeMultipart;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MimeHeader;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ 
/*     */ public abstract class MultipartRelatedEncoder
/*     */ {
/*     */   protected SOAPMessageImpl soapMessage;
/*     */   protected MimeMultipart multipart;
/*     */ 
/*     */   public MultipartRelatedEncoder(SOAPMessageImpl soapMessage)
/*     */     throws SOAPException
/*     */   {
/*  54 */     this.soapMessage = soapMessage;
/*     */   }
/*     */ 
/*     */   public abstract void encodeMultipartRelatedMessage() throws SOAPException, MessagingException;
/*     */ 
/*     */   protected void addAttachmentParts(MimeMultipart multipart) throws SOAPException, MessagingException
/*     */   {
/*  62 */     Iterator attachmentParts = this.soapMessage.getAttachments();
/*  63 */     while (attachmentParts.hasNext())
/*     */     {
/*  65 */       AttachmentPart attachmentPart = (AttachmentPart)attachmentParts.next();
/*  66 */       DataHandler handler = attachmentPart.getDataHandler();
/*  67 */       MimeBodyPart mimePart = new MimeBodyPart();
/*  68 */       mimePart.setDataHandler(handler);
/*     */ 
/*  70 */       Iterator mimeHeaders = attachmentPart.getAllMimeHeaders();
/*  71 */       while (mimeHeaders.hasNext())
/*     */       {
/*  73 */         MimeHeader soapHeader = (MimeHeader)mimeHeaders.next();
/*  74 */         mimePart.addHeader(soapHeader.getName(), soapHeader.getValue());
/*     */       }
/*     */ 
/*  77 */       if (mimePart.getHeader("Content-Type") == null)
/*     */       {
/*  79 */         String type = handler.getContentType();
/*  80 */         mimePart.setHeader("Content-Type", type != null ? type : "application/octet-stream");
/*     */       }
/*     */ 
/*  83 */       if (mimePart.getHeader("Content-Id") == null)
/*     */       {
/*  85 */         CIDGenerator cidGenerator = this.soapMessage.getCidGenerator();
/*  86 */         mimePart.setHeader("Content-Id", cidGenerator.generateFromCount());
/*     */       }
/*     */ 
/*  91 */       mimePart.setHeader("Content-Transfer-Encoding", "binary");
/*     */ 
/*  93 */       multipart.addBodyPart(mimePart);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getContentType()
/*     */   {
/* 106 */     String contentType = this.multipart.getContentType();
/* 107 */     return contentType;
/*     */   }
/*     */ 
/*     */   public void writeTo(OutputStream os)
/*     */     throws IOException
/*     */   {
/* 117 */     if (this.multipart == null) {
/* 118 */       throw new IOException("No data to write because encoding failed on construction");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 123 */       os.write(13);
/* 124 */       os.write(10);
/* 125 */       this.multipart.writeTo(os);
/*     */     }
/*     */     catch (MessagingException e)
/*     */     {
/* 129 */       throw new IOException(e.getMessage());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.MultipartRelatedEncoder
 * JD-Core Version:    0.6.0
 */