/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Iterator;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.mail.internet.MimeMultipart;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.util.Base64;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ 
/*     */ public class AttachmentPartImpl extends AttachmentPart
/*     */ {
/*  46 */   private MimeHeaders mimeHeaders = new MimeHeaders();
/*     */   private DataHandler dataHandler;
/*     */   private String cachedContentId;
/*     */   private String cachedContentType;
/*     */   private String cachedContentLocation;
/*     */ 
/*     */   public AttachmentPartImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AttachmentPartImpl(DataHandler handler)
/*     */   {
/*  68 */     this.dataHandler = handler;
/*     */   }
/*     */ 
/*     */   private void clearHeaderCache()
/*     */   {
/*  73 */     this.cachedContentId = null;
/*  74 */     this.cachedContentType = null;
/*  75 */     this.cachedContentLocation = null;
/*     */   }
/*     */ 
/*     */   public void addMimeHeader(String name, String value)
/*     */   {
/*  80 */     clearHeaderCache();
/*  81 */     this.mimeHeaders.addHeader(name, value);
/*     */   }
/*     */ 
/*     */   public void clearContent()
/*     */   {
/*  86 */     this.dataHandler = null;
/*     */   }
/*     */ 
/*     */   public Iterator getAllMimeHeaders()
/*     */   {
/*  91 */     clearHeaderCache();
/*  92 */     return this.mimeHeaders.getAllHeaders();
/*     */   }
/*     */ 
/*     */   public Object getContent() throws SOAPException
/*     */   {
/*  97 */     if (this.dataHandler == null) {
/*  98 */       throw new SOAPException("No content available");
/*     */     }
/*     */     try
/*     */     {
/* 102 */       return this.dataHandler.getContent();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 106 */     throw new SOAPException(e);
/*     */   }
/*     */ 
/*     */   public DataHandler getDataHandler()
/*     */     throws SOAPException
/*     */   {
/* 112 */     if (this.dataHandler == null) {
/* 113 */       throw new SOAPException("No data handler on attachment");
/*     */     }
/* 115 */     return this.dataHandler;
/*     */   }
/*     */ 
/*     */   public Iterator getMatchingMimeHeaders(String[] names)
/*     */   {
/* 120 */     clearHeaderCache();
/* 121 */     return this.mimeHeaders.getMatchingHeaders(names);
/*     */   }
/*     */ 
/*     */   public String[] getMimeHeader(String name)
/*     */   {
/* 126 */     return this.mimeHeaders.getHeader(name);
/*     */   }
/*     */ 
/*     */   public String getFirstMimeHeader(String header)
/*     */   {
/* 137 */     String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
/* 138 */     if ((values != null) && (values.length > 0))
/*     */     {
/* 140 */       return values[0];
/*     */     }
/* 142 */     return null;
/*     */   }
/*     */ 
/*     */   public Iterator getNonMatchingMimeHeaders(String[] names)
/*     */   {
/* 147 */     clearHeaderCache();
/* 148 */     return this.mimeHeaders.getNonMatchingHeaders(names);
/*     */   }
/*     */ 
/*     */   public int getSize() throws SOAPException
/*     */   {
/* 153 */     if (this.dataHandler == null) {
/* 154 */       return 0;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 159 */       if (!(this.dataHandler.getDataSource() instanceof ByteArrayDataSource)) {
/* 160 */         this.dataHandler = new DataHandler(new ByteArrayDataSource(this.dataHandler.getInputStream(), this.dataHandler.getContentType()));
/*     */       }
/* 162 */       ByteArrayDataSource ds = (ByteArrayDataSource)this.dataHandler.getDataSource();
/* 163 */       return ds.getSize();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 167 */     throw new SOAPException(e);
/*     */   }
/*     */ 
/*     */   public void removeAllMimeHeaders()
/*     */   {
/* 173 */     clearHeaderCache();
/* 174 */     this.mimeHeaders.removeAllHeaders();
/*     */   }
/*     */ 
/*     */   public void removeMimeHeader(String name)
/*     */   {
/* 179 */     clearHeaderCache();
/* 180 */     this.mimeHeaders.removeHeader(name);
/*     */   }
/*     */ 
/*     */   public void setContent(Object object, String contentType)
/*     */   {
/* 198 */     if ((object instanceof MimeMultipart)) {
/* 199 */       contentType = ((MimeMultipart)object).getContentType();
/*     */     }
/* 201 */     this.dataHandler = new DataHandler(object, contentType);
/*     */ 
/* 203 */     setContentType(contentType);
/*     */   }
/*     */ 
/*     */   public void setDataHandler(DataHandler dataHandler)
/*     */   {
/* 208 */     if (dataHandler == null) {
/* 209 */       throw new IllegalArgumentException("Null data handler");
/*     */     }
/* 211 */     this.dataHandler = dataHandler;
/* 212 */     setContentType(dataHandler.getContentType());
/*     */   }
/*     */ 
/*     */   public void setMimeHeader(String name, String value)
/*     */   {
/* 217 */     clearHeaderCache();
/* 218 */     this.mimeHeaders.setHeader(name, value);
/*     */   }
/*     */ 
/*     */   public String getContentId()
/*     */   {
/* 223 */     if (this.cachedContentId == null)
/*     */     {
/* 225 */       this.cachedContentId = getFirstMimeHeader("Content-Id");
/*     */     }
/*     */ 
/* 228 */     return this.cachedContentId;
/*     */   }
/*     */ 
/*     */   public String getContentLocation()
/*     */   {
/* 233 */     if (this.cachedContentLocation == null)
/*     */     {
/* 235 */       this.cachedContentLocation = getFirstMimeHeader("Content-Location");
/*     */     }
/*     */ 
/* 238 */     return this.cachedContentLocation;
/*     */   }
/*     */ 
/*     */   public String getContentType()
/*     */   {
/* 243 */     if (this.cachedContentType == null)
/*     */     {
/* 245 */       this.cachedContentType = getFirstMimeHeader("Content-Type");
/*     */     }
/*     */ 
/* 248 */     return this.cachedContentType;
/*     */   }
/*     */ 
/*     */   public void setContentId(String contentId)
/*     */   {
/* 253 */     setMimeHeader("Content-Id", contentId);
/* 254 */     this.cachedContentId = contentId;
/*     */   }
/*     */ 
/*     */   public void setContentLocation(String contentLocation)
/*     */   {
/* 259 */     setMimeHeader("Content-Location", contentLocation);
/* 260 */     this.cachedContentLocation = contentLocation;
/*     */   }
/*     */ 
/*     */   public void setContentType(String contentType)
/*     */   {
/* 265 */     setMimeHeader("Content-Type", contentType);
/* 266 */     this.cachedContentType = contentType;
/*     */   }
/*     */ 
/*     */   public InputStream getBase64Content()
/*     */     throws SOAPException
/*     */   {
/* 280 */     ByteArrayOutputStream bout = new ByteArrayOutputStream();
/*     */     try
/*     */     {
/* 284 */       IOUtils.copyStream(bout, getDataHandler().getInputStream());
/* 285 */       String base64 = Base64.encodeBytes(bout.toByteArray());
/* 286 */       return new ByteArrayInputStream(base64.getBytes());
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 290 */     throw new SOAPException(e);
/*     */   }
/*     */ 
/*     */   public InputStream getRawContent()
/*     */     throws SOAPException
/*     */   {
/*     */     try
/*     */     {
/* 312 */       return getDataHandler().getInputStream();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 316 */     throw new SOAPException(e);
/*     */   }
/*     */ 
/*     */   public byte[] getRawContentBytes()
/*     */     throws SOAPException
/*     */   {
/* 331 */     ByteArrayOutputStream bout = new ByteArrayOutputStream();
/*     */     try
/*     */     {
/* 334 */       IOUtils.copyStream(bout, getDataHandler().getInputStream());
/* 335 */       return bout.toByteArray();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 339 */     throw new SOAPException(e);
/*     */   }
/*     */ 
/*     */   public void setBase64Content(InputStream content, String contentType)
/*     */     throws SOAPException
/*     */   {
/* 359 */     if (null == content) {
/* 360 */       throw new SOAPException("Content is null");
/*     */     }try {
/* 364 */       ByteArrayOutputStream bout = new ByteArrayOutputStream();
/* 365 */       IOUtils.copyStream(bout, content);
/* 366 */       content.close();
/* 367 */       byte[] bytes = bout.toByteArray();
/*     */       byte[] raw;
/*     */       try {
/* 373 */         raw = Base64.decode(bytes, 0, bytes.length);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 377 */         throw new SOAPException(e);
/*     */       }
/*     */ 
/* 380 */       this.dataHandler = new DataHandler(new ByteArrayDataSource(raw, contentType));
/* 381 */       setContentType(contentType);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 386 */       throw new SOAPException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRawContent(InputStream content, String contentType)
/*     */     throws SOAPException
/*     */   {
/* 404 */     if (null == content) {
/* 405 */       throw new SOAPException("Content is null");
/*     */     }
/* 407 */     this.dataHandler = new DataHandler(new ByteArrayDataSource(content, contentType));
/* 408 */     setContentType(contentType);
/*     */   }
/*     */ 
/*     */   public void setRawContentBytes(byte[] content, int offset, int len, String contentType)
/*     */     throws SOAPException
/*     */   {
/* 426 */     setRawContent(new ByteArrayInputStream(content, offset, len), contentType);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  59 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ 
/*     */   class ByteArrayDataSource
/*     */     implements DataSource
/*     */   {
/*     */     private byte[] data;
/*     */     private String type;
/*     */ 
/*     */     ByteArrayDataSource(InputStream is, String type)
/*     */     {
/* 435 */       this.type = type;
/*     */       try {
/* 437 */         os = new ByteArrayOutputStream();
/* 438 */         IOUtils.copyStream(os, is);
/* 439 */         this.data = os.toByteArray();
/*     */       }
/*     */       catch (IOException ioex)
/*     */       {
/*     */         ByteArrayOutputStream os;
/* 441 */         throw new WSException(ioex);
/*     */       }
/*     */     }
/*     */ 
/*     */     ByteArrayDataSource(byte[] data, String type) {
/* 446 */       this.data = data;
/* 447 */       this.type = type;
/*     */     }
/*     */ 
/*     */     ByteArrayDataSource(String data, String type) {
/*     */       try {
/* 452 */         this.data = data.getBytes("iso-8859-1");
/*     */       } catch (UnsupportedEncodingException uex) {
/* 454 */         throw new WSException(uex);
/*     */       }
/* 456 */       this.type = type;
/*     */     }
/*     */ 
/*     */     public InputStream getInputStream() throws IOException {
/* 460 */       if (this.data == null)
/* 461 */         throw new IOException("no data");
/* 462 */       return new ByteArrayInputStream(this.data);
/*     */     }
/*     */ 
/*     */     public OutputStream getOutputStream() throws IOException {
/* 466 */       throw new IOException("cannot do this");
/*     */     }
/*     */ 
/*     */     public String getContentType() {
/* 470 */       return this.type;
/*     */     }
/*     */ 
/*     */     public String getName() {
/* 474 */       return "ByteArrayDataSource";
/*     */     }
/*     */ 
/*     */     public int getSize() {
/* 478 */       return this.data.length;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.AttachmentPartImpl
 * JD-Core Version:    0.6.0
 */