/*    */ package org.jboss.ws.core.soap;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.OutputStream;
/*    */ import javax.xml.soap.SOAPMessage;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.invocation.OnewayInvocation;
/*    */ import org.jboss.remoting.marshal.Marshaller;
/*    */ 
/*    */ public class SOAPMessageMarshaller
/*    */   implements Marshaller
/*    */ {
/* 41 */   private static Logger log = Logger.getLogger(SOAPMessageMarshaller.class);
/*    */ 
/*    */   public void write(Object dataObject, OutputStream output)
/*    */     throws IOException
/*    */   {
/* 54 */     if ((dataObject instanceof InvocationRequest)) {
/* 55 */       dataObject = ((InvocationRequest)dataObject).getParameter();
/*    */     }
/* 57 */     if ((dataObject instanceof OnewayInvocation)) {
/* 58 */       dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
/*    */     }
/* 60 */     if (!(dataObject instanceof SOAPMessage)) {
/* 61 */       throw new IllegalArgumentException("Not a SOAPMessage: " + dataObject);
/*    */     }
/* 63 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)dataObject;
/* 64 */     soapMessage.writeTo(output);
/*    */   }
/*    */ 
/*    */   public Marshaller cloneMarshaller() throws CloneNotSupportedException
/*    */   {
/* 69 */     return new SOAPMessageMarshaller();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPMessageMarshaller
 * JD-Core Version:    0.6.0
 */